/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.discover.impl;

import com.trs.infra.discover.DiscoveryFactory;
import com.trs.infra.discover.IDiscovery;
import com.trs.infra.discover.impl.ContainerByDir;
import com.trs.infra.discover.impl.ContainerByZip;
import com.trs.infra.discover.impl.Discovery;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class FactoryByFiles
extends DiscoveryFactory {
    private File[] m_oInitLibs;
    private File[] m_oInitDirs;

    public FactoryByFiles(File[] libs, File[] dirs) {
        this.m_oInitLibs = libs;
        this.m_oInitDirs = dirs;
    }

    public IDiscovery build() {
        File path;
        int i;
        Discovery discovery = new Discovery();
        if (this.m_oInitLibs != null) {
            i = 0;
            while (i < this.m_oInitLibs.length) {
                path = this.m_oInitLibs[i];
                if (path != null && path.exists()) {
                    this.recursionLibrary(discovery, path);
                }
                ++i;
            }
        }
        if (this.m_oInitDirs != null) {
            i = 0;
            while (i < this.m_oInitDirs.length) {
                path = this.m_oInitDirs[i];
                if (path != null && path.exists() && path.isDirectory()) {
                    this.buidDirectoryContainer(discovery, path);
                }
                ++i;
            }
        }
        discovery.analyze();
        discovery.trimMemory();
        return discovery;
    }

    private void buidDirectoryContainer(Discovery discovery, File path) {
        try {
            URL url = path.toURI().toURL();
            String prefixpath = path.getAbsolutePath().replace('\\', '/');
            ContainerByDir container = new ContainerByDir(url, prefixpath);
            this.recursionDirectory(container, path);
            discovery.addContainer(container);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void recursionDirectory(ContainerByDir container, File path) throws IOException {
        File[] files = path.listFiles();
        if (files == null || files.length <= 0) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String subpath = file.getAbsolutePath().replace('\\', '/');
            if (file.isDirectory()) {
                container.trimDirectory(subpath);
                this.recursionDirectory(container, file);
            } else {
                URL url = file.toURI().toURL();
                container.trimResourceAny(subpath, url);
            }
            ++i;
        }
    }

    private void recursionLibrary(Discovery discovery, File path) {
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                this.recursionLibrary(discovery, files[i]);
                ++i;
            }
        } else {
            String name = path.getName().toLowerCase();
            if (name.endsWith(".jar") || name.endsWith(".zip")) {
                this.buidLibraryContainer(discovery, path);
            }
        }
    }

    private void buidLibraryContainer(Discovery discovery, File path) {
        try {
            ContainerByZip container = new ContainerByZip(path.toURI().toURL());
            container.load();
            discovery.addContainer(container);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

