/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.discover.impl;

import com.trs.infra.discover.IDiscovery;
import com.trs.infra.discover.IType;
import com.trs.infra.discover.impl.Container;
import com.trs.infra.discover.impl.DFTFrame;
import com.trs.infra.discover.impl.FilterType;
import com.trs.infra.discover.impl.IteratorEmpty;
import com.trs.infra.discover.impl.IteratorProxy;
import com.trs.infra.discover.impl.IteratorUnion;
import com.trs.infra.discover.impl.Node;
import com.trs.infra.discover.impl.NodeResource;
import com.trs.infra.discover.impl.NodeType;
import com.trs.infra.discover.impl.Utils;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class Discovery
implements IDiscovery {
    private List m_oContainers = new ArrayList();

    void addContainer(Container container) {
        this.m_oContainers.add(container);
    }

    public void cleanup() {
        Iterator itr = this.m_oContainers.iterator();
        while (itr.hasNext()) {
            Container c = (Container)itr.next();
            if (c == null) continue;
            c.cleanup();
        }
        this.m_oContainers.clear();
        this.m_oContainers = null;
    }

    public void tree(PrintWriter pw) {
        pw.println("com.trs.infra.discover.impl.Discovery");
        List list = this.m_oContainers;
        int limit = list.size() - 1;
        int i = 0;
        while (i <= limit) {
            String p = null;
            Container c = (Container)list.get(i);
            if (i == limit) {
                pw.print("\u2514\u2500");
                p = "    ";
            } else {
                pw.print("\u251c\u2500");
                p = "\u2502  ";
            }
            pw.println(c.getLocation());
            c.tree(pw, p);
            ++i;
        }
    }

    void analyze() {
        HashMap<String, NodeType> mapTypes = new HashMap<String, NodeType>();
        List list = this.m_oContainers;
        int limit = list.size() - 1;
        int i = 0;
        while (i <= limit) {
            Container c = (Container)list.get(i);
            Iterator itr = c.findTypes(null);
            while (itr.hasNext()) {
                NodeType node = (NodeType)itr.next();
                NodeType olda = (NodeType)mapTypes.get(node.getQFName());
                if (olda != null) {
                    olda.addCollision(node);
                    continue;
                }
                mapTypes.put(node.getQFName(), node);
            }
            ++i;
        }
        Iterator itrAllType = mapTypes.values().iterator();
        while (itrAllType.hasNext()) {
            NodeType oSuperType;
            NodeType node = (NodeType)itrAllType.next();
            String sQFSuperName = node.getQFSuperName();
            if (!this.isIgnoreType(sQFSuperName) && (oSuperType = (NodeType)mapTypes.get(sQFSuperName)) != null) {
                oSuperType.addSubType(node);
            }
            Iterator itrQFIF = node.getQFInterfaces();
            while (itrQFIF.hasNext()) {
                NodeType oIFType;
                String sQFIF = (String)itrQFIF.next();
                if (this.isIgnoreType(sQFIF) || (oIFType = (NodeType)mapTypes.get(sQFIF)) == null) continue;
                oIFType.addImplementor(node);
            }
        }
    }

    private boolean isIgnoreType(String name) {
        return name.startsWith("java.");
    }

    void trimMemory() {
        Iterator itr = this.m_oContainers.iterator();
        while (itr.hasNext()) {
            Container c = (Container)itr.next();
            if (c == null) continue;
            c.trimMemory();
        }
        Utils.trimArrayList(this.m_oContainers);
    }

    private NodeResource getResourceByPath(String name) {
        String[] names = Container.splitPath(name);
        if (names == null || names.length <= 0) {
            throw new IllegalArgumentException("Invalid resource path:" + name);
        }
        List list = this.m_oContainers;
        int limitContainer = list.size() - 1;
        int i = 0;
        while (i <= limitContainer) {
            Container c = (Container)list.get(i);
            Node n = c.findNode(names);
            if (n instanceof NodeResource) {
                return (NodeResource)n;
            }
            ++i;
        }
        return null;
    }

    private NodeResource getResourceByName(String name) {
        List list = this.m_oContainers;
        int limitContainer = list.size() - 1;
        int i = 0;
        while (i <= limitContainer) {
            Container c = (Container)list.get(i);
            NodeResource n = c.findResource(name);
            if (n != null) {
                return n;
            }
            ++i;
        }
        return null;
    }

    public URL getResource(String name) {
        NodeResource node = null;
        node = name.indexOf(47) >= 0 ? this.getResourceByPath(name) : this.getResourceByName(name);
        if (node != null) {
            return node.getURL();
        }
        return null;
    }

    private Iterator getResourcesByPath(String name) {
        final String[] names = Container.splitPath(name);
        if (names == null || names.length <= 0) {
            throw new IllegalArgumentException("Invalid resource path:" + name);
        }
        Iterator itr = new Iterator(){
            private int m_iIndex = 0;
            private URL m_oFound;

            public void findNext() {
                if (this.m_oFound != null) {
                    return;
                }
                List list = Discovery.this.m_oContainers;
                while (this.m_iIndex < list.size()) {
                    Container c;
                    Node n;
                    if (!((n = (c = (Container)list.get(this.m_iIndex++)).findNode(names)) instanceof NodeResource)) continue;
                    this.m_oFound = ((NodeResource)n).getURL();
                    break;
                }
            }

            public boolean hasNext() {
                this.findNext();
                return this.m_oFound != null;
            }

            public Object next() {
                this.findNext();
                if (this.m_oFound != null) {
                    URL url = this.m_oFound;
                    this.m_oFound = null;
                    return url;
                }
                return null;
            }

            public void remove() {
            }
        };
        return itr;
    }

    private Iterator getResourcesByName(final String name) {
        IteratorUnion itr = new IteratorUnion(){
            private int index = 0;

            protected Iterator nextIterator() {
                List list = Discovery.this.m_oContainers;
                if (this.index < list.size()) {
                    Container c = (Container)list.get(this.index++);
                    return c.findResources(name);
                }
                return null;
            }

            public Object next() {
                Object obj = super.next();
                if (obj != null) {
                    return ((NodeResource)obj).getURL();
                }
                return null;
            }
        };
        return itr;
    }

    public Iterator getResources(String name) {
        if (name.indexOf(47) >= 0) {
            return this.getResourcesByPath(name);
        }
        return this.getResourcesByName(name);
    }

    public Iterator getSubTypes(String name) {
        NodeResource node = this.getResourceByPath(name = String.valueOf(name.replace('.', '/')) + ".class");
        if (node == null || !node.isJavaType()) {
            return null;
        }
        NodeType typeNode = (NodeType)node;
        if (typeNode.isFinal()) {
            return null;
        }
        if (typeNode.isClass()) {
            List list = typeNode.getSubTypes();
            if (list == null) {
                return IteratorEmpty.getEmptyIterator();
            }
            return new IteratorProxy(list.iterator()){

                public Object next() {
                    Object obj = super.next();
                    if (obj != null) {
                        return ((NodeType)obj).getQFName();
                    }
                    return null;
                }
            };
        }
        if (typeNode.isInterface()) {
            List listSub = typeNode.getSubTypes();
            List listIFs = typeNode.getImplementors();
            if (listSub == null && listIFs == null) {
                return IteratorEmpty.getEmptyIterator();
            }
            Iterator itr = new Iterator(listSub, listIFs){
                int index0 = 0;
                int index1 = 0;
                List[] lists;
                private NodeType m_oFound;
                {
                    this.lists = new List[]{list, list2};
                    this.m_oFound = null;
                }

                private void findNext() {
                    if (this.m_oFound != null) {
                        return;
                    }
                    List list = null;
                    while (this.index0 < this.lists.length) {
                        list = this.lists[this.index0];
                        if (list != null && this.index1 < list.size()) break;
                        ++this.index0;
                        this.index1 = 0;
                        list = null;
                    }
                    if (list != null) {
                        this.m_oFound = (NodeType)list.get(this.index1++);
                    }
                }

                public boolean hasNext() {
                    this.findNext();
                    return this.m_oFound != null;
                }

                public Object next() {
                    this.findNext();
                    if (this.m_oFound != null) {
                        NodeType nodetype = this.m_oFound;
                        this.m_oFound = null;
                        return nodetype.getQFName();
                    }
                    return null;
                }

                public void remove() {
                }
            };
            return itr;
        }
        return IteratorEmpty.getEmptyIterator();
    }

    public Iterator getImplementors(String name) {
        NodeResource resourceNode = this.getResourceByPath(name = String.valueOf(name.replace('.', '/')) + ".class");
        if (resourceNode == null || !resourceNode.isJavaType()) {
            return null;
        }
        NodeType typeNode = (NodeType)resourceNode;
        if (typeNode.isFinal()) {
            return null;
        }
        if (typeNode.isClass()) {
            List list = typeNode.getSubTypes();
            if (list == null) {
                return IteratorEmpty.getEmptyIterator();
            }
            Iterator itr = new Iterator(list){
                private DFTFrame m_oFrame;
                private Stack m_oStack;
                private NodeType m_oFound;
                {
                    this.m_oFrame = new DFTFrame(list);
                    this.m_oStack = new Stack();
                    this.m_oFound = null;
                }

                /*
                 * Unable to fully structure code
                 */
                public void findNext() {
                    if (this.m_oFound == null) ** GOTO lbl24
                    return;
                    {
                        node = null;
                        if ((node = (NodeType)this.m_oFrame.list.get(this.m_oFrame.index++)).hasSubType()) {
                            this.m_oFrame.node = node;
                            this.m_oStack.push(this.m_oFrame);
                            this.m_oFrame = new DFTFrame(node.getSubTypes());
                        } else if (!node.isAbstract()) {
                            this.m_oFound = node;
                            return;
                        }
                        do {
                            if (this.m_oFrame.index < this.m_oFrame.list.size()) continue block0;
                            this.m_oFrame = null;
                            if (this.m_oStack.size() > 0) {
                                this.m_oFrame = (DFTFrame)this.m_oStack.pop();
                            }
                            if (this.m_oFrame == null || this.m_oFrame.node == null) continue;
                            node = this.m_oFrame.node;
                            this.m_oFrame.node = null;
                            if (node.isAbstract()) continue;
                            this.m_oFound = node;
                            return;
lbl24:
                            // 3 sources

                        } while (this.m_oFrame != null);
                    }
                }

                public boolean hasNext() {
                    this.findNext();
                    return this.m_oFound != null;
                }

                public Object next() {
                    this.findNext();
                    if (this.m_oFound != null) {
                        NodeType nodetype = this.m_oFound;
                        this.m_oFound = null;
                        return nodetype.getQFName();
                    }
                    return null;
                }

                public void remove() {
                }
            };
            return itr;
        }
        if (typeNode.isInterface()) {
            List listSub = typeNode.getSubTypes();
            List listIFs = typeNode.getImplementors();
            if (listSub == null && listIFs == null) {
                return IteratorEmpty.getEmptyIterator();
            }
            Iterator itr = new Iterator(listSub, listIFs){
                private DFTFrame m_oFrame;
                private Stack m_oStack;
                private NodeType m_oFound;
                {
                    this.m_oFrame = new DFTFrame(list, list2);
                    this.m_oStack = new Stack();
                    this.m_oFound = null;
                }

                private boolean prepareFrameList() {
                    if (this.m_oFrame.list == null) {
                        this.m_oFrame.list = this.m_oFrame.list2;
                        this.m_oFrame.list2 = null;
                        this.m_oFrame.index = 0;
                    }
                    if (this.m_oFrame.list == null) {
                        return false;
                    }
                    if (this.m_oFrame.index < this.m_oFrame.list.size()) {
                        return true;
                    }
                    this.m_oFrame.list = null;
                    return this.prepareFrameList();
                }

                /*
                 * Unable to fully structure code
                 */
                public void findNext() {
                    if (this.m_oFound == null) ** GOTO lbl25
                    return;
                    {
                        node = null;
                        if ((node = (NodeType)this.m_oFrame.list.get(this.m_oFrame.index++)).hasSubType() || node.hasImplementor()) {
                            this.m_oFrame.node = node;
                            this.m_oStack.push(this.m_oFrame);
                            this.m_oFrame = new DFTFrame(node.getSubTypes());
                            this.m_oFrame.list2 = node.getImplementors();
                        } else if (!node.isAbstract()) {
                            this.m_oFound = node;
                            return;
                        }
                        do {
                            if (this.prepareFrameList()) continue block0;
                            this.m_oFrame = null;
                            if (this.m_oStack.size() > 0) {
                                this.m_oFrame = (DFTFrame)this.m_oStack.pop();
                            }
                            if (this.m_oFrame == null || this.m_oFrame.node == null) continue;
                            node = this.m_oFrame.node;
                            this.m_oFrame.node = null;
                            if (node.isAbstract()) continue;
                            this.m_oFound = node;
                            return;
lbl25:
                            // 3 sources

                        } while (this.m_oFrame != null);
                    }
                }

                public boolean hasNext() {
                    this.findNext();
                    return this.m_oFound != null;
                }

                public Object next() {
                    this.findNext();
                    if (this.m_oFound != null) {
                        NodeType nodetype = this.m_oFound;
                        this.m_oFound = null;
                        return nodetype.getQFName();
                    }
                    return null;
                }

                public void remove() {
                }
            };
            return itr;
        }
        return null;
    }

    public Iterator getCollision() {
        final FilterType filter = new FilterType(){

            public boolean accept(NodeType node) {
                return node.hasCollision();
            }
        };
        IteratorUnion itr = new IteratorUnion(){
            private int index = 0;

            protected Iterator nextIterator() {
                List list = Discovery.this.m_oContainers;
                if (this.index < list.size()) {
                    Container c = (Container)list.get(this.index++);
                    return c.findTypes(filter);
                }
                return null;
            }

            public Object next() {
                Object obj = super.next();
                if (obj != null) {
                    return ((NodeType)obj).getQFName();
                }
                return null;
            }
        };
        return itr;
    }

    public Iterator getCollision(String name) {
        NodeResource node = this.getResourceByPath(name = String.valueOf(name.replace('.', '/')) + ".class");
        if (node == null || !node.isJavaType()) {
            return null;
        }
        NodeType typeNode = (NodeType)node;
        if (typeNode.hasCollision()) {
            return new IteratorProxy(typeNode.getCollision()){

                public Object next() {
                    Object obj = super.next();
                    if (obj != null) {
                        return ((IType)obj).getURL();
                    }
                    return null;
                }
            };
        }
        return IteratorEmpty.getEmptyIterator();
    }

    public Iterator findResources(String pattern) {
        return null;
    }
}

