/*
 * Decompiled with CFR 0.152.
 */
package t4j.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.w3c.dom.Document;
import t4j.Configuration;
import t4j.TBlogException;
import t4j.org.json.JSONArray;
import t4j.org.json.JSONException;
import t4j.org.json.JSONObject;

public class Response {
    private static final boolean DEBUG = Configuration.getDebug();
    private int statusCode;
    private Document responseAsDocument = null;
    private String responseAsString = null;
    private InputStream is;
    private HttpURLConnection con;
    private boolean streamConsumed = false;
    private static Pattern escaped = Pattern.compile("&#([0-9]{3,5});");

    public Response() {
    }

    public Response(HttpURLConnection con) throws IOException {
        this.con = con;
        this.statusCode = con.getResponseCode();
        this.is = con.getErrorStream();
        if (this.is == null) {
            this.is = con.getInputStream();
        }
        if (this.is != null && "gzip".equals(con.getContentEncoding())) {
            this.is = new GZIPInputStream(this.is);
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseHeader(String name) {
        if (this.con != null) {
            return this.con.getHeaderField(name);
        }
        return null;
    }

    public InputStream asStream() {
        if (this.streamConsumed) {
            throw new IllegalStateException("Stream has already been consumed.");
        }
        return this.is;
    }

    public String asString() throws TBlogException {
        if (this.responseAsString == null) {
            InputStream stream;
            block7: {
                stream = this.asStream();
                if (stream != null) break block7;
                return null;
            }
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                StringBuffer buf = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    buf.append(line).append("\n");
                }
                this.responseAsString = buf.toString();
                if (Configuration.isDalvik()) {
                    this.responseAsString = Response.unescape(this.responseAsString);
                }
                this.log(this.responseAsString);
                stream.close();
                this.con.disconnect();
                this.streamConsumed = true;
            }
            catch (NullPointerException npe) {
                throw new TBlogException(npe.getMessage(), npe);
            }
            catch (IOException ioe) {
                throw new TBlogException(ioe.getMessage(), ioe);
            }
        }
        return this.responseAsString;
    }

    public JSONObject asJSONObject() throws TBlogException {
        try {
            return new JSONObject(this.asString());
        }
        catch (JSONException jsone) {
            throw new TBlogException(String.valueOf(jsone.getMessage()) + ":" + this.responseAsString, jsone);
        }
    }

    public JSONArray asJSONArray() throws TBlogException {
        if (this.asString().length() == 0) {
            return new JSONArray();
        }
        try {
            return new JSONArray(this.asString());
        }
        catch (Exception jsone) {
            throw new TBlogException(String.valueOf(jsone.getMessage()) + ":" + this.responseAsString, jsone);
        }
    }

    public InputStreamReader asReader() {
        try {
            return new InputStreamReader(this.is, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return new InputStreamReader(this.is);
        }
    }

    public void disconnect() {
        this.con.disconnect();
    }

    public static String unescape(String original) {
        Matcher mm = escaped.matcher(original);
        StringBuffer unescaped = new StringBuffer();
        while (mm.find()) {
            mm.appendReplacement(unescaped, Character.toString((char)Integer.parseInt(mm.group(1), 10)));
        }
        mm.appendTail(unescaped);
        return unescaped.toString();
    }

    public String toString() {
        if (this.responseAsString != null) {
            return this.responseAsString;
        }
        return "Response{statusCode=" + this.statusCode + ", response=" + this.responseAsDocument + ", responseString='" + this.responseAsString + '\'' + ", is=" + this.is + ", con=" + this.con + '}';
    }

    private void log(String message) {
        if (DEBUG) {
            System.out.println("[" + new Date() + "]" + message);
        }
    }

    public String getResponseAsString() {
        return this.responseAsString;
    }

    public void setResponseAsString(String responseAsString) {
        this.responseAsString = responseAsString;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }
}

