/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.transport.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import javax.mail.MessagingException;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.transport.http.Cookie;
import org.apache.soap.util.net.HTTPUtils;

public class SOAPHTTPConnection
implements SOAPTransport {
    private TransportMessage response;
    private String httpProxyHost;
    private int httpProxyPort = 80;
    private int timeout;
    private String userName;
    private String password;
    private String proxyUserName;
    private String proxyPassword;
    private boolean maintainSession = true;
    private Cookie[] cookies;
    private Cookie[] cookies2;
    private int outputBufferSize = 8192;
    private Boolean tcpNoDelay = null;
    private StringBuffer requestCopy = null;
    private StringBuffer responseCopy = null;

    public void setProxyHost(String host) {
        this.httpProxyHost = host;
    }

    public void setProxyPort(int port) {
        this.httpProxyPort = port;
    }

    public String getProxyHost() {
        return this.httpProxyHost;
    }

    public int getProxyPort() {
        return this.httpProxyPort;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setProxyUserName(String userName) {
        this.proxyUserName = userName;
    }

    public void setProxyPassword(String password) {
        this.proxyPassword = password;
    }

    public void setRequestCopy(StringBuffer requestCopy) {
        this.requestCopy = requestCopy;
    }

    public void setResponseCopy(StringBuffer responseCopy) {
        this.responseCopy = responseCopy;
    }

    public StringBuffer getRequestCopy() {
        return this.requestCopy;
    }

    public StringBuffer getResponseCopy() {
        return this.responseCopy;
    }

    public void setMaintainSession(boolean maintainSession) {
        this.maintainSession = maintainSession;
        if (!maintainSession) {
            this.cookies = null;
            this.cookies2 = null;
        }
    }

    public boolean getMaintainSession() {
        return this.maintainSession;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public Cookie[] getCookies2() {
        return this.cookies2;
    }

    public void setCookies2(Cookie[] cookies2) {
        this.cookies2 = cookies2;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setOutputBufferSize(int sz) {
        this.outputBufferSize = sz;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(Boolean nodelay) {
        this.tcpNoDelay = nodelay;
    }

    public void send(URL sendTo, String action, Hashtable headers, Envelope env, SOAPMappingRegistry smr, SOAPContext ctx) throws SOAPException {
        try {
            String payload = null;
            if (env != null) {
                StringWriter payloadSW = new StringWriter();
                env.marshall(payloadSW, smr, ctx);
                payload = payloadSW.toString();
            }
            if (headers == null) {
                headers = new Hashtable<String, String>();
            }
            if (this.maintainSession) {
                if (this.cookies2 != null) {
                    headers.put("Cookie2", Cookie.buildCookieValue(sendTo, this.cookies2));
                }
                if (this.cookies != null) {
                    headers.put("Cookie", Cookie.buildCookieValue(sendTo, this.cookies));
                }
            }
            headers.put("SOAPAction", action != null ? '\"' + action + '\"' : "");
            if (this.userName != null) {
                headers.put("Authorization", "Basic " + HTTPUtils.encodeAuth(this.userName, this.password));
            }
            if (this.proxyUserName != null) {
                headers.put("Proxy-Authorization", "Basic " + HTTPUtils.encodeAuth(this.proxyUserName, this.proxyPassword));
            }
            TransportMessage msg = new TransportMessage(payload, ctx, headers);
            msg.save();
            this.response = HTTPUtils.post(sendTo, msg, this.timeout, this.httpProxyHost, this.httpProxyPort, this.outputBufferSize, this.tcpNoDelay, this.requestCopy, this.responseCopy);
            if (this.maintainSession) {
                Cookie[] hdrCookies;
                Hashtable responseHeaders = this.response.getHeaders();
                String hdr = HTTPUtils.getHeaderValue(responseHeaders, "Set-Cookie2");
                if (hdr != null) {
                    hdrCookies = Cookie.parseCookies(sendTo, hdr);
                    this.cookies2 = this.cookies2 != null ? Cookie.updateCookies(this.cookies2, hdrCookies) : hdrCookies;
                }
                if ((hdr = HTTPUtils.getHeaderValue(responseHeaders, "Set-Cookie")) != null) {
                    hdrCookies = Cookie.parseCookies(sendTo, hdr);
                    this.cookies = this.cookies != null ? Cookie.updateCookies(this.cookies, hdrCookies) : hdrCookies;
                }
            }
        }
        catch (IOException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e.getMessage(), e);
        }
        catch (MessagingException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e.getMessage(), e);
        }
    }

    public BufferedReader receive() {
        Reader envReader;
        if (this.response != null && (envReader = this.response.getEnvelopeReader()) != null) {
            return new BufferedReader(envReader);
        }
        return null;
    }

    public String getEnvelope() {
        return this.response != null ? this.response.getEnvelope() : null;
    }

    public Hashtable getHeaders() {
        return this.response != null ? this.response.getHeaders() : null;
    }

    public SOAPContext getResponseSOAPContext() {
        return this.response != null ? this.response.getSOAPContext() : null;
    }
}

