/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import javax.sql.PooledConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CTTIk2rpc;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXid;
import oracle.jdbc.xa.client.OracleXADataSource;
import oracle.jdbc.xa.client.OracleXAResource;

class T4CXAResource
extends OracleXAResource {
    T4CConnection physicalConn;
    int[] applicationValueArr = new int[1];
    boolean isTransLoose = false;
    byte[] context;
    int[] errorNumber;
    private String password;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:18:54_PDT_2005";

    T4CXAResource(T4CConnection t4CConnection, OracleXAConnection oracleXAConnection, boolean bl) throws XAException {
        super(t4CConnection, oracleXAConnection);
        this.physicalConn = t4CConnection;
        this.isTransLoose = bl;
        this.errorNumber = new int[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doStart(Xid xid, int n) throws XAException {
        int n2 = -1;
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            T4CXAResource t4CXAResource = this;
            synchronized (t4CXAResource) {
                block18: {
                    int n3;
                    if (this.isTransLoose) {
                        n |= 0x10000;
                    }
                    if ((n3 = n & 0x8200000) == 0x8000000 && OracleXid.isLocalTransaction(xid)) {
                        return 0;
                    }
                    this.applicationValueArr[0] = 0;
                    try {
                        try {
                            T4CTTIOtxse t4CTTIOtxse = this.physicalConn.otxse;
                            byte[] byArray = null;
                            byte[] byArray2 = xid.getGlobalTransactionId();
                            byte[] byArray3 = xid.getBranchQualifier();
                            int n4 = 0;
                            int n5 = 0;
                            if (byArray2 != null && byArray3 != null) {
                                n4 = Math.min(byArray2.length, 64);
                                n5 = Math.min(byArray3.length, 64);
                                byArray = new byte[128];
                                System.arraycopy(byArray2, 0, byArray, 0, n4);
                                System.arraycopy(byArray3, 0, byArray, n4, n5);
                            }
                            int n6 = 0;
                            n6 = (n & 0x200000) != 0 || (n & 0x8000000) != 0 ? (n6 |= 4) : (n6 |= 1);
                            if ((n & 0x100) != 0) {
                                n6 |= 0x100;
                            }
                            if ((n & 0x200) != 0) {
                                n6 |= 0x200;
                            }
                            if ((n & 0x400) != 0) {
                                n6 |= 0x400;
                            }
                            if ((n & 0x10000) != 0) {
                                n6 |= 0x10000;
                            }
                            this.physicalConn.sendPiggyBackedMessages();
                            t4CTTIOtxse.marshal(1, null, byArray, xid.getFormatId(), n4, n5, this.timeout, n6);
                            byte[] byArray4 = t4CTTIOtxse.receive(this.applicationValueArr);
                            if (byArray4 != null) {
                                this.context = byArray4;
                            }
                            n2 = 0;
                        }
                        catch (IOException iOException) {
                            DatabaseError.throwSqlException(iOException);
                        }
                    }
                    catch (SQLException sQLException) {
                        n2 = sQLException.getErrorCode();
                        if (n2 != 0) break block18;
                        throw new XAException(-6);
                    }
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doEnd(Xid xid, int n) throws XAException {
        int n2 = -1;
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            T4CXAResource t4CXAResource = this;
            synchronized (t4CXAResource) {
                block13: {
                    try {
                        try {
                            T4CTTIOtxse t4CTTIOtxse = this.physicalConn.otxse;
                            byte[] byArray = null;
                            byte[] byArray2 = xid.getGlobalTransactionId();
                            byte[] byArray3 = xid.getBranchQualifier();
                            int n3 = 0;
                            int n4 = 0;
                            if (byArray2 != null && byArray3 != null) {
                                n3 = Math.min(byArray2.length, 64);
                                n4 = Math.min(byArray3.length, 64);
                                byArray = new byte[128];
                                System.arraycopy(byArray2, 0, byArray, 0, n3);
                                System.arraycopy(byArray3, 0, byArray, n3, n4);
                            }
                            byte[] byArray4 = this.context;
                            int n5 = 0;
                            if (((n & 2) == 2 || (n & 0x100000) != 0x100000) && (n & 0x2000000) == 0x2000000) {
                                n5 = 0x100000;
                            }
                            this.physicalConn.sendPiggyBackedMessages();
                            t4CTTIOtxse.marshal(2, byArray4, byArray, xid.getFormatId(), n3, n4, this.timeout, n5);
                            byte[] byArray5 = t4CTTIOtxse.receive(this.applicationValueArr);
                            if (byArray5 != null) {
                                this.context = byArray5;
                            }
                            n2 = 0;
                        }
                        catch (IOException iOException) {
                            DatabaseError.throwSqlException(iOException);
                        }
                    }
                    catch (SQLException sQLException) {
                        n2 = sQLException.getErrorCode();
                        if (n2 != 0) break block13;
                        throw new XAException(-6);
                    }
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int doCommit(Xid xid, int n) throws XAException {
        int n2 = -1;
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            T4CXAResource t4CXAResource = this;
            synchronized (t4CXAResource) {
                int n3 = n == 1 ? 4 : 2;
                n2 = this.doTransaction(xid, 1, n3);
                if (n == 1 && (n2 == 2 || n2 == 4)) {
                    n2 = 0;
                } else if (n != 1 && n2 == 5) {
                    n2 = 0;
                } else if (n2 == 8) {
                    throw new XAException(106);
                }
                if (n2 == 24756) {
                    return this.kputxrec(xid, 1, this.timeout + 120);
                }
                if (n2 != 24780) return n2;
                OracleXADataSource oracleXADataSource = null;
                PooledConnection pooledConnection = null;
                try {
                    try {
                        oracleXADataSource = new OracleXADataSource();
                        oracleXADataSource.setURL(this.physicalConn.url);
                        oracleXADataSource.setUser(this.physicalConn.user);
                        this.physicalConn.getPasswordInternal(this);
                        oracleXADataSource.setPassword(this.password);
                        pooledConnection = oracleXADataSource.getXAConnection();
                        XAResource xAResource = pooledConnection.getXAResource();
                        xAResource.commit(xid, n == 1);
                        n2 = 0;
                    }
                    catch (SQLException sQLException) {
                        throw new XAException(-6);
                    }
                    Object var11_11 = null;
                    {
                    }
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    try {
                        if (pooledConnection != null) {
                            pooledConnection.close();
                        }
                        if (oracleXADataSource == null) throw throwable;
                        oracleXADataSource.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception exception) {}
                if (pooledConnection != null) {
                    pooledConnection.close();
                }
                if (oracleXADataSource == null) return n2;
                oracleXADataSource.close();
                return n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doPrepare(Xid xid) throws XAException {
        int n = -1;
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            T4CXAResource t4CXAResource = this;
            synchronized (t4CXAResource) {
                n = this.doTransaction(xid, 3, 0);
                if (n == 8) {
                    throw new XAException(106);
                }
                if (n == 4) {
                    n = 24767;
                } else if (n == 1) {
                    n = 0;
                } else if (n == 3) {
                    n = 24761;
                } else {
                    if (n == 2054 || n == 24756) {
                        return n;
                    }
                    n = 24768;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int doForget(Xid xid) throws XAException {
        int n = -1;
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            T4CXAResource t4CXAResource = this;
            synchronized (t4CXAResource) {
                if (OracleXid.isLocalTransaction(xid)) {
                    return 24771;
                }
                int n2 = this.doStart(xid, 0x8000000);
                if (n2 == 24756) return this.kputxrec(xid, 4, 1);
                if (n2 == 0) {
                    try {
                        this.doEnd(xid, 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n2 == 0) return 24769;
                if (n2 == 2079) return 24769;
                if (n2 == 24754) return 24769;
                if (n2 == 24761) return 24769;
                if (n2 == 24774) return 24769;
                if (n2 == 24776) return 24769;
                if (n2 == 25351) {
                    return 24769;
                }
                if (n2 != 24752) return n2;
                return 24771;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int doRollback(Xid xid) throws XAException {
        int n = -1;
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            T4CXAResource t4CXAResource = this;
            synchronized (t4CXAResource) {
                n = this.doTransaction(xid, 2, 3);
                if (n == 8) {
                    throw new XAException(106);
                }
                if (n == 3 || n == 25402) {
                    n = 0;
                }
                if (n == 24756) {
                    return this.kputxrec(xid, 2, this.timeout + 120);
                }
                if (n != 24780) return n;
                OracleXADataSource oracleXADataSource = null;
                PooledConnection pooledConnection = null;
                try {
                    try {
                        oracleXADataSource = new OracleXADataSource();
                        oracleXADataSource.setURL(this.physicalConn.url);
                        oracleXADataSource.setUser(this.physicalConn.user);
                        this.physicalConn.getPasswordInternal(this);
                        oracleXADataSource.setPassword(this.password);
                        pooledConnection = oracleXADataSource.getXAConnection();
                        XAResource xAResource = pooledConnection.getXAResource();
                        xAResource.rollback(xid);
                        n = 0;
                    }
                    catch (SQLException sQLException) {
                        throw new XAException(-6);
                    }
                    Object var9_9 = null;
                    {
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    try {
                        if (pooledConnection != null) {
                            pooledConnection.close();
                        }
                        if (oracleXADataSource == null) throw throwable;
                        oracleXADataSource.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception exception) {}
                if (pooledConnection != null) {
                    pooledConnection.close();
                }
                if (oracleXADataSource == null) return n;
                oracleXADataSource.close();
                return n;
            }
        }
    }

    int doTransaction(Xid xid, int n, int n2) throws XAException {
        int n3 = -1;
        try {
            try {
                T4CTTIOtxen t4CTTIOtxen = this.physicalConn.otxen;
                byte[] byArray = null;
                byte[] byArray2 = xid.getGlobalTransactionId();
                byte[] byArray3 = xid.getBranchQualifier();
                int n4 = 0;
                int n5 = 0;
                if (byArray2 != null && byArray3 != null) {
                    n4 = Math.min(byArray2.length, 64);
                    n5 = Math.min(byArray3.length, 64);
                    byArray = new byte[128];
                    System.arraycopy(byArray2, 0, byArray, 0, n4);
                    System.arraycopy(byArray3, 0, byArray, n4, n5);
                }
                byte[] byArray4 = this.context;
                this.physicalConn.sendPiggyBackedMessages();
                t4CTTIOtxen.marshal(n, byArray4, byArray, xid.getFormatId(), n4, n5, this.timeout, n2);
                n3 = t4CTTIOtxen.receive(this.errorNumber);
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
        }
        catch (SQLException sQLException) {
            this.errorNumber[0] = sQLException.getErrorCode();
        }
        if (this.errorNumber[0] == 0) {
            throw new XAException(-6);
        }
        if (n3 == -1) {
            n3 = this.errorNumber[0];
        }
        return n3;
    }

    protected int kputxrec(Xid xid, int n, int n2) throws XAException {
        Object object;
        int n3;
        int n4;
        int n5 = 0;
        switch (n) {
            case 1: {
                n4 = 3;
                break;
            }
            case 4: {
                n4 = 2;
                break;
            }
            default: {
                n4 = 0;
            }
        }
        int n6 = 0;
        while (n2-- > 0 && (n6 = this.doTransaction(xid, 5, n4)) == 7) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        if (n6 == 7) {
            return 24763;
        }
        if (n6 == 24756) {
            return 24756;
        }
        switch (n6) {
            case 3: {
                if (n == 1) {
                    n3 = 7;
                    break;
                }
                n3 = 8;
                n5 = -24762;
                break;
            }
            case 0: {
                if (n == 4) {
                    n3 = 8;
                    n5 = 24762;
                    break;
                }
                n3 = 7;
                n5 = n == 1 ? 24756 : 0;
                break;
            }
            case 2: {
                if (n == 4) {
                    n3 = 8;
                    n5 = 24770;
                    break;
                }
            }
            default: {
                object = new int[1];
                n5 = this.kpuho2oc(n6, (int[])object);
                if (n == 4 && object[0] == 1) {
                    n3 = 7;
                    n5 = 0;
                    break;
                }
                n3 = 8;
            }
        }
        object = this.physicalConn.k2rpc;
        try {
            ((T4CTTIk2rpc)object).marshal(3, n3);
            ((T4CTTIk2rpc)object).receive();
        }
        catch (IOException iOException) {
            throw new XAException(-7);
        }
        catch (SQLException sQLException) {
            throw new XAException(-6);
        }
        return n5;
    }

    int kpuho2oc(int n, int[] nArray) {
        int n2 = 0;
        switch (n) {
            case 5: {
                nArray[0] = 1;
                n2 = 24764;
                break;
            }
            case 4: {
                nArray[0] = 1;
                n2 = 24765;
                break;
            }
            case 6: {
                nArray[0] = 1;
                n2 = 24766;
                break;
            }
            default: {
                n2 = 24762;
            }
        }
        return n2;
    }

    final void setPasswordInternal(String string) {
        this.password = string;
    }
}

