/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Param;
import com.sybase.jdbc2.jdbc.ParamManager;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.jdbc.ProtocolResultSet;
import com.sybase.jdbc2.jdbc.SybCursorResultSet;
import com.sybase.jdbc2.jdbc.SybPreparedStatement;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class SybCallableStatement
extends SybPreparedStatement
implements com.sybase.jdbcx.SybCallableStatement {
    protected boolean _hasOutParam = false;

    SybCallableStatement(ProtocolContext protocolContext, String string) throws SQLException {
        super(protocolContext, string);
        if (this._hasReturn) {
            this._paramMgr.setParam(1, -998, new Integer(0), 0);
            this._paramMgr.registerParam(1, 4, 0);
            this._returnHasBeenRegistered = false;
        }
    }

    public void addBatch() throws SQLException {
        if (this._batchCmdsCount < 1) {
            this._query = this.handleCallBody(this._query);
        }
        super.addBatch();
    }

    public void cancel() throws SQLException {
        this.checkStatement(false);
        try {
            this._paramMgr.clearParams(false);
        }
        catch (IOException iOException) {}
        super.cancel();
    }

    private void checkOutParamRegistration(int n) throws SQLException {
        if (!this._allowsOutputParms) {
            ErrorMessage.raiseError("JZ0SB", String.valueOf(n));
        } else if (this._hasReturn && n == 1) {
            this._returnHasBeenRegistered = true;
        }
    }

    public void clearParams() throws SQLException {
        try {
            this._paramMgr.clearParams(false);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    public boolean execute() throws SQLException {
        this.clearParams();
        if (this._rpcName != null) {
            this.checkStatement(true);
            if (this.sendRpc(this._rpcName, this._paramMgr)) {
                return this.executeLoop();
            }
            return this._currentRS != null;
        }
        return super.execute(this._query, this._paramMgr);
    }

    public int[] executeBatch() throws SQLException {
        if (this._hasReturn || this._hasOutParam) {
            ErrorMessage.raiseError("JZ0BP");
        }
        return super.executeBatch();
    }

    public ResultSet executeQuery() throws SQLException {
        this.clearParams();
        if (this._rpcName != null) {
            this.checkStatement(true);
            if (this.sendRpc(this._rpcName, this._paramMgr)) {
                return this.queryLoop();
            }
            return this._currentRS;
        }
        return super.executeQuery(this._query, this._paramMgr);
    }

    public int executeUpdate() throws SQLException {
        this.clearParams();
        int n = -1;
        if (this._rpcName != null) {
            this.checkStatement(true);
            if (this._cursor != null) {
                ErrorMessage.raiseError("JZ0S3");
            }
            if (this.sendRpc(this._rpcName, this._paramMgr)) {
                n = this.updateLoop();
            }
        } else {
            n = super.executeUpdate(this._query, this._paramMgr);
        }
        return n;
    }

    public Array getArray(int n) throws SQLException {
        Debug.notSupported(this, "getArray(int)");
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, -1);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this._paramMgr.getOutValueAt(n).getBigDecimal(n2);
    }

    public Blob getBlob(int n) throws SQLException {
        Debug.notSupported(this, "getBlob(int)");
        return null;
    }

    public boolean getBoolean(int n) throws SQLException {
        return this._paramMgr.getOutValueAt(n).getBoolean();
    }

    public byte getByte(int n) throws SQLException {
        return this._paramMgr.getOutValueAt(n).getByte();
    }

    public byte[] getBytes(int n) throws SQLException {
        return this._paramMgr.getOutValueAt(n).getBytes();
    }

    public Clob getClob(int n) throws SQLException {
        Debug.notSupported(this, "getClob(int)");
        return null;
    }

    public Date getDate(int n) throws SQLException {
        return Convert.objectToDate(this._paramMgr.getOutValueAt(n).getDateObject(91, null));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return Convert.objectToDate(this._paramMgr.getOutValueAt(n).getDateObject(91, calendar));
    }

    public double getDouble(int n) throws SQLException {
        return this._paramMgr.getOutValueAt(n).getDouble();
    }

    public float getFloat(int n) throws SQLException {
        return this._paramMgr.getOutValueAt(n).getFloat();
    }

    public int getInt(int n) throws SQLException {
        return this._paramMgr.getOutValueAt(n).getInt();
    }

    public long getLong(int n) throws SQLException {
        return this._paramMgr.getOutValueAt(n).getLong();
    }

    public Object getObject(int n) throws SQLException {
        return this._paramMgr.getOutObjectAt(n);
    }

    public Object getObject(int n, Map map) throws SQLException {
        Debug.notImplemented(this, "getObject(int, java.util.Map)");
        return null;
    }

    public Ref getRef(int n) throws SQLException {
        Debug.notSupported(this, "getRef(int)");
        return null;
    }

    public short getShort(int n) throws SQLException {
        return this._paramMgr.getOutValueAt(n).getShort();
    }

    public String getString(int n) throws SQLException {
        return this._paramMgr.getOutValueAt(n).getString();
    }

    public Time getTime(int n) throws SQLException {
        return Convert.objectToTime(this._paramMgr.getOutValueAt(n).getDateObject(92, null));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return Convert.objectToTime(this._paramMgr.getOutValueAt(n).getDateObject(92, calendar));
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return Convert.objectToTimestamp(this._paramMgr.getOutValueAt(n).getDateObject(93, null));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return Convert.objectToTimestamp(this._paramMgr.getOutValueAt(n).getDateObject(93, calendar));
    }

    protected void handleParam(ParamManager paramManager) throws SQLException {
        if (this._batchCmds == null) {
            this._paramMgr.getParameter();
        } else {
            paramManager.getParameter();
        }
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.checkOutParamRegistration(n);
        this._paramMgr.registerParam(n, n2);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.checkOutParamRegistration(n);
        this._paramMgr.registerParam(n, n2, n3);
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this._paramMgr.registerParam(n, n2, string);
    }

    public boolean sendRpc(String string, ParamManager paramManager) throws SQLException {
        try {
            if (this._rsConcur == -9) {
                this._rsConcur = 1007;
            }
            if (this._rsConcur == 1008) {
                this.checkCursor(false);
            }
            if (this._cursor != null) {
                ProtocolResultSet protocolResultSet = this._cursor.open(string, paramManager, true);
                protocolResultSet.setType(this._rsType);
                this._currentRS = new SybCursorResultSet(this, protocolResultSet);
                this._context._conn.addCursorResultSet(this._cursor.getName(), this._currentRS);
                this._state = 2;
                return false;
            }
            this._protocol.rpc(this._context, string, paramManager);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return true;
    }

    public void setParameterName(int n, String string) {
        Param[] paramArray = this._paramMgr.getParams();
        if (paramArray.length >= n && n > 0) {
            paramArray[n - 1]._name = string;
        }
    }

    public boolean wasNull() throws SQLException {
        return this._paramMgr.wasNull();
    }
}

