/*
 * Decompiled with CFR 0.152.
 */
package org.aton.cache;

import com.trs.util.CMyString;
import java.util.StringTokenizer;
import org.aton.exception.ExceptionFire;
import org.jdom.Element;

public class PoolConfig
implements Cloneable {
    public static final String DELIM = ";";
    public static final char DELIM_CHAR = ';';
    public static final String CLASS_NAME;
    private String m_sPooledObjClassName = null;
    private Class m_pooledObjBaseClass = null;
    private int m_nInitNum = 3;
    private int m_nMaxNum = 10;
    private int m_nRunLimit = 0;
    private boolean m_bWaitIfBusy = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.aton.cache.PoolConfig");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
    }

    public PoolConfig(Class p_pooledObjBaseClass) {
        this.m_pooledObjBaseClass = p_pooledObjBaseClass;
    }

    public PoolConfig(PoolConfig p_config) {
        this.copy(p_config);
    }

    public PoolConfig(Class p_pooledObjBaseClass, String p_sValues) throws Exception {
        this.m_pooledObjBaseClass = p_pooledObjBaseClass;
        this.set(p_sValues);
    }

    public Class getPooledObjBaseClass() {
        return this.m_pooledObjBaseClass;
    }

    public void setPooledObjBaseClass(Class p_class) {
        this.m_pooledObjBaseClass = p_class;
    }

    public String getPooledObjClassName() {
        return this.m_sPooledObjClassName;
    }

    public Class getPooledObjClass() throws Exception {
        if (this.m_sPooledObjClassName == null) {
            return null;
        }
        try {
            return Class.forName(this.m_sPooledObjClassName);
        }
        catch (Exception ex) {
            throw new ExceptionFire(21, "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684class(" + this.m_sPooledObjClassName + ")", String.valueOf(CLASS_NAME) + ".getPooledObjClass", ex);
        }
    }

    public void setPooledObjClass(String p_sPooledObjClassName) throws Exception {
        Class<?> beanClass;
        try {
            beanClass = Class.forName(p_sPooledObjClassName.trim());
        }
        catch (Exception ex) {
            throw new ExceptionFire(10, "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684java Bean:" + p_sPooledObjClassName, String.valueOf(CLASS_NAME) + ".setPooledObjClass", ex);
        }
        this.setPooledObjClass(beanClass);
    }

    public void setPooledObjClass(Class p_pooledObjClass) throws Exception {
        if (p_pooledObjClass == null) {
            throw new ExceptionFire(11, "\u6307\u5b9a\u7f13\u51b2\u5bf9\u8c61class\u4e3anull", String.valueOf(CLASS_NAME) + ".setPooledObjClass");
        }
        if (this.m_pooledObjBaseClass != null && !this.m_pooledObjBaseClass.isAssignableFrom(p_pooledObjClass)) {
            throw new ExceptionFire(10, "\u6307\u5b9a\u7684\u64cd\u4f5c\u5bf9\u8c61Bean\u5fc5\u987b\u662f" + this.m_pooledObjBaseClass.getName() + "\u7684\u5b50\u7c7b", String.valueOf(CLASS_NAME) + ".setPooledObjClass");
        }
        this.m_sPooledObjClassName = p_pooledObjClass.getName();
    }

    public int getInitNum() {
        return this.m_nInitNum;
    }

    public void setInitNum(int p_nInitNum) {
        this.m_nInitNum = p_nInitNum <= 1 ? 1 : p_nInitNum;
    }

    public int getMaxNum() {
        return this.m_nMaxNum;
    }

    public void setMaxNum(int p_nMaxNum) {
        this.m_nMaxNum = p_nMaxNum <= 1 ? 1 : p_nMaxNum;
    }

    public int getRunLimit() {
        return this.m_nRunLimit;
    }

    public void setRunLimit(int p_nRunLimit) {
        this.m_nRunLimit = p_nRunLimit <= 0 ? 0 : p_nRunLimit;
    }

    public boolean isWaitIfBusy() {
        return this.m_bWaitIfBusy;
    }

    public void setWaitIfBusy(boolean p_bWaitIfBusy) {
        this.m_bWaitIfBusy = p_bWaitIfBusy;
    }

    public Object clone() {
        return new PoolConfig(this);
    }

    public void copy(PoolConfig p_config) {
        if (p_config == null) {
            return;
        }
        this.m_pooledObjBaseClass = p_config.m_pooledObjBaseClass;
        this.m_sPooledObjClassName = p_config.m_sPooledObjClassName;
        this.m_nInitNum = p_config.m_nInitNum;
        this.m_nMaxNum = p_config.m_nMaxNum;
        this.m_nRunLimit = p_config.m_nRunLimit;
        this.m_bWaitIfBusy = p_config.m_bWaitIfBusy;
    }

    public void set(String p_sValues, String p_sDelim) throws Exception {
        if (p_sValues == null) {
            throw new ExceptionFire(11, "\u6307\u5b9a\u7684\u5c5e\u6027\u503c\u5e8f\u5217\u4e3a\u7a7a", String.valueOf(CLASS_NAME) + ".set");
        }
        StringTokenizer stValues = new StringTokenizer(p_sValues, p_sDelim);
        try {
            int i = 0;
            while (i < 5) {
                String sValue = (String)stValues.nextElement();
                switch (i) {
                    case 0: {
                        this.setPooledObjClass(sValue);
                        break;
                    }
                    case 1: {
                        this.setInitNum(Integer.parseInt(sValue));
                        break;
                    }
                    case 2: {
                        this.setMaxNum(Integer.parseInt(sValue));
                        break;
                    }
                    case 3: {
                        this.setRunLimit(Integer.parseInt(sValue));
                        break;
                    }
                    case 4: {
                        this.setWaitIfBusy(CMyString.strToBoolean((String)sValue));
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new ExceptionFire(10, "\u914d\u7f6e\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u8bbe\u7f6e\u503c\u65e0\u6548", String.valueOf(CLASS_NAME) + ".set", ex);
        }
    }

    public void set(String p_sValues) throws Exception {
        this.set(p_sValues, DELIM);
    }

    public String toString() {
        return String.valueOf(this.m_sPooledObjClassName == null ? "null" : this.m_sPooledObjClassName) + DELIM + this.m_nInitNum + DELIM + this.m_nMaxNum + DELIM + this.m_nRunLimit + DELIM + this.m_bWaitIfBusy;
    }

    public Element toXMLElement() throws Exception {
        Element element = null;
        try {
            element = new Element("PoolConfig");
            element.setAttribute("PooledObjClass", this.m_sPooledObjClassName);
            element.setAttribute("InitNum", String.valueOf(this.m_nInitNum));
            element.setAttribute("MaxNum", String.valueOf(this.m_nMaxNum));
            element.setAttribute("RunLimit", String.valueOf(this.m_nRunLimit));
            element.setAttribute("WaitIfBusy", String.valueOf(this.m_bWaitIfBusy));
            return element;
        }
        catch (Exception ex) {
            throw new ExceptionFire(61, "\u5bfc\u51fa\u5bf9\u8c61\u6570\u636e\u5230XML Element\u5931\u8d25", String.valueOf(CLASS_NAME) + ".toXMLElement", ex);
        }
    }

    public void fromXML(Element p_xmlElement) throws Exception {
        if (p_xmlElement == null) {
            throw new ExceptionFire(11, "\u6307\u5b9a\u7684XML\u5143\u7d20\u4e3a\u7a7a\u5bf9\u8c61", String.valueOf(CLASS_NAME) + ".fromXML");
        }
        try {
            this.m_sPooledObjClassName = p_xmlElement.getAttributeValue("PooledObjClass");
            this.m_nInitNum = Integer.parseInt(p_xmlElement.getAttributeValue("InitNum"));
            this.m_nMaxNum = Integer.parseInt(p_xmlElement.getAttributeValue("MaxNum"));
            this.m_nRunLimit = Integer.parseInt(p_xmlElement.getAttributeValue("RunLimit"));
            this.m_bWaitIfBusy = CMyString.strToBoolean((String)p_xmlElement.getAttributeValue("WaitIfBusy"));
        }
        catch (Exception ex) {
            throw new ExceptionFire(1, "\u4ece\u6307\u5b9aXML\u5143\u7d20\u8bfb\u53d6\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", String.valueOf(CLASS_NAME) + ".fromXML", ex);
        }
    }

    public static void main(String[] args) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.aton.jobserver.Worker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PoolConfig config = new PoolConfig(clazz);
        String sXML = null;
        try {
            config.set("org.aton.jobserver.Worker;1;5;10;true");
            System.out.println(sXML);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

