/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.config;

import com.trs.infra.I18NMessage;
import com.trs.webframework.config.LoadingErrorReport;
import com.trs.webframework.config.ServiceFilterConfig;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ServiceFilterConfigs {
    protected static Logger logger = Logger.getLogger(ServiceFilterConfigs.class);
    private Map m_mapFilters = null;
    private LoadingErrorReport m_oLoadingErrorReport = null;

    public ServiceFilterConfig[] findServiceFilterConfigs(String _sServiceId, String _sMethodName) {
        ArrayList arConfigsForCurrMethod;
        if (this.m_mapFilters == null) {
            return new ServiceFilterConfig[0];
        }
        String sKey = (_sServiceId + ".*").toUpperCase();
        ArrayList arConfigsForAllMethod = (ArrayList)this.m_mapFilters.get(sKey);
        int nSize = (arConfigsForAllMethod == null ? 0 : arConfigsForAllMethod.size()) + ((arConfigsForCurrMethod = (ArrayList)this.m_mapFilters.get(sKey = (_sServiceId + "." + _sMethodName).toUpperCase())) == null ? 0 : arConfigsForCurrMethod.size());
        if (nSize == 0) {
            return new ServiceFilterConfig[0];
        }
        ServiceFilterConfig[] pFilters = new ServiceFilterConfig[nSize];
        int nDestPos = 0;
        if (arConfigsForAllMethod != null) {
            System.arraycopy(arConfigsForAllMethod.toArray(), 0, pFilters, nDestPos, arConfigsForAllMethod.size());
            nDestPos = arConfigsForAllMethod.size();
        }
        if (arConfigsForCurrMethod != null) {
            System.arraycopy(arConfigsForCurrMethod.toArray(), 0, pFilters, nDestPos, arConfigsForCurrMethod.size());
        }
        return pFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFromFile(String _sServiceIdPre, String _sConfigFile) {
        if (this.m_mapFilters == null) {
            ServiceFilterConfigs serviceFilterConfigs = this;
            synchronized (serviceFilterConfigs) {
                if (this.m_mapFilters == null) {
                    this.m_mapFilters = new Hashtable(4);
                }
            }
        }
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(_sConfigFile);
            Element root = document.getRootElement();
            Iterator i = root.elementIterator("service-filter");
            while (i.hasNext()) {
                String sMethodName;
                Element elFilter = (Element)i.next();
                String sServiceId = elFilter.attributeValue("service");
                if (sServiceId == null || (sServiceId = sServiceId.trim()).length() == 0) continue;
                if (sServiceId.indexOf(95) < 0) {
                    sServiceId = _sServiceIdPre + "_" + sServiceId;
                }
                if ((sMethodName = elFilter.attributeValue("method")) == null || (sMethodName = sMethodName.trim()).length() == 0) {
                    sMethodName = "*";
                }
                try {
                    ServiceFilterConfig serviceFilterConfig = new ServiceFilterConfig(sServiceId, sMethodName, elFilter.attributeValue("class"));
                    String sKey = (sServiceId + "." + sMethodName).toUpperCase();
                    ArrayList<ServiceFilterConfig> arFilters = (ArrayList<ServiceFilterConfig>)this.m_mapFilters.get(sKey);
                    if (arFilters == null) {
                        arFilters = new ArrayList<ServiceFilterConfig>(1);
                        this.m_mapFilters.put(sKey, arFilters);
                    }
                    arFilters.add(serviceFilterConfig);
                    List lAttributes = elFilter.attributes();
                    int nSize = lAttributes.size();
                    for (int j = 0; j < nSize; ++j) {
                        Attribute attr = (Attribute)lAttributes.get(j);
                        if (attr == null) continue;
                        serviceFilterConfig.setParameter(attr.getName(), attr.getValue());
                    }
                }
                catch (Throwable ex) {
                    String sErrorInfo = I18NMessage.get(ServiceFilterConfigs.class, "ServiceFilterConfigs.label1", "\u6587\u4ef6[") + _sConfigFile + I18NMessage.get(ServiceFilterConfigs.class, "ServiceFilterConfigs.label2", "]\u4e2dFilter\u7684\u914d\u7f6e\u4fe1\u606f\u8bbe\u7f6e\u9519\u8bef\uff01\u5185\u5bb9\u4e3a\uff1a") + elFilter.asXML();
                    logger.error((Object)sErrorInfo, ex);
                    if (this.m_oLoadingErrorReport == null) {
                        this.m_oLoadingErrorReport = new LoadingErrorReport();
                    }
                    this.m_oLoadingErrorReport.add(sErrorInfo, ex);
                }
            }
        }
        catch (DocumentException ex) {
            logger.error((Object)(I18NMessage.get(ServiceFilterConfigs.class, "ServiceFilterConfigs.label3", "\u89e3\u6790ServiceFilter\u914d\u7f6e\u6587\u4ef6[") + _sConfigFile + I18NMessage.get(ServiceFilterConfigs.class, "ServiceFilterConfigs.label4", "]\u5931\u8d25!")), (Throwable)ex);
            this.m_oLoadingErrorReport = new LoadingErrorReport(I18NMessage.get(ServiceFilterConfigs.class, "ServiceFilterConfigs.label3", "\u89e3\u6790ServiceFilter\u914d\u7f6e\u6587\u4ef6[") + _sConfigFile + I18NMessage.get(ServiceFilterConfigs.class, "ServiceFilterConfigs.label4", "]\u5931\u8d25!"), ex);
        }
    }

    public LoadingErrorReport getLoadingErrorReport() {
        return this.m_oLoadingErrorReport;
    }
}

