/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcag2.validator;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyString;
import com.trs.wcag2.HTMLUtil;
import com.trs.wcag2.validator.AbstractValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HtmlTitleValidator
extends AbstractValidator {
    protected String m_sType = I18NMessage.get(HtmlTitleValidator.class, "HtmlTitleValidator.label1", "\u6807\u9898");
    protected Object m_oWarning = I18NMessage.get(HtmlTitleValidator.class, "HtmlTitleValidator.label2", "\u9875\u9762\u6ca1\u6709\u5305\u542bTitle\u8282\u70b9\u6216\u8005Title\u65e0\u5185\u5bb9");
    protected String m_oExample = I18NMessage.get(HtmlTitleValidator.class, "HtmlTitleValidator.label3", "\u5728\u9875\u9762Head\u90e8\u5206\u6dfb\u52a0Title\u8282\u70b9\uff0c\u4f8b\u5982\uff1a<br>") + I18NMessage.get(HtmlTitleValidator.class, "HtmlTitleValidator.label4", "<br>&nbsp;&nbsp;&lt;TITLE&gt;\u63cf\u8ff0\u8fd9\u4e2a\u9875\u9762\u7684\u8bf4\u660e&lt;/TITLE&gt;");

    @Override
    public Object doValid(String content, HashMap known) {
        ArrayList<String[]> rst = new ArrayList<String[]>();
        String eleName = "Title";
        List tags = HTMLUtil.findTagOuterHTML(content, eleName);
        if (tags.size() > 0) {
            int[] pos = (int[])tags.get(0);
            String innerHTML = HTMLUtil.getEleInnerHTML(content, pos);
            if (CMyString.isEmpty(innerHTML)) {
                int[] lenPos = HTMLUtil.getPosition(content.substring(0, pos[0]));
                rst.add(new String[]{String.valueOf(lenPos[0]), String.valueOf(lenPos[1]), HTMLUtil.getEleOuterHTML(content, pos)});
                return rst;
            }
            known.put("document.title", innerHTML);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Object getWarnObj() {
        return this.m_oWarning;
    }

    @Override
    public String getType() {
        return this.m_sType;
    }

    @Override
    public Object getExampleObj() {
        return this.m_oExample;
    }
}

