/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.ExtendedField;
import com.trs.cms.content.ExtendedFields;
import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.InfoViewMgr;
import com.trs.components.infoview.helper.BaseInfoViewFieldValueCreator;
import com.trs.components.infoview.helper.InfoViewFieldValueCreatorFactory;
import com.trs.components.infoview.mad.InfoViewDataHelper;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.DocBakMgr;
import com.trs.components.wcm.content.domain.DocReplyMgr;
import com.trs.components.wcm.content.domain.DocumentExporter;
import com.trs.components.wcm.content.domain.DocumentImporter;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.DocumentPriMgr;
import com.trs.components.wcm.content.domain.IDocKeywordMgr;
import com.trs.components.wcm.content.domain.RelationMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.DocBak;
import com.trs.components.wcm.content.persistent.DocBaks;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.Relations;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DiscoveryFactoryBuddy;
import com.trs.infra.util.Reports;
import com.trs.infra.util.store.FileStore;
import com.trs.service.IDocumentService;
import com.trs.service.IInfoViewService;
import com.trs.service.ServiceHelper;
import com.trs.webframework.exception.AuthError;
import com.trs.webframework.exception.ServiceInvocationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class DocumentService
implements IDocumentService {
    private static Logger m_oLogger = Logger.getLogger(DocumentService.class);
    private static final int TRANSMIT_TYPE_COPY = 1;
    private static final int TRANSMIT_TYPE_MOVE = 2;
    private static final int TRANSMIT_TYPE_QUOTE = 3;
    private static final int TRANSMIT_TYPE_MIRROR = 4;
    private static final String[] TRANSMIT_TYPE_TEXT = new String[]{I18NMessage.get(DocumentService.class, "DocumentService.label1", "\u590d\u5236"), I18NMessage.get(DocumentService.class, "DocumentService.label2", "\u79fb\u52a8"), I18NMessage.get(DocumentService.class, "DocumentService.label3", "\u94fe\u63a5\u578b\u5f15\u7528"), I18NMessage.get(DocumentService.class, "DocumentService.label4", "\u955c\u50cf\u578b\u5f15\u7528")};
    public AppendixMgr m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    public DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    private DocBakMgr m_oDocBakMgr = (DocBakMgr)DreamFactory.createObjectById("DocBakMgr");
    public RelationMgr m_oRelationMgr = (RelationMgr)DreamFactory.createObjectById("RelationMgr");
    private DocReplyMgr m_oDocReplyMgr = (DocReplyMgr)DreamFactory.createObjectById("DocReplyMgr");
    private IDocKeywordMgr m_oDocKeywordMgr = (IDocKeywordMgr)DreamFactory.createObjectById("IDocKeywordMgr");

    @Override
    public DocBaks getDocBaks(com.trs.components.wcm.content.persistent.Document _currDocument) throws WCMException {
        return this.getDocBaks(_currDocument, null);
    }

    @Override
    public DocBaks getDocBaks(com.trs.components.wcm.content.persistent.Document _currDocument, WCMFilter _filter) throws WCMException {
        return this.m_oDocBakMgr.findDocBaks(_currDocument, _filter);
    }

    @Override
    public DocBak getDocBak(com.trs.components.wcm.content.persistent.Document _currDocument, int _nVersion) throws WCMException {
        return this.m_oDocBakMgr.getDocBak(_currDocument, _nVersion);
    }

    @Override
    public com.trs.components.wcm.content.persistent.Document save(com.trs.components.wcm.content.persistent.Document newDocument, List _aAppendixList, List _aRelationList) throws WCMException {
        return this.save(newDocument, _aAppendixList, _aRelationList, new HashMap(0));
    }

    @Override
    public com.trs.components.wcm.content.persistent.Document save(com.trs.components.wcm.content.persistent.Document newDocument, List _aAppendixList, List _aRelationList, String _sFlowContextInfo) throws WCMException {
        Map flowContextInfoMap = WCMProcessServiceHelper.makeFlowContextInfoMap(_sFlowContextInfo);
        return this.save(newDocument, _aAppendixList, _aRelationList, flowContextInfoMap);
    }

    @Override
    public com.trs.components.wcm.content.persistent.Document save(com.trs.components.wcm.content.persistent.Document newDocument, List _aAppendixList, List _aRelationList, int _nFlowDocId) throws WCMException {
        if (!WCMProcessServiceHelper.hasFlowingActionRight(this.getLoginUser(), _nFlowDocId, 32)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label5", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5728\u5f53\u524d\u5de5\u4f5c\u6d41\u8282\u70b9\u4e0a\u4fdd\u5b58\u6587\u6863!"));
        }
        return this.save(newDocument, _aAppendixList, _aRelationList, new HashMap(0), false);
    }

    @Override
    public com.trs.components.wcm.content.persistent.Document save(com.trs.components.wcm.content.persistent.Document newDocument, List _aAppendixList, List _aRelationList, Map _hFlowContextInfo) throws WCMException {
        return this.save(newDocument, _aAppendixList, _aRelationList, _hFlowContextInfo, true);
    }

    public com.trs.components.wcm.content.persistent.Document save(com.trs.components.wcm.content.persistent.Document newDocument, List _aAppendixList, List _aRelationList, Map _hFlowContextInfo, boolean _bNeedValidateRight) throws WCMException {
        if (_bNeedValidateRight && !this.validateRight(this.getLoginUser(), newDocument, 80)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label6", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fdd\u5b58\u6587\u6863!"));
        }
        String sLogDesc = I18NMessage.get(DocumentService.class, "DocumentService.label7", "\u4fdd\u5b58") + newDocument;
        boolean bAddMode = newDocument.isAddMode();
        String sOper = bAddMode ? "DOCUMENT_ADD" : "DOCUMENT_EDIT";
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), sOper, sLogDesc, newDocument);
        try {
            this.m_oDocumentMgr.save(newDocument);
            this.m_oAppendixMgr.saveAppendixes(newDocument, _aAppendixList);
            this.m_oRelationMgr.saveRelations(newDocument, _aRelationList);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(DocumentService.class, "DocumentService.label8", "\u4fdd\u5b58\u6587\u6863\u5931\u8d25!"), t);
        }
        int nDocFlag = newDocument.getPropertyAsInt("DocFlag", 0);
        if (bAddMode && nDocFlag == 0) {
            try {
                WCMProcessServiceHelper.startDocumentInFlow(this.getLoginUser(), newDocument, _hFlowContextInfo);
            }
            catch (Throwable ex) {
                ServiceInvocationException exp = new ServiceInvocationException(I18NMessage.get(DocumentService.class, "DocumentService.label120", "\u6587\u6863[") + newDocument.getTitle() + "-" + newDocument.getId() + I18NMessage.get(DocumentService.class, "DocumentService.label121", "]\u5df2\u7ecf\u4fdd\u5b58\u6210\u529f\uff0c\u4f46\u56e0\u60a8\u7684\u5de5\u4f5c\u6d41\u8bbe\u7f6e\u6709\u8bef\uff0c\u5c06\u5176\u6295\u5165\u6d41\u8f6c\u5931\u8d25\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u5de5\u4f5c\u6d41\uff0c\u4fee\u6b63\u540e\u5c06\u6587\u6863\u91cd\u65b0\u6295\u5165\u6d41\u8f6c\uff01"), ex);
                exp.setErrorCode("17080");
                throw exp;
            }
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return newDocument;
    }

    @Override
    public boolean delete(String _sDocumentIds, Channel _currChannel, boolean _bDrop) throws WCMException {
        if (_sDocumentIds == null || _sDocumentIds.length() == 0) {
            return true;
        }
        Documents delDocuments = Documents.findByIds(this.getLoginUser(), _sDocumentIds);
        return this.delete(delDocuments, _currChannel, _bDrop);
    }

    @Override
    public boolean delete(Documents _currDocuments, Channel _currChannel, boolean _bDrop) throws WCMException {
        if (_currDocuments == null) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label9", "\u6ca1\u6709\u8981\u5220\u9664\u7684\u6587\u6863\uff01"));
        }
        Channel channel = _currChannel;
        for (int i = 0; i < _currDocuments.size(); ++i) {
            com.trs.components.wcm.content.persistent.Document delDoc = (com.trs.components.wcm.content.persistent.Document)_currDocuments.getAt(i);
            if (delDoc == null || _currChannel == null && (channel = delDoc.getChannelId() == 0 ? Channel.DRAFT_CHANNEL : delDoc.getChannel()) == null) continue;
            this.delete(delDoc, channel, _bDrop);
        }
        return true;
    }

    @Override
    public boolean delete(int _nDocumentId, Channel _currChannel, boolean _bDrop) throws WCMException {
        com.trs.components.wcm.content.persistent.Document currDocument = com.trs.components.wcm.content.persistent.Document.findById(_nDocumentId);
        if (currDocument == null) {
            throw new WCMException(200006, I18NMessage.get(DocumentService.class, "DocumentService.label10", "\u6ca1\u6709\u627e\u5230[id=") + _nDocumentId + I18NMessage.get(DocumentService.class, "DocumentService.label11", "]\u7684\u6587\u6863,\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        return this.delete(currDocument, _currChannel, _bDrop);
    }

    @Override
    public boolean delete(com.trs.components.wcm.content.persistent.Document _currDocument, Channel _currChannel, boolean _bDrop) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label12", "\u5f53\u524d\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        Channel channel = _currChannel;
        if (channel == null) {
            channel = _currDocument.getChannel();
        }
        if (_currDocument.isDraft()) {
            channel = Channel.DRAFT_CHANNEL;
        }
        if (channel == null) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label13", "\u5f53\u524d\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        if (!this.validateRight(this.getLoginUser(), _currDocument, 33)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label14", "\u60a8\u6682\u65f6\u65e0\u6743\u5728[") + _currChannel + I18NMessage.get(DocumentService.class, "DocumentService.label15", "]\u4e0b\u5220\u9664\u6587\u6863[") + _currDocument + "]");
        }
        long lStartTime = LogServer.startRecord(this.getLoginUser().getName(), "DOCUMENT_DEL", I18NMessage.get(DocumentService.class, "DocumentService.label16", "\u5220\u9664:") + _currDocument, _currDocument);
        try {
            this.m_oDocumentMgr.delete(_currDocument, channel, _bDrop);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(DocumentService.class, "DocumentService.label17", "\u5220\u9664\u6587\u6863\u5931\u8d25\uff01"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return true;
    }

    private Reports copyTo(com.trs.components.wcm.content.persistent.Document _fromDocument, Channel _fromChannel, Channel _toChannel) throws WCMException {
        Reports currReports = new Reports(I18NMessage.get(DocumentService.class, "DocumentService.label18", "\u590d\u5236\u6587\u6863"));
        if (!DocumentAuthServer.hasRight(this.getLoginUser(), (BaseChannel)_fromChannel, _fromDocument, 34)) {
            currReports.addFailedReport(_fromDocument + I18NMessage.get(DocumentService.class, "DocumentService.label19", "\u590d\u5236\u5931\u8d25!"), new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label20", "\u5bf9\u4e0d\u8d77,\u60a8\u6682\u65f6\u65e0\u6743\u4ece\u9891\u9053[") + _fromChannel.getName() + I18NMessage.get(DocumentService.class, "DocumentService.label21", "]\u590d\u5236\u6587\u6863!")));
            return currReports;
        }
        if (!this.validateRight(this.getLoginUser(), _toChannel, 31)) {
            currReports.addFailedReport(_toChannel + I18NMessage.get(DocumentService.class, "DocumentService.label22", "\u6dfb\u52a0\u5931\u8d25!"), new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label23", "\u5bf9\u4e0d\u8d77,\u60a8\u6682\u65f6\u65e0\u6743\u5728\u9891\u9053[") + _toChannel.getName() + I18NMessage.get(DocumentService.class, "DocumentService.label24", "]\u6dfb\u52a0\u6587\u6863!")));
            return currReports;
        }
        String sLogDesc = I18NMessage.get(DocumentService.class, "DocumentService.label122", "\u590d\u5236") + _fromDocument + I18NMessage.get(DocumentService.class, "DocumentService.label25", "\u5230") + _toChannel;
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "DOCUMENT_COPY", sLogDesc, _fromDocument);
        com.trs.components.wcm.content.persistent.Document newDoc = null;
        try {
            newDoc = this.m_oDocumentMgr.copyDocument(_fromDocument, _fromChannel, _toChannel);
            if (newDoc == null) {
                currReports.addSucessedReport(_fromDocument + I18NMessage.get(DocumentService.class, "DocumentService.label26", "\u5728") + _toChannel + I18NMessage.get(DocumentService.class, "DocumentService.label27", "\u4e0b\u5df2\u5b58\u5728\u5f15\u7528\u5173\u7cfb!"));
                return currReports;
            }
            if (newDoc.getId() != _fromDocument.getId()) {
                this.m_oAppendixMgr.copyAppendixes(_fromDocument, newDoc);
                this.m_oRelationMgr.copyRelations(_fromDocument, newDoc);
                this.m_oDocReplyMgr.copyDocReplys(_fromDocument, newDoc);
            }
            currReports.addSucessedReport(_fromDocument + I18NMessage.get(DocumentService.class, "DocumentService.label28", "\u590d\u5236\u6210\u529f\uff01"));
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            currReports.addFailedReport(_fromDocument + I18NMessage.get(DocumentService.class, "DocumentService.label19", "\u590d\u5236\u5931\u8d25!"), e);
            return currReports;
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return currReports;
    }

    private Reports moveTo(com.trs.components.wcm.content.persistent.Document _fromDocument, Channel _fromChannel, Channel _toChannel) throws WCMException {
        Reports currReports = new Reports(I18NMessage.get(DocumentService.class, "DocumentService.label29", "\u79fb\u52a8\u6587\u6863."));
        if (!DocumentAuthServer.hasRight(this.getLoginUser(), (BaseChannel)_fromChannel, _fromDocument, 33) || !this.validateRight(this.getLoginUser(), _toChannel, 31)) {
            currReports.addFailedReport(_fromDocument + I18NMessage.get(DocumentService.class, "DocumentService.label30", "\u79fb\u52a8\u5931\u8d25!"), new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label31", "\u5bf9\u4e0d\u8d77,\u60a8\u6682\u65f6\u65e0\u6743\u79fb\u52a8!")));
            return currReports;
        }
        try {
            currReports.addReport(this.m_oDocumentMgr.moveTo(_fromDocument, _fromChannel, _toChannel));
        }
        catch (WCMException ex) {
            currReports.addFailedReport(_fromDocument + I18NMessage.get(DocumentService.class, "DocumentService.label30", "\u79fb\u52a8\u5931\u8d25!"), ex);
        }
        return currReports;
    }

    @Override
    public void withdraw(com.trs.components.wcm.content.persistent.Document _currDocument) {
    }

    @Override
    public Reports importDocuments(String _sImportFile, int _nDstChnlId, String _sXSLFile, boolean _bExitWhenDocumentExisted, boolean _bOmitOriginalChannel) throws WCMException {
        DocumentImporter importer = (DocumentImporter)DreamFactory.createObjectById("DocumentImporter");
        Channel dstChannel = Channel.findById(_nDstChnlId);
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "DOCUMENT_IMPORT", I18NMessage.get(DocumentService.class, "DocumentService.label32", "\u5bfc\u5165\u6587\u6863"), dstChannel);
        Reports importReports = new Reports("");
        try {
            if (!this.validateRight(this.getLoginUser(), dstChannel, 31)) {
                throw new AuthError(I18NMessage.get(DocumentService.class, "DocumentService.label33", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5728") + dstChannel + I18NMessage.get(DocumentService.class, "DocumentService.label34", "\u4e0a\u91c7\u96c6\u6587\u6863!"));
            }
            importReports = importer.importFromFile(_sImportFile, dstChannel, _sXSLFile, _bExitWhenDocumentExisted, _bOmitOriginalChannel);
        }
        catch (BizError e) {
            throw e;
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            importReports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label35", "\u6587\u6863\u5bfc\u5165\u5931\u8d25"), e);
            throw new BizError(I18NMessage.get(DocumentService.class, "DocumentService.label36", "\u5bfc\u5165\u6587\u6863\u5931\u8d25!"));
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return importReports;
    }

    @Override
    public Reports importTRSDocuments(String _sImportFile, int _nDestChannelId, String _sDefineXmlFile, boolean _bExitWhenDocumentExisted, boolean _bOmitOriginalChannel) throws WCMException {
        DocumentImporter importer = (DocumentImporter)DreamFactory.createObjectById("DocumentImporter");
        Channel dstChannel = Channel.findById(_nDestChannelId);
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "DOCUMENT_IMPORT", I18NMessage.get(DocumentService.class, "DocumentService.label32", "\u5bfc\u5165\u6587\u6863"), dstChannel);
        Reports importReports = new Reports("");
        try {
            if (!this.validateRight(this.getLoginUser(), dstChannel, 31)) {
                throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label33", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5728") + dstChannel + I18NMessage.get(DocumentService.class, "DocumentService.label34", "\u4e0a\u91c7\u96c6\u6587\u6863!"));
            }
            importReports = importer.importFromTRSFile(_sImportFile, dstChannel, _sDefineXmlFile, _bExitWhenDocumentExisted, _bOmitOriginalChannel);
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            importReports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label35", "\u6587\u6863\u5bfc\u5165\u5931\u8d25"), e);
            throw new WCMException(1100, I18NMessage.get(DocumentService.class, "DocumentService.label36", "\u5bfc\u5165\u6587\u6863\u5931\u8d25!"), e);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return importReports;
    }

    @Override
    public FileStore[] getExitedXslFiles() throws WCMException {
        return DocumentImporter.getExistedXslFiles(this.getLoginUser());
    }

    @Override
    public FileStore[] getExitedMappingFiles() throws WCMException {
        return DocumentImporter.getExistedMapingFiles(this.getLoginUser());
    }

    @Override
    public String getMyDocumentImportSourceFilePath() throws WCMException {
        return DocumentImporter.getMyDocumentImportSourceFilePath(this.getLoginUser());
    }

    @Override
    public void changeDocumentsStatus(Documents _currDocuments, Channel _currChannel, Status _currStatus) throws WCMException {
        if (_currDocuments == null || _currDocuments.isEmpty()) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label37", "\u6587\u6863\u96c6\u5408\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539\u72b6\u6001\uff01"));
        }
        com.trs.components.wcm.content.persistent.Document currDocument = null;
        for (int i = 0; i < _currDocuments.size(); ++i) {
            currDocument = (com.trs.components.wcm.content.persistent.Document)_currDocuments.getAt(i);
            if (currDocument == null) continue;
            this.changeDocumentStatus(currDocument, _currChannel, _currStatus);
        }
    }

    @Override
    public void changeDocumentStatus(com.trs.components.wcm.content.persistent.Document _currDocument, Channel _currChannel, Status _currStatus) throws WCMException {
        Channel currChannel;
        if (_currDocument == null) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label38", "\u6587\u6863\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539\u72b6\u6001\uff01"));
        }
        Channel channel = currChannel = _currChannel == null ? _currDocument.getChannel() : _currChannel;
        if (currChannel == null) {
            throw new WCMDatainvalidException(20, I18NMessage.get(DocumentService.class, "DocumentService.label39", "\u6ca1\u6709\u6307\u5b9a\u9891\u9053\uff0c\u65e0\u6cd5\u4fee\u6539\u72b6\u6001\uff01"));
        }
        if (!DocumentAuthServer.hasRight(this.getLoginUser(), (BaseChannel)_currChannel, _currDocument, _currStatus.getRightIndex())) {
            throw new WCMDatainvalidException(I18NMessage.get(DocumentService.class, "DocumentService.label40", "\u6ca1\u6709\u6743\u9650\u6539\u53d8") + currChannel + I18NMessage.get(DocumentService.class, "DocumentService.label41", "\u4e0b\u6587\u6863\u7684\u72b6\u6001\uff01"));
        }
        this.m_oDocumentMgr.changeStatus(_currDocument, currChannel, _currStatus);
    }

    @Override
    public Appendixes getAppendixes(com.trs.components.wcm.content.persistent.Document _currDocument) throws WCMException {
        return this.getAppendixes(_currDocument, -1);
    }

    @Override
    public Appendixes getAppendixes(com.trs.components.wcm.content.persistent.Document _currDocument, int _nAppendixType) throws WCMException {
        return this.getAppendixes(_currDocument, _nAppendixType, null);
    }

    @Override
    public Appendixes getAppendixes(com.trs.components.wcm.content.persistent.Document _document, int _nAppendixType, WCMFilter _filter) throws WCMException {
        AppendixMgr manager = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        return manager.getAppendixes(_document, _nAppendixType, _filter);
    }

    @Override
    public Appendixes getAppendixes(com.trs.components.wcm.content.persistent.Document _currDocument, WCMFilter _apdFilter) throws WCMException {
        return this.m_oAppendixMgr.getAppendixes(_currDocument, _apdFilter);
    }

    @Override
    public Documents getRelatedDocuments(com.trs.components.wcm.content.persistent.Document _currDocument, int _nGetByWhich, WCMFilter _filter, boolean _bExactMatch, boolean _bMultiSites) throws WCMException {
        return this.m_oDocumentMgr.getRelatedDocuments(_currDocument, _nGetByWhich, _filter, _bExactMatch, _bMultiSites);
    }

    @Override
    public Documents getRelatedDocuments(com.trs.components.wcm.content.persistent.Document _currDocument, int _nGetByWhich) throws WCMException {
        return this.getRelatedDocuments(_currDocument, _nGetByWhich, null);
    }

    @Override
    public Documents getRelatedDocuments(com.trs.components.wcm.content.persistent.Document _currDocument, int _nGetByWhich, WCMFilter _filter) throws WCMException {
        return this.getRelatedDocuments(_currDocument, _nGetByWhich, _filter, true, false);
    }

    @Override
    public com.trs.components.wcm.content.persistent.Document recoverDocument(DocBak _aDocBak, com.trs.components.wcm.content.persistent.Document _currDocument) throws WCMException {
        if (_aDocBak == null || _currDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label42", "\u6587\u6863\u5907\u4efd\u6216\u8005\u6587\u6863\u65e0\u6548\uff0c\u65e0\u6cd5\u4ece\u5907\u4efd\u6062\u590d\u6587\u6863!"));
        }
        if (!this.validateRight(this.getLoginUser(), _currDocument, 32)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label43", "\u5bf9\u4e0d\u8d77,\u4f60\u65e0\u6743\u4fee\u6539\u6587\u6863!"));
        }
        DocBakMgr aDocBakMgr = (DocBakMgr)DreamFactory.createObjectById("DocBakMgr");
        return aDocBakMgr.recoverDocument(_aDocBak, _currDocument);
    }

    @Override
    public DocBak backup(com.trs.components.wcm.content.persistent.Document _currDocument) throws WCMException {
        if (!this.validateRight(this.getLoginUser(), _currDocument, 32)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label44", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5907\u4efd\u8be5\u6587\u6863!"));
        }
        return this.m_oDocBakMgr.bakupDocument(_currDocument);
    }

    @Override
    public void deleteDocBak(int _nDocBakId) throws WCMException {
        DocBak docbak = (DocBak)DocBak.findById(_nDocBakId);
        if (docbak == null) {
            throw new WCMException(200006, I18NMessage.get(DocumentService.class, "DocumentService.label45", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a[id=") + _nDocBakId + I18NMessage.get(DocumentService.class, "DocumentService.label46", "]\u7684\u6587\u6863\u7248\u672c\uff01"));
        }
        this.deleteDocBak(docbak);
    }

    @Override
    public void deleteDocBaks(String _sDocBakIds) throws WCMException {
        DocBaks docbaks = DocBaks.findByIds(this.getLoginUser(), _sDocBakIds);
        if (docbaks.isEmpty()) {
            return;
        }
        this.deleteDocBaks(docbaks);
    }

    @Override
    public void deleteDocBaks(DocBaks _docbaks) throws WCMException {
        if (_docbaks == null || _docbaks.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label47", "\u65e0\u6548\u7684\u6587\u6863\u7248\u672c\u96c6\u5408,\u6ca1\u6709\u9700\u8981\u5220\u9664\u7684\u6587\u6863\u7248\u672c!"));
        }
        for (int i = 0; i < _docbaks.size(); ++i) {
            DocBak docbak = (DocBak)_docbaks.getAt(i);
            if (docbak == null) continue;
            this.deleteDocBak(docbak);
        }
    }

    @Override
    public void deleteDocBak(DocBak _docbak) throws WCMException {
        if (_docbak == null) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label48", "\u65e0\u6548\u7684\u6587\u6863\u7248\u672c\u5bf9\u8c61,\u65e0\u6cd5\u5220\u9664!"));
        }
        if (!this.validateRight(this.getLoginUser(), _docbak.getDocument(), 32)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label49", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5220\u9664\u6587\u6863\u7248\u672c!"));
        }
        this.m_oDocBakMgr.deleteDocBak(_docbak);
    }

    @Override
    public User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public Channels getQuoteChannels(com.trs.components.wcm.content.persistent.Document _currDocument) throws WCMException {
        DocumentMgr currDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return currDocumentMgr.getQutoedChannels(_currDocument, 0, null);
    }

    @Override
    public Channels getQuoteChannels(int _nDocumentId) throws WCMException {
        if (_nDocumentId <= 0) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label50", "\u65e0\u6548\u7684\u6587\u6863Id[") + _nDocumentId + "]");
        }
        com.trs.components.wcm.content.persistent.Document currDocument = com.trs.components.wcm.content.persistent.Document.findById(_nDocumentId);
        if (currDocument == null) {
            throw new WCMException(200006, I18NMessage.get(DocumentService.class, "DocumentService.label51", "\u6ca1\u6709\u627e\u5230\u6307\u5b9aId\u7684\u6587\u6863,\u65e0\u6cd5\u83b7\u53d6\u5f15\u7528\u8be5\u6587\u6863\u7684\u9891\u9053"));
        }
        return this.getQuoteChannels(currDocument);
    }

    @Override
    public void restore(com.trs.components.wcm.content.persistent.Document _currDocument, Channel _currChannel) throws WCMException {
        if (!DocumentAuthServer.hasRight(this.getLoginUser(), (BaseChannel)_currChannel, _currDocument, 33)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label52", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4ece\u56de\u6536\u7ad9\u4e2d\u6062\u590d\u6587\u6863!"));
        }
        this.m_oDocumentMgr.restore(_currDocument, _currChannel);
    }

    @Override
    public void restore(Documents _documents) throws WCMException {
        if (_documents == null || _documents.isEmpty()) {
            return;
        }
        com.trs.components.wcm.content.persistent.Document currDocument = null;
        for (int i = 0; i < _documents.size(); ++i) {
            currDocument = (com.trs.components.wcm.content.persistent.Document)_documents.getAt(i);
            if (currDocument == null) continue;
            this.restore(currDocument, currDocument.getChannel());
        }
    }

    @Override
    public Reports restore(String _sDelDocIds, int _nChannelId) throws WCMException {
        Documents delDocuments = Documents.findByIds(ContextHelper.getLoginUser(), _sDelDocIds);
        if (delDocuments == null || delDocuments.isEmpty()) {
            throw new WCMException(I18NMessage.get(DocumentService.class, "DocumentService.label53", "\u6ca1\u6709\u8981\u6062\u590d\u7684\u6587\u6863\uff01"));
        }
        Channel currChannel = null;
        if (_nChannelId > 0 && (currChannel = Channel.findById(_nChannelId)) == null) {
            throw new WCMException(I18NMessage.get(DocumentService.class, "DocumentService.label54", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6062\u590d\u6587\u6863\uff01"));
        }
        Reports currReports = new Reports(I18NMessage.get(DocumentService.class, "DocumentService.label55", "\u6062\u590d\u6587\u6863."));
        for (int i = 0; i < delDocuments.size(); ++i) {
            com.trs.components.wcm.content.persistent.Document currDocument = (com.trs.components.wcm.content.persistent.Document)delDocuments.getAt(i);
            if (currDocument == null) {
                m_oLogger.debug((Object)I18NMessage.get(DocumentService.class, "DocumentService.label56", "\u6062\u590d\u6587\u6863\u65f6\u53d1\u73b0\u6709\u4e00\u7bc7\u4e3a\u7a7a\uff01"));
                currReports.addWarnedReport(I18NMessage.get(DocumentService.class, "DocumentService.label57", "\u6062\u590d\u6587\u6863\u65f6\u53d1\u73b0\u6709\u4e00\u7bc7\u4e3a\u7a7a"), null);
                continue;
            }
            try {
                this.restore(currDocument, currChannel);
                currReports.addSucessedReport(I18NMessage.get(DocumentService.class, "DocumentService.label58", "\u6210\u529f\u6062\u590d\u4e00\u7bc7\u6587\u6863\uff01\u6587\u6863\u6807\u9898\uff1a") + currDocument.getTitle());
                continue;
            }
            catch (WCMException ex) {
                currReports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label59", "\u6062\u590d\u6587\u6863\u5931\u8d25\uff01"), ex);
            }
        }
        return currReports;
    }

    @Override
    public Relations getRelations(com.trs.components.wcm.content.persistent.Document _currDocument) throws WCMException {
        if (_currDocument == null) {
            return null;
        }
        RelationMgr currRelationMgr = (RelationMgr)DreamFactory.createObjectById("RelationMgr");
        return currRelationMgr.getRelations(_currDocument);
    }

    @Override
    public int getMaxToppedNum() {
        return this.m_oDocumentMgr.getMaxToppedNum();
    }

    @Override
    public Documents getToppedDocuments(Channel _currChannel, WCMFilter _docFilter) throws WCMException {
        return this.m_oDocumentMgr.getToppedDocuments(_currChannel, _docFilter);
    }

    @Override
    public boolean isDocumentTopped(com.trs.components.wcm.content.persistent.Document _currDocument, Channel _currChannel) throws WCMException {
        DocumentMgr aDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return aDocumentMgr.isDocumentTopped(_currDocument, _currChannel);
    }

    @Override
    public void setTopDocument(com.trs.components.wcm.content.persistent.Document _currDocument, Channel _currChannel, int _nToppedOrder, CMyDateTime _dtValidUntil) throws WCMException {
        if (!this.validateRight(this.getLoginUser(), _currChannel, 32)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label60", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5bf9\u6b64\u6587\u6863\u8fdb\u884c\u7f6e\u9876\u8bbe\u7f6e!"));
        }
        DocumentMgr aDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        aDocumentMgr.setTopedDocument(_currDocument, _currChannel, _nToppedOrder, _dtValidUntil);
    }

    @Override
    public void removeToppedDocument(com.trs.components.wcm.content.persistent.Document _currDocument, Channel _currChannel) throws WCMException {
        if (!this.validateRight(this.getLoginUser(), _currChannel, 32)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label61", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u7f16\u8f91\u6b64\u6587\u6863!"));
        }
        DocumentMgr aDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        aDocumentMgr.removeToppedDocument(_currChannel, _currDocument);
    }

    @Override
    public int getTopPosition(com.trs.components.wcm.content.persistent.Document _currDocument, Channel _currChannel) throws WCMException {
        DocumentMgr aDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return aDocumentMgr.getTopPosition(_currChannel, _currDocument);
    }

    @Override
    public boolean isDocumentTopScheduled(com.trs.components.wcm.content.persistent.Document _currDocument, Channel _currChannel) throws WCMException {
        DocumentMgr currMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        DocumentPriMgr currDocPriMgr = (DocumentPriMgr)DreamFactory.createObjectById("DocumentPriMgr");
        return currDocPriMgr.findSchedule(currMgr.findChnlDoc(_currDocument, _currChannel)) != null;
    }

    @Override
    public CMyDateTime getTopTime(com.trs.components.wcm.content.persistent.Document _currDocument, Channel _currChannel) throws WCMException {
        DocumentMgr currMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return currMgr.getDocumentTopTime(_currDocument, _currChannel);
    }

    @Override
    public void moveForward(int _currDocumentId, int _currChannelId) throws WCMException {
        ChnlDoc toChnlDoc = this.m_oDocumentMgr.getPreviousChnlDoc(this.m_oDocumentMgr.findChnlDoc(com.trs.components.wcm.content.persistent.Document.findById(_currDocumentId), Channel.findById(_currChannelId)), false);
        if (toChnlDoc == null) {
            return;
        }
        this.moveDocumentInChannel(_currDocumentId, toChnlDoc.getDocId(), _currChannelId);
    }

    @Override
    public void moveBackward(int _currDocumentId, int _currChannelId) throws WCMException {
        ChnlDoc toChnlDoc = this.m_oDocumentMgr.getNextChnlDoc(this.m_oDocumentMgr.findChnlDoc(com.trs.components.wcm.content.persistent.Document.findById(_currDocumentId), Channel.findById(_currChannelId)), false);
        if (toChnlDoc == null) {
            return;
        }
        this.moveDocumentInChannel(_currDocumentId, toChnlDoc.getDocId(), _currChannelId);
    }

    @Override
    public void moveFirst(int _currDocumentId, int _currChannelId) throws WCMException {
        ChnlDoc toChnlDoc = this.m_oDocumentMgr.getFirstChnlDoc(this.m_oDocumentMgr.findChnlDoc(com.trs.components.wcm.content.persistent.Document.findById(_currDocumentId), Channel.findById(_currChannelId)), false);
        if (toChnlDoc == null) {
            return;
        }
        this.moveDocumentInChannel(_currDocumentId, toChnlDoc.getDocId(), _currChannelId);
    }

    @Override
    public void moveLast(int _currDocumentId, int _currChannelId) throws WCMException {
        ChnlDoc toChnlDoc = this.m_oDocumentMgr.getLastChnlDoc(this.m_oDocumentMgr.findChnlDoc(com.trs.components.wcm.content.persistent.Document.findById(_currDocumentId), Channel.findById(_currChannelId)), false);
        if (toChnlDoc == null) {
            return;
        }
        this.moveDocumentInChannel(_currDocumentId, toChnlDoc.getDocId(), _currChannelId, 0);
    }

    @Override
    public void moveDocumentInChannel(int _fromDocumentId, int _toDocumentId, int _currChannelId) throws WCMException {
        this.moveDocumentInChannel(_fromDocumentId, _toDocumentId, _currChannelId, 1);
    }

    @Override
    public void moveDocumentInChannel(int _fromDocumentId, int _toDocumentId, int _currChannelId, int _nPostionCode) throws WCMException {
        com.trs.components.wcm.content.persistent.Document fromDocument = com.trs.components.wcm.content.persistent.Document.findById(_fromDocumentId);
        if (fromDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label62", "\u6e90\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539\u987a\u5e8f\uff01"));
        }
        this.m_oDocumentMgr.moveDocumentInChannel(com.trs.components.wcm.content.persistent.Document.findById(_fromDocumentId), com.trs.components.wcm.content.persistent.Document.findById(_toDocumentId), Channel.findById(_currChannelId), _nPostionCode);
    }

    @Override
    public void mirrorTo(com.trs.components.wcm.content.persistent.Document _currDocument, Channel _toChannel) throws WCMException {
        if (!this.validateRight(this.getLoginUser(), _currDocument, 34)) {
            throw new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label64", "\u4f60\u65e0\u6743\u5efa\u7acb\u6587\u6863\u955c\u50cf\uff1a") + _currDocument.getTitle());
        }
        DocumentMgr currDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        currDocumentMgr.mirrorTo(_currDocument, _toChannel);
    }

    @Override
    public Channels getMirrorChannels(com.trs.components.wcm.content.persistent.Document _currDocument) throws WCMException {
        DocumentMgr currDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return currDocumentMgr.getQutoedChannels(_currDocument, 3, null);
    }

    @Override
    public Channels getChannels(com.trs.components.wcm.content.persistent.Document _currDocument) throws WCMException {
        DocumentMgr currDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return currDocumentMgr.getQutoedChannels(_currDocument, 0, null);
    }

    @Override
    public boolean delete(ChnlDocs _delChnlDocs, boolean _bDrop) throws WCMException {
        if (_delChnlDocs == null) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label65", "\u9891\u9053\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        for (int i = 0; i < _delChnlDocs.size(); ++i) {
            ChnlDoc currChnlDoc = (ChnlDoc)_delChnlDocs.getAt(i);
            if (currChnlDoc == null) {
                m_oLogger.error((Object)I18NMessage.get(DocumentService.class, "DocumentService.label66", "\u5220\u9664\u9891\u9053\u6587\u6863\u65f6\uff0c\u6709\u4e00\u7bc7\u9891\u9053\u6587\u6863\u4e3a\u7a7a\uff01"));
                continue;
            }
            this.delete(currChnlDoc.getDocument(), currChnlDoc.getChannel(), _bDrop);
        }
        return true;
    }

    public String getLoginUserName() {
        return ContextHelper.getLoginUser().getName();
    }

    @Override
    public String export(com.trs.components.wcm.content.persistent.Document _document, String _sFieldsList, boolean _bWithAppendixes) throws WCMException {
        return this.getExporter().export(_document, _sFieldsList, _bWithAppendixes);
    }

    @Override
    public String export(int _nDocId, String _sFieldsList, boolean _bWithAppendixes) throws WCMException {
        return this.getExporter().export(_nDocId, _sFieldsList, _bWithAppendixes);
    }

    @Override
    public String export(String _sDocIds, String _sFieldsList, boolean _bWithAppendixes) throws WCMException {
        return this.export(Documents.findByIds(this.getLoginUser(), _sDocIds), _sFieldsList, _bWithAppendixes);
    }

    @Override
    public String export(Documents _documents, String _sFieldsList, boolean _bWithAppendixes) throws WCMException {
        return this.getExporter().export(_documents, _sFieldsList, _bWithAppendixes);
    }

    public String export(String _sDocIds, String _sFieldsList, boolean _bWithAppendixes, boolean _bWithExtFields) throws WCMException {
        User loginUser = this.getLoginUser();
        String sFieldList = _sFieldsList;
        if (_bWithExtFields) {
            ExtendedFields fields = new ExtendedFields(loginUser);
            WCMFilter filter = new WCMFilter("", "TableName=?", "EXTFIELDID asc", "EXTFIELDID,FIELDNAME");
            filter.addSearchValues(0, "WCMDOCUMENT");
            fields.open(filter);
            StringBuffer buff = new StringBuffer(256);
            if (!CMyString.isEmpty(sFieldList)) {
                buff.append(sFieldList).append(",");
            }
            ExtendedField field = null;
            int p = fields.size();
            for (int i = 0; i < p; ++i) {
                field = (ExtendedField)fields.getAt(i);
                if (field == null) continue;
                buff.append(field.getName());
                buff.append(",");
            }
            sFieldList = buff.substring(0, buff.length() - 1);
        }
        return this.export(_sDocIds, sFieldList, _bWithAppendixes);
    }

    private DocumentExporter getExporter() {
        return (DocumentExporter)DreamFactory.createObjectById("DocumentExporter");
    }

    @Override
    public Reports quoteTo(com.trs.components.wcm.content.persistent.Document _currDocument, String _sToChannelIds) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label69", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5176\u5f15\u7528\uff01"));
        }
        Reports currReports = new Reports(I18NMessage.get(DocumentService.class, "DocumentService.label70", "\u5f15\u7528") + _currDocument);
        try {
            this.m_oDocumentMgr.deleteDocQuotes(_currDocument, _sToChannelIds);
        }
        catch (WCMException ex) {
            currReports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label71", "\u5220\u9664\u4e0d\u518d\u4f7f\u7528\u7684\u5f15\u7528\u5173\u7cfb\u65f6\u53d1\u751f\u9519\u8bef\uff01"), ex);
            return currReports;
        }
        Channels toChannels = Channels.findByIds(ContextHelper.getLoginUser(), _sToChannelIds);
        if (toChannels == null || toChannels.isEmpty()) {
            currReports.addWarnedReport(I18NMessage.get(DocumentService.class, "DocumentService.label72", "\u76ee\u6807\u9891\u9053\u4e3a\u7a7a\uff0c\u6ca1\u6709\u6267\u884c\u5f15\u7528\u7684\u64cd\u4f5c\uff01"), null);
            return currReports;
        }
        for (int i = 0; i < toChannels.size(); ++i) {
            Channel _toChannel = (Channel)toChannels.getAt(i);
            Reports oneReports = this.quoteTo(_currDocument, _currDocument.getChannel(), _toChannel);
            currReports.merge(oneReports);
        }
        return currReports;
    }

    private Reports quoteTo(com.trs.components.wcm.content.persistent.Document _currDocument, Channel _fromChannel, Channel _toChannel) {
        Reports currReports = new Reports(I18NMessage.get(DocumentService.class, "DocumentService.label73", "\u5f15\u7528\u6587\u6863."));
        if (_toChannel == null) {
            currReports.addWarnedReport(I18NMessage.get(DocumentService.class, "DocumentService.label74", "\u5f15\u7528\u6587\u6863\u65f6\uff0c\u4e00\u4e2a\u76ee\u6807\u9891\u9053\u4e3a\u7a7a\uff01\u7ee7\u7eed\u6267\u884c\u3002"), null);
            return currReports;
        }
        try {
            if (!DocumentAuthServer.hasRight(this.getLoginUser(), (BaseChannel)_fromChannel, _currDocument, 34) || !this.validateRight(this.getLoginUser(), _toChannel, 31)) {
                currReports.addFailedReport(_currDocument + I18NMessage.get(DocumentService.class, "DocumentService.label75", "]\u5f15\u7528\u5931\u8d25!"), new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label76", "\u5bf9\u4e0d\u8d77,\u60a8\u6682\u65f6\u65e0\u6743\u5f15\u7528\u6587\u6863!")));
                return currReports;
            }
        }
        catch (WCMException ex) {
            currReports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label77", "\u6821\u9a8c\u5f15\u7528\u6587\u6863[") + _currDocument.getTitle() + I18NMessage.get(DocumentService.class, "DocumentService.label78", "]\u6743\u9650\u65f6\u53d1\u751f\u5f02\u5e38\uff01"), ex);
            return currReports;
        }
        try {
            if (ChnlDoc.findByDocAndChnl(_currDocument, _toChannel) != null) {
                currReports.addSucessedReport(_currDocument + I18NMessage.get(DocumentService.class, "DocumentService.label79", "\u5df2\u5728") + _toChannel + I18NMessage.get(DocumentService.class, "DocumentService.label80", "\u4e0b\u5b58\u5728\u5f15\u7528\u5173\u7cfb!"));
            } else {
                this.m_oDocumentMgr.quoteTo(_currDocument, _toChannel);
                currReports.addSucessedReport(_currDocument + I18NMessage.get(DocumentService.class, "DocumentService.label81", "\u5f15\u7528\u6210\u529f!"));
            }
        }
        catch (WCMException ex) {
            currReports.addFailedReport(_currDocument + I18NMessage.get(DocumentService.class, "DocumentService.label82", "\u5f15\u7528\u5230") + _toChannel + I18NMessage.get(DocumentService.class, "DocumentService.label83", "\u5931\u8d25\uff01"), ex);
        }
        return currReports;
    }

    @Override
    public Reports quoteTo(String _sDocumentIds, int _nFromChannelId, String _sToChannelIds) throws WCMException {
        return this.transmitTo(_sDocumentIds, _nFromChannelId, _sToChannelIds, 3);
    }

    @Override
    public Reports copyTo(String _sDocumentIds, int _nFromChannelId, String _sToChannelIds) throws WCMException {
        return this.transmitTo(_sDocumentIds, _nFromChannelId, _sToChannelIds, 1);
    }

    @Override
    public Reports moveTo(String _sDocumentIds, int _nFromChannelId, String _sToChannelIds) throws WCMException {
        return this.transmitTo(_sDocumentIds, _nFromChannelId, _sToChannelIds, 2);
    }

    @Override
    public Reports copyTo(String _fromChnlDocIds, String _toChannelIds) throws WCMException {
        return this.transmitTo(_fromChnlDocIds, _toChannelIds, 1);
    }

    @Override
    public Reports moveTo(String _fromChnlDocIds, String _toChannelIds) throws WCMException {
        return this.transmitTo(_fromChnlDocIds, _toChannelIds, 2);
    }

    @Override
    public Reports quoteTo(String _fromChnlDocIds, String _toChannelIds) throws WCMException {
        return this.transmitTo(_fromChnlDocIds, _toChannelIds, 3);
    }

    @Override
    public Reports mirrorTo(String _fromChnlDocIds, String _toChannelIds) throws WCMException {
        return this.transmitTo(_fromChnlDocIds, _toChannelIds, 4);
    }

    private Reports transmitTo(String _fromChnlDocIds, String _toChannelIds, int _nTransmitType) throws WCMException {
        if (_nTransmitType < 1 || _nTransmitType > 4) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label84", "\u64cd\u4f5c\u7c7b\u578b\u53c2\u6570[") + _nTransmitType + I18NMessage.get(DocumentService.class, "DocumentService.label85", "]\u65e0\u6548\uff01"));
        }
        String sOperText = TRANSMIT_TYPE_TEXT[_nTransmitType - 1];
        Reports currReports = new Reports(sOperText + I18NMessage.get(DocumentService.class, "DocumentService.label86", "\u6587\u6863."));
        if (_fromChnlDocIds == null || _fromChnlDocIds.trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label87", "\u6e90\u9891\u9053\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5") + sOperText + "\uff01");
        }
        if (_toChannelIds == null || _toChannelIds.trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label88", "\u76ee\u6807\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5") + sOperText + "\uff01 ");
        }
        ChnlDocs currChnlDocs = ChnlDocs.findByIds(ContextHelper.getLoginUser(), _fromChnlDocIds);
        if (currChnlDocs == null || currChnlDocs.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label87", "\u6e90\u9891\u9053\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5") + sOperText + "\uff01");
        }
        for (int i = 0; i < currChnlDocs.size(); ++i) {
            if (currChnlDocs.getAt(i) != null) continue;
            currReports.addFailedReport(sOperText + I18NMessage.get(DocumentService.class, "DocumentService.label89", "\u8fc7\u7a0b\u4e2d\u6709\u4e00\u7bc7\u6e90\u9891\u9053\u6587\u6863\u4e3a\u7a7a\uff01"), null);
            currChnlDocs.remove(currChnlDocs.getAt(i), false);
        }
        Channels toChannels = Channels.findByIds(ContextHelper.getLoginUser(), _toChannelIds);
        if (toChannels == null || toChannels.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label88", "\u76ee\u6807\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5") + sOperText + "\uff01 ");
        }
        for (int i = 0; i < toChannels.size(); ++i) {
            if (toChannels.getAt(i) != null) continue;
            currReports.addFailedReport(sOperText + I18NMessage.get(DocumentService.class, "DocumentService.label90", "\u8fc7\u7a0b\u4e2d\u6709\u4e00\u4e2a\u76ee\u6807\u9891\u9053\u4e3a\u7a7a\uff01"), null);
            toChannels.remove(toChannels.getAt(i), false);
        }
        for (int nChnlDoc = currChnlDocs.size() - 1; nChnlDoc >= 0; --nChnlDoc) {
            ChnlDoc fromChnlDoc = (ChnlDoc)currChnlDocs.getAt(nChnlDoc);
            block9: for (int nToChnl = 0; nToChnl < toChannels.size(); ++nToChnl) {
                Channel toChannel = (Channel)toChannels.getAt(nToChnl);
                switch (_nTransmitType) {
                    case 1: {
                        currReports.merge(this.copyTo(fromChnlDoc.getDocument(), fromChnlDoc.getChannel(), toChannel));
                        continue block9;
                    }
                    case 2: {
                        currReports.merge(this.moveTo(fromChnlDoc.getDocument(), fromChnlDoc.getChannel(), toChannel));
                        continue block9;
                    }
                    case 3: {
                        currReports.merge(this.quoteTo(fromChnlDoc.getDocument(), fromChnlDoc.getChannel(), toChannel));
                        continue block9;
                    }
                    case 4: {
                        currReports.merge(this.mirroTo(fromChnlDoc.getDocument(), fromChnlDoc.getChannel(), toChannel));
                        continue block9;
                    }
                    default: {
                        currReports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label91", "\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff01"), null);
                    }
                }
            }
        }
        return currReports;
    }

    private Reports mirroTo(com.trs.components.wcm.content.persistent.Document _currDocument, Channel _fromChannel, Channel _toChannel) {
        Reports currReports = new Reports(I18NMessage.get(DocumentService.class, "DocumentService.label92", "\u955c\u50cf\u5f15\u7528\u6587\u6863."));
        if (_toChannel == null) {
            currReports.addWarnedReport(I18NMessage.get(DocumentService.class, "DocumentService.label93", "\u955c\u50cf\u5f15\u7528\u6587\u6863\u65f6\uff0c\u4e00\u4e2a\u76ee\u6807\u9891\u9053\u4e3a\u7a7a\uff01\u7ee7\u7eed\u6267\u884c\u3002"), null);
            return currReports;
        }
        try {
            if (!DocumentAuthServer.hasRight(this.getLoginUser(), (BaseChannel)_fromChannel, _currDocument, 34) || !this.validateRight(this.getLoginUser(), _toChannel, 31)) {
                currReports.addFailedReport(_currDocument + I18NMessage.get(DocumentService.class, "DocumentService.label94", "\u955c\u50cf\u5f15\u7528\u5931\u8d25!"), new WCMException(1002, I18NMessage.get(DocumentService.class, "DocumentService.label95", "\u5bf9\u4e0d\u8d77,\u60a8\u6682\u65f6\u65e0\u6743\u955c\u50cf\u5f15\u7528\u6587\u6863!")));
                return currReports;
            }
        }
        catch (WCMException ex) {
            currReports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label96", "\u6821\u9a8c\u955c\u50cf\u5f15\u7528\u6587\u6863[") + _currDocument.getTitle() + I18NMessage.get(DocumentService.class, "DocumentService.label78", "]\u6743\u9650\u65f6\u53d1\u751f\u5f02\u5e38\uff01"), ex);
            return currReports;
        }
        try {
            if (ChnlDoc.findByDocAndChnl(_currDocument, _toChannel) != null) {
                currReports.addSucessedReport(_currDocument + I18NMessage.get(DocumentService.class, "DocumentService.label79", "\u5df2\u5728") + _toChannel + I18NMessage.get(DocumentService.class, "DocumentService.label80", "\u4e0b\u5b58\u5728\u5f15\u7528\u5173\u7cfb!"));
                return currReports;
            }
            this.m_oDocumentMgr.mirrorTo(_currDocument, _toChannel);
            currReports.addSucessedReport(_currDocument + I18NMessage.get(DocumentService.class, "DocumentService.label97", "\u6210\u529f\u5f15\u7528\u5230\u4e86") + _toChannel);
        }
        catch (WCMException ex) {
            currReports.addFailedReport(_currDocument + I18NMessage.get(DocumentService.class, "DocumentService.label98", "\u6587\u6863\u5f15\u7528\u5230") + _toChannel + I18NMessage.get(DocumentService.class, "DocumentService.label83", "\u5931\u8d25\uff01"), ex);
        }
        return currReports;
    }

    @Override
    public Reports mirrorTo(String _sDocumentIds, int _nFromChannelId, String _sToChannelIds) throws WCMException {
        return this.transmitTo(_sDocumentIds, _nFromChannelId, _sToChannelIds, 4);
    }

    private Reports transmitTo(String _sDocumentIds, int _nFromChannelId, String _sToChannelIds, int _nTransmitType) throws WCMException {
        Documents fromDocs;
        Channels toChannels;
        Channel fromChannel;
        Reports currReports;
        String sOperText;
        block21: {
            block20: {
                if (_nTransmitType < 1 || _nTransmitType > 4) {
                    throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label84", "\u64cd\u4f5c\u7c7b\u578b\u53c2\u6570[") + _nTransmitType + I18NMessage.get(DocumentService.class, "DocumentService.label85", "]\u65e0\u6548\uff01"));
                }
                sOperText = TRANSMIT_TYPE_TEXT[_nTransmitType - 1];
                currReports = new Reports(sOperText + I18NMessage.get(DocumentService.class, "DocumentService.label86", "\u6587\u6863."));
                if (_sToChannelIds == null || _sToChannelIds.trim().length() == 0) {
                    currReports.addWarnedReport(I18NMessage.get(DocumentService.class, "DocumentService.label99", "\u6b32") + sOperText + I18NMessage.get(DocumentService.class, "DocumentService.label100", "\u7684\u76ee\u6807\u9891\u9053Id\u5e8f\u5217\u4e3a\u7a7a\uff01"), null);
                    return currReports;
                }
                fromChannel = null;
                if (_nFromChannelId > 0 && (fromChannel = Channel.findById(_nFromChannelId)) == null) {
                    throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label101", "\u6307\u5b9a\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c") + sOperText + I18NMessage.get(DocumentService.class, "DocumentService.label102", "\u64cd\u4f5c\uff01"));
                }
                toChannels = Channels.findByIds(ContextHelper.getLoginUser(), _sToChannelIds);
                if (toChannels == null || toChannels.isEmpty()) {
                    currReports.addWarnedReport(I18NMessage.get(DocumentService.class, "DocumentService.label103", "\u6ca1\u6709\u8981") + sOperText + I18NMessage.get(DocumentService.class, "DocumentService.label104", "\u7684\u76ee\u6807\u9891\u9053\uff01"), null);
                    return currReports;
                }
                fromDocs = null;
                if (_sDocumentIds != null && _sDocumentIds.trim().length() != 0) break block20;
                if (fromChannel == null) {
                    throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label99", "\u6b32") + sOperText + I18NMessage.get(DocumentService.class, "DocumentService.label105", "\u7684\u6587\u6863Id\u5e8f\u5217\u4e3a\u7a7a\uff01"));
                }
                switch (_nTransmitType) {
                    case 2: {
                        return this.moveAllDocuments(currReports, fromChannel, toChannels);
                    }
                    case 1: {
                        fromDocs = this.m_oDocumentMgr.getDocuments(fromChannel, null);
                        break block21;
                    }
                    default: {
                        throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label99", "\u6b32") + sOperText + I18NMessage.get(DocumentService.class, "DocumentService.label105", "\u7684\u6587\u6863Id\u5e8f\u5217\u4e3a\u7a7a\uff01"));
                    }
                }
            }
            if (_nFromChannelId == 0 || _nFromChannelId == -2 || _nFromChannelId == -1) {
                fromDocs = Documents.findByIds(this.getLoginUser(), _sDocumentIds);
            } else {
                WCMFilter fromFilter = new WCMFilter("", "DocId IN(" + _sDocumentIds + ")", "");
                fromDocs = this.m_oDocumentMgr.getDocuments(fromChannel, fromFilter);
            }
        }
        if (fromDocs == null || fromDocs.isEmpty()) {
            currReports.addWarnedReport(I18NMessage.get(DocumentService.class, "DocumentService.label103", "\u6ca1\u6709\u8981") + sOperText + I18NMessage.get(DocumentService.class, "DocumentService.label106", "\u7684\u6587\u6863\uff01"), null);
            return currReports;
        }
        for (int nDoc = fromDocs.size() - 1; nDoc >= 0; --nDoc) {
            com.trs.components.wcm.content.persistent.Document fromDoc = (com.trs.components.wcm.content.persistent.Document)fromDocs.getAt(nDoc);
            block11: for (int nChnl = 0; nChnl < toChannels.size(); ++nChnl) {
                Channel toChnl = (Channel)toChannels.getAt(nChnl);
                switch (_nTransmitType) {
                    case 1: {
                        currReports.merge(this.copyTo(fromDoc, fromChannel, toChnl));
                        continue block11;
                    }
                    case 2: {
                        currReports.merge(this.moveTo(fromDoc, fromChannel, toChnl));
                        continue block11;
                    }
                    case 3: {
                        currReports.merge(this.quoteTo(fromDoc, fromChannel, toChnl));
                        continue block11;
                    }
                    case 4: {
                        currReports.merge(this.mirroTo(fromDoc, fromChannel, toChnl));
                        continue block11;
                    }
                    default: {
                        currReports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label91", "\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff01"), null);
                    }
                }
            }
        }
        return currReports;
    }

    private Reports moveAllDocuments(Reports currReports, Channel _fromChannel, Channels _toChannels) throws WCMException {
        if (!this.validateRight(this.getLoginUser(), _fromChannel, 56)) {
            currReports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label107", "\u60a8\u65e0\u6743\u79fb\u52a8") + _fromChannel + I18NMessage.get(DocumentService.class, "DocumentService.label108", "\u7684\u6587\u6863!"), null);
            return currReports;
        }
        int nSize = _toChannels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)_toChannels.getAt(i);
            if (channel == null) continue;
            if (!this.validateRight(this.getLoginUser(), channel, 31)) {
                currReports.addFailedReport(I18NMessage.get(DocumentService.class, "DocumentService.label109", "\u60a8\u65e0\u6743\u5f80") + channel + I18NMessage.get(DocumentService.class, "DocumentService.label110", "\u6dfb\u52a0\u6587\u6863!"), null);
                return currReports;
            }
            this.m_oDocumentMgr.moveAllDocumentsToChannel(_fromChannel, channel);
            currReports.addSucessedReport(I18NMessage.get(DocumentService.class, "DocumentService.label111", "\u6210\u529f\u79fb\u52a8\u9891\u9053[") + _fromChannel.getName() + I18NMessage.get(DocumentService.class, "DocumentService.label112", "]\u7684\u5168\u90e8\u6587\u6863\u5230\u6307\u5b9a\u9891\u9053[") + channel.getName() + "]");
        }
        return currReports;
    }

    @Override
    public ChnlDoc findChnldoc(int _currDocumentId, int _currChannelId) throws WCMException {
        return this.m_oDocumentMgr.findChnlDoc(com.trs.components.wcm.content.persistent.Document.findById(_currDocumentId), Channel.findById(_currChannelId));
    }

    @Override
    public Documents getRecycleDocuments(BaseChannel _channelOrSite, WCMFilter _filter) throws WCMException {
        if (_channelOrSite == null) {
            throw new WCMException(200006, I18NMessage.get(DocumentService.class, "DocumentService.label113", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u9891\u9053"));
        }
        return this.m_oDocumentMgr.getRecycleDocuments(_channelOrSite, _filter);
    }

    @Override
    public Documents getAllRelatedDocumentsByKeywords(String _sKeywords, int _nExcludeDocId, WCMFilter _filter) throws WCMException {
        return this.m_oDocKeywordMgr.getAllRelatedDocumentsByKeywords(_sKeywords, _nExcludeDocId, _filter);
    }

    @Override
    public com.trs.components.wcm.content.persistent.Document saveInfoViewDocument(com.trs.components.wcm.content.persistent.Document _document, Document _contentXmlDoc) throws WCMException {
        return this.saveInfoViewDocument(_document, _contentXmlDoc, new HashMap(0));
    }

    @Override
    public com.trs.components.wcm.content.persistent.Document saveInfoViewDocument(com.trs.components.wcm.content.persistent.Document _document, Document _contentXmlDoc, String _sFlowContextInfo) throws WCMException {
        Map flowContextInfoMap = WCMProcessServiceHelper.makeFlowContextInfoMap(_sFlowContextInfo);
        return this.saveInfoViewDocument(_document, _contentXmlDoc, flowContextInfoMap);
    }

    @Override
    public com.trs.components.wcm.content.persistent.Document saveInfoViewDocument(com.trs.components.wcm.content.persistent.Document _document, InfoView _oInfoView, Map _oInfoViewData) throws WCMException {
        String sNewTitle;
        if (_document == null || _oInfoViewData == null || _oInfoView == null) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label114", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61[null],\u65e0\u6cd5\u4fdd\u5b58!"));
        }
        _document.setFlag(_oInfoView.getId());
        Channel docChannel = _document.getChannel();
        if (docChannel == null) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label115", "\u6587\u6863\u7684\u6240\u5c5e\u9891\u9053\u4e0d\u5b58\u5728!"));
        }
        if (13 != docChannel.getType()) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label116", "\u8981\u4fdd\u5b58\u7684\u6587\u6863\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u8868\u5355\u6587\u6863!"));
        }
        InfoViewMgr oInfoViewMgr = (InfoViewMgr)DreamFactory.createObjectById("InfoViewMgr");
        String sFile = oInfoViewMgr.getAbsolutePath(_oInfoView, _oInfoView.getTemplateFile());
        Document dom4jDocument = InfoViewHelper.buildDOM4JDocument(sFile);
        Element rootElement = dom4jDocument.getRootElement();
        this.fillDomData(rootElement, _oInfoViewData, null);
        String sDocContent = this.getInfoViewDataHelper().buildContent(_oInfoView, _document, dom4jDocument);
        _document.setHtmlContent(sDocContent);
        _document = this.saveInfoViewDocument(_document, dom4jDocument);
        IInfoViewService oInfoViewService = ServiceHelper.createInfoViewService();
        if (_document.isAddMode() && _oInfoView.hasDocSerial()) {
            Node serialNode;
            String serial = oInfoViewService.getInfoViewSerial(_oInfoView);
            _document.setProperty("DOCNO", serial);
            String serialField = _oInfoView.getSerialField();
            if (!CMyString.isEmpty(serialField) && (serialNode = dom4jDocument.selectSingleNode("//" + serialField)) != null) {
                serialNode.setText(serial);
            }
        }
        if (CMyString.isEmpty(sNewTitle = oInfoViewService.getDocumentTitle(_oInfoView, dom4jDocument))) {
            sNewTitle = I18NMessage.get(DocumentService.class, "DocumentService.label117", "\u81ea\u5b9a\u4e49\u8868\u5355\u6570\u636e");
        }
        _document.setTitle(sNewTitle);
        this.m_oDocumentMgr.save(_document);
        return _document;
    }

    private void fillDomData(Element _rootElement, Map _infoViewData, String _sXpath) {
        List childElements = _rootElement.elements();
        if (childElements.size() == 0) {
            if (_sXpath != null) {
                _sXpath = _sXpath + "/" + _rootElement.getName();
                _sXpath = _sXpath.replaceAll("/([^:]*:)?", "_");
            } else {
                _sXpath = _rootElement.getName().replaceAll("([^:]*:)?", "");
            }
            Object oElementData = _infoViewData.get(_sXpath);
            if (oElementData != null) {
                _rootElement.clearContent();
                _rootElement.addCDATA(oElementData.toString());
            }
        } else {
            for (Element oElement : childElements) {
                if (_sXpath != null) {
                    _sXpath = _sXpath + "/" + oElement.getName();
                }
                this.fillDomData(oElement, _infoViewData, _sXpath);
            }
        }
    }

    @Override
    public com.trs.components.wcm.content.persistent.Document saveInfoViewDocument(com.trs.components.wcm.content.persistent.Document _document, Document _contentXmlDoc, Map _hFlowContextInfo) throws WCMException {
        if (_document == null || _contentXmlDoc == null) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label114", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61[null],\u65e0\u6cd5\u4fdd\u5b58!"));
        }
        Channel docChannel = _document.getChannel();
        if (docChannel == null) {
            throw new WCMException(20, I18NMessage.get(DocumentService.class, "DocumentService.label115", "\u6587\u6863\u7684\u6240\u5c5e\u9891\u9053\u4e0d\u5b58\u5728!"));
        }
        if (13 != docChannel.getType()) {
            throw new WCMException(10, I18NMessage.get(DocumentService.class, "DocumentService.label116", "\u8981\u4fdd\u5b58\u7684\u6587\u6863\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u8868\u5355\u6587\u6863!"));
        }
        Document dom4jDocument = _contentXmlDoc;
        IInfoViewService oInfoViewService = ServiceHelper.createInfoViewService();
        boolean bAddMode = _document.isAddMode();
        if (!bAddMode) {
            dom4jDocument = this.recoverWithOldDoc(dom4jDocument, oInfoViewService.getDOM4JDocument(_document.getContent()));
        }
        List fileNodes = dom4jDocument.selectNodes("//@trs_is_inline_file");
        List fileAppendixes = this.processAppendix(fileNodes, 10);
        List picNodes = dom4jDocument.selectNodes("//@trs_is_inline_image");
        List picAppendixes = this.processAppendix(picNodes, 20);
        List linkNodes = dom4jDocument.selectNodes("//@trs_is_linked_image");
        List linkAppendixes = this.processAppendix(linkNodes, 40);
        ArrayList result = new ArrayList();
        result.addAll(fileAppendixes);
        result.addAll(picAppendixes);
        result.addAll(linkAppendixes);
        HashMap oNeedNotDeleteApds = new HashMap();
        if (_document.getProperties() != null) {
            _document.getProperties().remove(this.getInfoViewDataHelper().getKEY_DOM4J());
        }
        if (_document.getNewProperties() != null) {
            _document.getNewProperties().remove(this.getInfoViewDataHelper().getKEY_DOM4J());
        }
        _document.setContent(dom4jDocument.asXML());
        _document = this.synInfoViewFieldValue(_document);
        this.save(_document, null, null, _hFlowContextInfo, false);
        Appendixes tempApds = this.getAppendixes(_document);
        System.out.println();
        Appendix anOldAppendix2 = null;
        HashMap<String, Appendix> hRawAppendixes = new HashMap<String, Appendix>();
        if (tempApds != null && tempApds.size() > 0) {
            for (int i = 0; i < tempApds.size(); ++i) {
                anOldAppendix2 = (Appendix)tempApds.getAt(i);
                if (anOldAppendix2 == null) continue;
                hRawAppendixes.put(anOldAppendix2.getFile(), anOldAppendix2);
            }
        }
        User loginUser = this.getLoginUser();
        int docId = _document.getId();
        Appendix appendix = null;
        for (int i = 0; i < result.size(); ++i) {
            appendix = (Appendix)result.get(i);
            String sApdSrc = appendix.getFile();
            anOldAppendix2 = (Appendix)hRawAppendixes.get(sApdSrc);
            if (anOldAppendix2 != null) {
                appendix = anOldAppendix2;
                appendix.canEdit(loginUser);
                hRawAppendixes.remove(sApdSrc);
            } else {
                appendix.setDocId(docId);
            }
            appendix.setUsedByVersion(_document.getVersion(), true);
            appendix.setSerialNo(i);
            appendix.save(loginUser);
        }
        Collection values = hRawAppendixes.values();
        for (Appendix anOldAppendix2 : values) {
            if (oNeedNotDeleteApds.containsKey(anOldAppendix2.getFile())) continue;
            anOldAppendix2.delete(loginUser);
        }
        result.clear();
        if (bAddMode) {
            try {
                WCMProcessServiceHelper.startDocumentInFlow(this.getLoginUser(), _document, _hFlowContextInfo);
            }
            catch (Throwable ex) {
                ServiceInvocationException exp = new ServiceInvocationException(I18NMessage.get(DocumentService.class, "DocumentService.label120", "\u6587\u6863[") + _document.getTitle() + "-" + _document.getId() + I18NMessage.get(DocumentService.class, "DocumentService.label121", "]\u5df2\u7ecf\u4fdd\u5b58\u6210\u529f\uff0c\u4f46\u56e0\u60a8\u7684\u5de5\u4f5c\u6d41\u8bbe\u7f6e\u6709\u8bef\uff0c\u5c06\u5176\u6295\u5165\u6d41\u8f6c\u5931\u8d25\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u5de5\u4f5c\u6d41\uff0c\u4fee\u6b63\u540e\u5c06\u6587\u6863\u91cd\u65b0\u6295\u5165\u6d41\u8f6c\uff01"), ex);
                exp.setErrorCode("17080");
                throw exp;
            }
        }
        return _document;
    }

    private Document recoverWithOldDoc(Document dom4jDocument, Document document) {
        Element eleR1 = document.getRootElement();
        Element eleR2 = dom4jDocument.getRootElement();
        this.asynNode(eleR1, eleR2);
        return dom4jDocument;
    }

    private void asynNode(Element e1, Element e2) {
        List childNodes = e1.elements();
        if (childNodes.size() == 0) {
            return;
        }
        for (Element child1 : childNodes) {
            String name = child1.getName();
            Element child2 = e2.element(name);
            if (child2 != null) {
                this.asynNode(child1, child2);
                continue;
            }
            e2.add(child1.createCopy());
        }
    }

    private void recoverUnReadFields(Document dom4jDocument, com.trs.components.wcm.content.persistent.Document _document, Map oMayBeAppendix) throws WCMException {
        List linkUnReadableNodes = dom4jDocument.selectNodes("//@trs_unreadable_field");
        for (Node node : linkUnReadableNodes) {
            Element element = node.getParent();
            this.renderWithOldValue(element, _document, oMayBeAppendix);
        }
    }

    private void renderWithOldValue(Element element, com.trs.components.wcm.content.persistent.Document _document, Map oMayBeAppendix) throws WCMException {
        block2: {
            List childNodes;
            block1: {
                childNodes = element.elements();
                if (childNodes.size() != 0) break block1;
                String sName = element.getName();
                if (sName == null) break block2;
                String sLastValue = this.getInfoViewDataHelper().getFieldValue(_document, sName);
                element.clearContent();
                element.addCDATA(sLastValue);
                if (oMayBeAppendix == null || sLastValue == null || !sLastValue.startsWith("W0") && !sLastValue.startsWith("P0")) break block2;
                oMayBeAppendix.put(sLastValue, "");
                break block2;
            }
            for (Element childElement : childNodes) {
                this.renderWithOldValue(childElement, _document, oMayBeAppendix);
            }
        }
    }

    public List processAppendix(List nodes, int nFlag) throws WCMException {
        ArrayList<Appendix> appendixes = new ArrayList<Appendix>(nodes.size());
        Node tempNode = null;
        String srcfile = null;
        String sRelatedColumn = null;
        Appendix appendix = null;
        Element parent = null;
        String pathFlag = nFlag == 20 ? "W0" : "P0";
        String sFileDesc = null;
        for (int i = 0; i < nodes.size(); ++i) {
            tempNode = (Node)nodes.get(i);
            parent = tempNode.getParent();
            srcfile = parent.getTextTrim();
            sRelatedColumn = parent.getName();
            sFileDesc = parent.attributeValue("FileName");
            tempNode.detach();
            appendix = new Appendix();
            appendix.setFlag(nFlag);
            appendix.setSrcFile(srcfile);
            String appendixFile = srcfile;
            if (nFlag != 40) {
                appendixFile = this.processAppendixFile(srcfile, pathFlag);
                parent.setText(appendixFile);
            }
            appendix.setFile(appendixFile);
            appendix.setFileExt(CMyFile.extractFileExt(srcfile));
            appendix.setDesc(CMyString.showNull(sFileDesc, srcfile));
            appendix.setRelatedColumn(sRelatedColumn);
            appendixes.add(appendix);
        }
        return appendixes;
    }

    private String processAppendixFile(String srcFile, String pathFlag) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (FilesMan.isValidFile(srcFile, pathFlag)) {
            return srcFile;
        }
        return filesMan.copyWCMFile(srcFile, pathFlag);
    }

    private InfoViewDataHelper getInfoViewDataHelper() throws WCMException {
        InfoViewDataHelper helper = (InfoViewDataHelper)DiscoveryFactoryBuddy.getImplementor(InfoViewDataHelper.class);
        if (helper == null) {
            throw new WCMException(I18NMessage.get(DocumentService.class, "DocumentService.label119", "\u6ca1\u6709\u5b89\u88c5\u8868\u5355\u9009\u4ef6\uff01\u8bf7\u6b63\u786e\u5b89\u88c5\u540e\u518d\u4f7f\u7528\u8be5\u9009\u9879\u529f\u80fd\uff01"));
        }
        return helper;
    }

    private boolean validateRight(User _user, CMSObj _obj, int _nRightIndex) throws WCMException {
        return AuthServer.hasRight(_user, _obj, _nRightIndex);
    }

    private com.trs.components.wcm.content.persistent.Document synInfoViewFieldValue(com.trs.components.wcm.content.persistent.Document _document) throws WCMException {
        int nInfoViewId = _document.getFlag();
        List listCreator = InfoViewFieldValueCreatorFactory.createValueCreator(nInfoViewId);
        if (listCreator == null) {
            return _document;
        }
        int length = listCreator.size();
        for (int i = 0; i < length; ++i) {
            BaseInfoViewFieldValueCreator creator = (BaseInfoViewFieldValueCreator)listCreator.get(0);
            creator.setDocument(_document);
            creator.createInfoviewXMLDataUpdator();
            creator.setInfoViewFieldValueBeforeSaveDoc();
            creator.updateDocument();
            _document = creator.getDocument();
        }
        return _document;
    }
}

