/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.MySSLSocketFactory;
import com.trs.infra.util.ResponseBuddy;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.Logger;

public class HttpClientBuddy {
    public static final String DEFAULT_CONTENT_ENCODING = "utf-8";
    public static final String SERVICE_REQEUST_ENCODING = "ISO-8859-1";
    protected static Logger logger = Logger.getLogger(HttpClientBuddy.class);
    private HttpClient m_oHttpClient = null;
    private String m_sEncoding = "";
    private String[][] m_arrRequestHeaders = null;
    public static int TIME_OUT = 3000;

    public HttpClientBuddy() {
        this(DEFAULT_CONTENT_ENCODING);
    }

    public HttpClientBuddy(String encoding) {
        this.m_sEncoding = encoding;
        this.m_oHttpClient = new HttpClient();
        this.m_oHttpClient.getHttpConnectionManager().getParams().setConnectionTimeout(TIME_OUT);
        this.m_oHttpClient.getHttpConnectionManager().getParams().setSoTimeout(TIME_OUT);
    }

    public HttpClientBuddy(String encoding, String[][] _arrRequestHeaders) {
        this.m_sEncoding = encoding;
        this.m_oHttpClient = new HttpClient();
        this.m_arrRequestHeaders = _arrRequestHeaders;
        this.m_oHttpClient.getHttpConnectionManager().getParams().setConnectionTimeout(TIME_OUT);
        this.m_oHttpClient.getHttpConnectionManager().getParams().setSoTimeout(TIME_OUT);
    }

    public ResponseBuddy doPost(String _sPostUri, String sContent) throws CMyException {
        try {
            return this.doPost(_sPostUri, sContent.getBytes(this.m_sEncoding));
        }
        catch (Exception e) {
            throw new CMyException(I18NMessage.get(HttpClientBuddy.class, "HttpClientBuddy.label1", "\u53d1\u9001\u8bf7\u6c42\u65f6\u51fa\u73b0\u5f02\u5e38"), e);
        }
    }

    public ResponseBuddy updateFile(String _sPostUri, byte[] _fileContent) throws CMyException {
        this.validUrl(_sPostUri);
        PostMethod post = new PostMethod(_sPostUri);
        this.prepare((HttpMethod)post);
        post.setRequestHeader("Content-Type", "multipart/form-data");
        if (_fileContent != null) {
            ByteArrayRequestEntity entity = new ByteArrayRequestEntity(_fileContent);
            post.setContentChunked(true);
            post.setRequestEntity((RequestEntity)entity);
        }
        return this.renderResponse((HttpMethod)post);
    }

    public ResponseBuddy updateFile(String _sPostUri, File _oUpdateFile) throws CMyException {
        this.validUrl(_sPostUri);
        PostMethod filePost = new PostMethod(_sPostUri);
        this.prepare((HttpMethod)filePost);
        filePost.getParams().setBooleanParameter("http.protocol.expect-continue", true);
        try {
            Part[] parts = new Part[]{new FilePart(_oUpdateFile.getName(), _oUpdateFile)};
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            this.m_oHttpClient.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
        }
        catch (Exception e) {
            throw new CMyException(I18NMessage.get(HttpClientBuddy.class, "HttpClientBuddy.label2", "\u4e0a\u4f20\u6587\u4ef6\u65f6\uff0c\u51fa\u73b0\u5f02\u5e38"), e);
        }
        return this.renderResponse((HttpMethod)filePost);
    }

    public ResponseBuddy doPost(String _sPostUri, byte[] _btContent) throws CMyException {
        this.validUrl(_sPostUri);
        PostMethod post = new PostMethod(_sPostUri);
        this.prepare((HttpMethod)post);
        if (_btContent != null) {
            ByteArrayRequestEntity entity = new ByteArrayRequestEntity(_btContent);
            post.setContentChunked(true);
            post.setRequestEntity((RequestEntity)entity);
        }
        return this.renderResponse((HttpMethod)post);
    }

    public ResponseBuddy doPost(String _sPostUri, String sContent, boolean _bChunked) throws CMyException {
        try {
            return this.doPost(_sPostUri, sContent.getBytes(this.m_sEncoding), _bChunked);
        }
        catch (Exception e) {
            throw new CMyException(I18NMessage.get(HttpClientBuddy.class, "HttpClientBuddy.label1", "\u53d1\u9001\u8bf7\u6c42\u65f6\u51fa\u73b0\u5f02\u5e38"), e);
        }
    }

    public ResponseBuddy doPost(String _sPostUri, Map mContent, boolean _bChunked) throws CMyException {
        return this.doPost(_sPostUri, this.getContent(mContent), _bChunked);
    }

    private String getContent(Map mContent) throws CMyException {
        if (mContent == null) {
            return "";
        }
        StringBuffer sbContent = new StringBuffer(mContent.size() * 20);
        try {
            for (Map.Entry entry : mContent.entrySet()) {
                sbContent.append(entry.getKey());
                sbContent.append("=");
                sbContent.append(URLEncoder.encode((String)entry.getValue(), DEFAULT_CONTENT_ENCODING));
                sbContent.append("&");
            }
        }
        catch (Exception e) {
            throw new CMyException(I18NMessage.get(HttpClientBuddy.class, "HttpClientBuddy.label3", "\u6784\u9020\u53d1\u9001\u5185\u5bb9\u65f6\u51fa\u73b0\u5f02\u5e38"), e);
        }
        return sbContent.toString();
    }

    public ResponseBuddy doPost(String _sPostUri, byte[] _btContent, boolean _bChunked) throws CMyException {
        this.validUrl(_sPostUri);
        PostMethod post = new PostMethod(_sPostUri);
        this.prepare((HttpMethod)post);
        if (_btContent != null) {
            ByteArrayRequestEntity entity = new ByteArrayRequestEntity(_btContent);
            post.setContentChunked(_bChunked);
            post.setRequestEntity((RequestEntity)entity);
        }
        return this.renderResponse((HttpMethod)post);
    }

    private void prepare(HttpMethod httpMethod) {
        httpMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + this.m_sEncoding);
        if (this.m_arrRequestHeaders != null) {
            for (int i = 0; i < this.m_arrRequestHeaders.length; ++i) {
                httpMethod.setRequestHeader(this.m_arrRequestHeaders[i][0], this.m_arrRequestHeaders[i][1]);
            }
        }
    }

    private ResponseBuddy renderResponse(HttpMethod httpMethod) throws CMyException {
        String _sMethodUri = null;
        int httpResult = 0;
        try {
            _sMethodUri = httpMethod.getURI().getURI();
            httpResult = this.m_oHttpClient.executeMethod(httpMethod);
            ResponseBuddy responseBuddy = new ResponseBuddy(httpMethod);
            return responseBuddy;
        }
        catch (Exception ex) {
            throw new CMyException(I18NMessage.get(HttpClientBuddy.class, "HttpClientBuddy.label4", "\u5411\u76ee\u6807\u5730\u5740[") + _sMethodUri + I18NMessage.get(HttpClientBuddy.class, "HttpClientBuddy.label5", "]\u63d0\u4ea4\u6570\u636e\u65f6\u5931\u8d25\uff01(response\u7f16\u53f7[") + httpResult + "])", ex);
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    public ResponseBuddy doGet(String _sPostUri, String _sQueryString) throws CMyException {
        this.validUrl(_sPostUri);
        GetMethod get = new GetMethod(_sPostUri);
        this.prepare((HttpMethod)get);
        if (_sQueryString != null) {
            get.setQueryString(_sQueryString);
        }
        return this.renderResponse((HttpMethod)get);
    }

    public ResponseBuddy doGet(String _sPostUri, Map mContent) throws CMyException {
        return this.doGet(_sPostUri, this.getContent(mContent));
    }

    private void validUrl(String _sPostUri) throws CMyException {
        URL oUrl = null;
        try {
            oUrl = new URL(_sPostUri);
        }
        catch (MalformedURLException ex) {
            throw new CMyException(I18NMessage.get(HttpClientBuddy.class, "HttpClientBuddy.label6", "\u4e0d\u662f\u5408\u6cd5\u7684HTTP\u8bf7\u6c42\u7684\u76ee\u6807\u5730\u5740[") + _sPostUri + "]", ex);
        }
        if (oUrl.getProtocol().equalsIgnoreCase("https")) {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new MySSLSocketFactory(), 443));
        }
    }
}

