/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.persistent.ContentLink;
import com.trs.components.wcm.content.persistent.ContentLinks;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;

public class ContentLinkMgr {
    private static Logger m_oLogger = Logger.getLogger(ChannelMgr.class);

    public ContentLinks getContentLinks(WebSite _currSite, WCMFilter _filter) throws WCMException {
        if (_currSite == null) {
            throw new WCMException(10, I18NMessage.get(ContentLinkMgr.class, "ContentLinkMgr.label1", "\u65e0\u6548\u7684\u7ad9\u70b9\u5bf9\u8c61!"));
        }
        WCMFilter aFilter = new WCMFilter("", "SiteId=" + _currSite.getId(), "ContentLinkId desc");
        aFilter.mergeWith(_filter);
        try {
            return ContentLinks.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        }
        catch (WCMException ex) {
            m_oLogger.debug((Object)ex.getStackTraceText());
            throw new WCMException(1100, I18NMessage.get(ContentLinkMgr.class, "ContentLinkMgr.label2", "\u83b7\u53d6\u7ad9\u70b9\u7684\u6240\u6709\u5185\u5bb9\u8d85\u94fe\u63a5\u5931\u8d25!"), ex);
        }
    }

    public ContentLink save(ContentLink _contentLink) throws WCMException {
        if (_contentLink == null) {
            throw new WCMException(10, I18NMessage.get(ContentLinkMgr.class, "ContentLinkMgr.label3", "\u65e0\u6548\u7684\u5bf9\u8c61,\u65e0\u6cd5\u4fdd\u5b58!"));
        }
        _contentLink.save();
        return _contentLink;
    }

    public ContentLinks getContentLinks(int _nSiteId, WCMFilter _filter) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "SiteId=" + _nSiteId, "");
        aFilter.mergeWith(_filter);
        return ContentLinks.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public void delete(ContentLink _contentLink) throws WCMException {
        if (_contentLink == null) {
            throw new WCMException(10, I18NMessage.get(ContentLinkMgr.class, "ContentLinkMgr.label4", "\u65e0\u6548\u7684\u5185\u5bb9\u8d85\u94fe\u63a5\u5bf9\u8c61,\u65e0\u6cd5\u5220\u9664!"));
        }
        _contentLink.delete();
    }

    public void delete(ContentLinks _contentLinks) throws WCMException {
        if (_contentLinks == null || _contentLinks.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(ContentLinkMgr.class, "ContentLinkMgr.label5", "\u65e0\u6548\u7684\u96c6\u5408\u5bf9\u8c61,\u65e0\u6cd5\u5220\u9664!"));
        }
        _contentLinks.removeAll();
    }

    public void deleteContentLinks(WebSite _site) throws WCMException {
        this.getContentLinks(_site, null).removeAll();
    }
}

