/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.components.stat.BaseStatHandler;
import com.trs.components.stat.DocStatHandler4UserDept;
import com.trs.infra.common.WCMException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class HitsStatHandler4UserDept
extends BaseStatHandler {
    private static Logger logger = Logger.getLogger(DocStatHandler4UserDept.class);
    private HashMap m_hRelGroupsOfUser = new HashMap();
    private int[] filterDocIds = null;
    private boolean bFilterByDocument = false;

    public HitsStatHandler4UserDept() {
    }

    public HitsStatHandler4UserDept(int[] _filterDocIds) {
        this.filterDocIds = _filterDocIds;
        this.bFilterByDocument = true;
    }

    @Override
    public void visitStatItem(ResultSet resultSet, int nSQLIndex) throws WCMException {
        try {
            int nCurrHitsCount = resultSet.getInt(1);
            if (nCurrHitsCount == 0) {
                return;
            }
            int nDocumentId = resultSet.getInt(2);
            if (this.bFilterByDocument) {
                if (this.filterDocIds == null) {
                    return;
                }
                boolean bContains = false;
                for (int k = 0; k < this.filterDocIds.length; ++k) {
                    if (nDocumentId != this.filterDocIds[k]) continue;
                    bContains = true;
                    break;
                }
                if (!bContains) {
                    return;
                }
            }
            String sUserName = resultSet.getString(3);
            Groups oRelGroups = this.makeCurrRelGroups(sUserName);
            int nSize = oRelGroups.size();
            for (int nRelGroupIndex = 0; nRelGroupIndex < nSize; ++nRelGroupIndex) {
                Group oRelGroup = (Group)oRelGroups.getAt(nRelGroupIndex);
                if (oRelGroup == null) continue;
                String oGroupKey = oRelGroup.getId() + "";
                int nHitsCount = this.getValue(nSQLIndex, oGroupKey);
                this.setValue(nSQLIndex, oGroupKey, nHitsCount += nCurrHitsCount);
                this.addMajorObject(oGroupKey);
            }
        }
        catch (SQLException e) {
            logger.debug((Object)"\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new WCMException("\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    private Groups makeCurrRelGroups(String _sLowerCaseUserName) throws WCMException {
        Groups oCurrRelGroups = (Groups)this.m_hRelGroupsOfUser.get(_sLowerCaseUserName);
        if (oCurrRelGroups != null) {
            return oCurrRelGroups;
        }
        oCurrRelGroups = new Groups(null);
        User oCurrUser = User.findByName(_sLowerCaseUserName);
        if (oCurrUser == null) {
            return oCurrRelGroups;
        }
        Groups groups = oCurrUser.getGroups();
        int nSize = groups.size();
        for (int i = 0; i < nSize; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            for (Group parent = group; parent != null; parent = parent.getParent()) {
                oCurrRelGroups.addElement(parent);
            }
        }
        this.m_hRelGroupsOfUser.put(oCurrUser.getKey(), oCurrRelGroups);
        return oCurrRelGroups;
    }
}

