/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.components.stat.ChnlDept;
import com.trs.components.stat.IChnlDeptMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ChnlDeptMgr
implements IChnlDeptMgr {
    private Logger logger = Logger.getLogger(ChnlDeptMgr.class);
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");
    private final String KEY_CHNLDEPT_CACHE_BY_GROUP = "ChnlDeptCacheByGroup";
    private final String KEY_CHNLDEPT_CACHE_BY_CHNL = "m_hChnlDeptCacheByChnl";

    @Override
    public List getChnlIdsByDep(Group _group) throws WCMException {
        if (_group == null) {
            return null;
        }
        this.insureCacheLoaded();
        List oValue = (List)cache.get(this.getKeyCacheByGroup(_group));
        if (oValue == null || oValue.size() == 0) {
            return null;
        }
        ArrayList arrChnlIds = new ArrayList();
        int nSize = oValue.size();
        for (int i = 0; i < nSize; ++i) {
            String sValue = (String)oValue.get(i);
            if (sValue == null) continue;
            String[] arr = sValue.split(",");
            int nChannelId = Integer.parseInt(arr[0]);
            this.addToListIfNeed(nChannelId, arrChnlIds);
            if (Integer.parseInt(arr[1]) != 1) continue;
            this.dealWithChildrenChnl(Channel.findById(nChannelId), arrChnlIds);
        }
        return arrChnlIds;
    }

    private void addToListIfNeed(int _nId, List _arrChnlIds) {
        Integer nId = new Integer(_nId);
        if (!_arrChnlIds.contains(nId)) {
            _arrChnlIds.add(nId);
        }
    }

    @Override
    public String getChnlIdsByDepts(Groups groups) throws WCMException {
        if (groups == null || groups.isEmpty()) {
            return null;
        }
        String sResult = "";
        int nSize = groups.size();
        for (int i = 0; i < nSize; ++i) {
            List channelIdsOfGroup;
            Group group = (Group)groups.getAt(i);
            if (group == null || (channelIdsOfGroup = this.getChnlIdsByDep(group)) == null || channelIdsOfGroup.size() == 0) continue;
            sResult = this.addToString(sResult, channelIdsOfGroup);
        }
        return sResult;
    }

    private String addToString(String _sResult, List _list) {
        if (_list.size() == 0) {
            return _sResult;
        }
        int nSize = _list.size();
        for (int i = 0; i < nSize; ++i) {
            String id = _list.get(i).toString();
            if (CMyString.isEmpty(id) || ("," + _sResult + ",").indexOf("," + id + ",") != -1) continue;
            _sResult = CMyString.isEmpty(_sResult) ? _sResult.concat(id) : _sResult.concat("," + id);
        }
        return _sResult;
    }

    private void dealWithChildrenChnl(Channel _currChannel, List _chnlIds) {
        if (_currChannel == null) {
            return;
        }
        List<Channel> channelList = null;
        try {
            channelList = _currChannel.getAllChildren(User.getSystem());
        }
        catch (WCMException e) {
            this.logger.error((Object)"\u83b7\u53d6\u680f\u76ee\u7684\u5b50\u680f\u76ee\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            return;
        }
        if (channelList == null) {
            return;
        }
        int nSize = channelList.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = channelList.get(i);
            if (channel == null) continue;
            int nId = channel.getId();
            this.addToListIfNeed(nId, _chnlIds);
            this.dealWithChildrenChnl(channel, _chnlIds);
        }
    }

    @Override
    public List getDepIdsByChannel(Channel _channel) throws WCMException {
        if (_channel == null) {
            return null;
        }
        this.insureCacheLoaded();
        List oValue = (List)cache.get(this.getKeyCacheByChnl(_channel));
        ArrayList arrGroupIds = new ArrayList();
        if (oValue != null) {
            int nSize = oValue.size();
            for (int i = 0; i < nSize; ++i) {
                String sValue = (String)oValue.get(i);
                if (sValue == null) continue;
                String[] arr = sValue.split(",");
                int nChannelId = Integer.parseInt(arr[0]);
                this.addToListIfNeed(nChannelId, arrGroupIds);
            }
        }
        try {
            for (Channel parent = _channel.getParent(); parent != null; parent = parent.getParent()) {
                this.addGroupIdsIfParentNeed(parent, arrGroupIds);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"\u83b7\u53d6\u680f\u76ee\u7684\u7236\u680f\u76ee\u5bf9\u5e94\u7684\u7ec4\u7ec7\u65f6\uff0c\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return arrGroupIds;
    }

    private void addGroupIdsIfParentNeed(Channel _oChannel, List _groupIds) {
        try {
            this.insureCacheLoaded();
            List oValue = (List)cache.get(this.getKeyCacheByChnl(_oChannel));
            if (oValue == null) {
                return;
            }
            int nSize = oValue.size();
            for (int i = 0; i < nSize; ++i) {
                String[] arr;
                String sValue = (String)oValue.get(i);
                if (sValue == null || Integer.parseInt((arr = sValue.split(","))[1]) == 0) continue;
                int nGroupId = Integer.parseInt(arr[0]);
                this.addToListIfNeed(nGroupId, _groupIds);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("\u83b7\u53d6\u680f\u76ee\u3010Id=" + _oChannel.getId() + "\u3011\u7684\u76f8\u5173\u8054\u7684\u7ec4\u7ec7\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38"), (Throwable)e);
        }
    }

    @Override
    public String getDepNamesByChannel(Channel _channel, User _user) throws WCMException {
        String sGroupStatByChannel = ConfigServer.getServer().getSysConfigValue("GROUP_STAT_BY_CHANNEL", "false");
        List groupIds = new ArrayList();
        String sGroupNames = "\u65e0";
        if (sGroupStatByChannel.equalsIgnoreCase("false")) {
            sGroupNames = this.getGroupsByUser(_user);
            return sGroupNames;
        }
        groupIds = this.getDepIdsByChannel(_channel);
        Group group = null;
        int nGroupId = 0;
        if (groupIds.size() > 0) {
            sGroupNames = "";
            int nSize = groupIds.size();
            for (int i = 0; i < nSize; ++i) {
                nGroupId = Integer.parseInt(groupIds.get(i).toString());
                group = Group.findById(nGroupId);
                if (group == null) continue;
                sGroupNames = i != nSize - 1 ? sGroupNames + group.getName() + " , " : sGroupNames + group.getName();
            }
        }
        return CMyString.isEmpty(sGroupNames) ? "\u65e0" : sGroupNames;
    }

    private String getGroupsByUser(User user) {
        if (user == null) {
            return null;
        }
        Groups groups = null;
        try {
            groups = user.getGroups();
        }
        catch (WCMException e) {
            this.logger.error((Object)"\u6839\u636e\u7528\u6237\u83b7\u53d6\u7ec4\u7ec7\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
        String sGroupName = "\u65e0";
        Group temp = null;
        if (groups.size() > 0) {
            sGroupName = "";
            int nsize = groups.size();
            for (int j = 0; j < nsize; ++j) {
                temp = (Group)groups.getAt(j);
                if (temp == null) continue;
                sGroupName = j != nsize - 1 ? sGroupName + temp.getName() + " , " : sGroupName + temp.getName();
            }
        }
        return CMyString.isEmpty(sGroupName) ? "\u65e0" : sGroupName;
    }

    @Override
    public void clear() {
    }

    private void insureCacheLoaded() throws WCMException {
        if (!cache.exists(this.getKeyCacheByGroup()).booleanValue()) {
            this.doStart();
        }
    }

    @Override
    public boolean init() throws WCMException {
        return this.doStart();
    }

    @Override
    public boolean reinit() throws WCMException {
        return this.doStart();
    }

    private synchronized boolean doStart() throws WCMException {
        if (cache.exists(this.getKeyCacheByGroup()).booleanValue() && cache.exists(this.getKeyCacheByChnl()).booleanValue()) {
            return true;
        }
        cache.set(this.getKeyCacheByChnl(), "true");
        cache.set(this.getKeyCacheByGroup(), "true");
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        DBManager dbMgr = DBManager.getDBManager();
        String strSQL = "select ChannelId, GroupId, ContainsChildrenChnl from XWCMCHNLDEPT";
        try {
            int nGroupId;
            oConn = dbMgr.getConnection();
            oStmt = oConn.prepareStatement(strSQL);
            oStmt.setFetchSize(1000);
            rsData = oStmt.executeQuery();
            while (rsData.next()) {
                nGroupId = rsData.getInt("GroupId");
                int nChannelId = rsData.getInt("ChannelId");
                int nContainsChildrenChnl = rsData.getInt("ContainsChildrenChnl");
                Group currGroup = Group.findById(nGroupId);
                Channel currChannel = Channel.findById(nChannelId);
                if (currGroup == null || currChannel == null) continue;
                List<String> arValueByGroup = new ArrayList<String>();
                if (cache.exists(this.getKeyCacheByGroup(currGroup)).booleanValue()) {
                    arValueByGroup = (List)cache.get(this.getKeyCacheByGroup(currGroup));
                    arValueByGroup.add(this.makeValue(nChannelId, nContainsChildrenChnl));
                } else {
                    arValueByGroup.add(this.makeValue(nChannelId, nContainsChildrenChnl));
                }
                cache.set(this.getKeyCacheByGroup(currGroup), arValueByGroup);
                List<String> arValueByChnl = new ArrayList<String>();
                if (cache.exists(this.getKeyCacheByChnl(currChannel)).booleanValue()) {
                    arValueByChnl = (List)cache.get(this.getKeyCacheByChnl(currChannel));
                    arValueByChnl.add(this.makeValue(nGroupId, nContainsChildrenChnl));
                } else {
                    arValueByChnl.add(this.makeValue(nGroupId, nContainsChildrenChnl));
                }
                cache.set(this.getKeyCacheByChnl(currChannel), arValueByChnl);
            }
            this.logger.info((Object)"\u521d\u59cb\u5316\u680f\u76ee\u7ec4\u7ec7\u5173\u7cfb\u7f13\u51b2\u5b8c\u6210...");
            nGroupId = 1;
            return nGroupId != 0;
        }
        catch (SQLException ex) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + strSQL, ex);
        }
        finally {
            if (oConn != null) {
                dbMgr.freeConnection(oConn);
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        this.insureCacheLoaded();
        if (_oObjAdded instanceof ChnlDept) {
            this.putToCache((ChnlDept)_oObjAdded);
        }
    }

    private void putToCache(ChnlDept _oChnlDept) throws WCMException {
        int nGroupId = _oChnlDept.getGroupId();
        int nChannelId = _oChnlDept.getChannelId();
        Group group = Group.findById(nGroupId);
        Channel channel = Channel.findById(nChannelId);
        if (group == null || channel == null) {
            return;
        }
        List<String> oValueByGroup = new ArrayList<String>();
        if (cache.exists(this.getKeyCacheByGroup(group)).booleanValue()) {
            oValueByGroup = (List)cache.get(this.getKeyCacheByGroup(group));
            oValueByGroup.add(this.makeValueOfGroup(_oChnlDept));
        } else {
            oValueByGroup.add(this.makeValueOfGroup(_oChnlDept));
        }
        cache.set(this.getKeyCacheByGroup(group), oValueByGroup);
        List<String> oValueByChannel = new ArrayList<String>();
        if (cache.exists(this.getKeyCacheByChnl(channel)).booleanValue()) {
            oValueByChannel = (List)cache.get(this.getKeyCacheByChnl(channel));
            oValueByChannel.add(this.makeValueOfChannel(_oChnlDept));
        } else {
            oValueByChannel.add(this.makeValueOfChannel(_oChnlDept));
        }
        cache.set(this.getKeyCacheByChnl(channel), oValueByChannel);
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int eventType) throws WCMException {
        this.insureCacheLoaded();
        if (_oObjDeleted instanceof ChnlDept) {
            this.removeFromCache((ChnlDept)_oObjDeleted);
        }
    }

    private void removeFromCache(ChnlDept _oChnlDept) throws WCMException {
        String sValueOfChannel;
        List oValueByChannel;
        String sValueOfGroup;
        int nGroupId = _oChnlDept.getGroupId();
        int nChannelId = _oChnlDept.getChannelId();
        Group group = Group.findById(nGroupId);
        Channel channel = Channel.findById(nChannelId);
        if (group == null || channel == null) {
            return;
        }
        List oValueByGroup = (List)cache.get(this.getKeyCacheByGroup(group));
        if (oValueByGroup.contains(sValueOfGroup = this.makeValueOfGroup(_oChnlDept))) {
            oValueByGroup.remove(sValueOfGroup);
            cache.clear(this.getKeyCacheByGroup(group));
            if (oValueByGroup.size() > 0) {
                cache.set(this.getKeyCacheByGroup(group), oValueByGroup);
            }
        }
        if ((oValueByChannel = (List)cache.get(this.getKeyCacheByChnl(channel))).contains(sValueOfChannel = this.makeValueOfChannel(_oChnlDept))) {
            oValueByChannel.remove(sValueOfChannel);
            cache.clear(this.getKeyCacheByChnl(channel));
            if (oValueByChannel.size() > 0) {
                cache.set(this.getKeyCacheByChnl(channel), oValueByChannel);
            }
        }
    }

    private String makeValueOfGroup(ChnlDept _oChnlDept) {
        return _oChnlDept.getChannelId() + "," + _oChnlDept.getPropertyAsInt("ContainsChildrenChnl", 0);
    }

    private String makeValueOfChannel(ChnlDept _oChnlDept) {
        return _oChnlDept.getGroupId() + "," + _oChnlDept.getPropertyAsInt("ContainsChildrenChnl", 0);
    }

    private String makeValue(int _nId, int _nContainsChildrenChnl) {
        return _nId + "," + _nContainsChildrenChnl;
    }

    private String getKeyCacheByGroup(Group group) {
        return ChnlDeptMgr.class.getName() + "." + "ChnlDeptCacheByGroup" + "." + group.getId();
    }

    private String getKeyCacheByChnl(Channel channel) {
        return ChnlDeptMgr.class.getName() + "." + "m_hChnlDeptCacheByChnl" + "." + channel.getId();
    }

    private String getKeyCacheByGroup() {
        return ChnlDeptMgr.class.getName() + "." + "ChnlDeptCacheByGroup";
    }

    private String getKeyCacheByChnl() {
        return ChnlDeptMgr.class.getName() + "." + "m_hChnlDeptCacheByChnl";
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int eventType) throws WCMException {
        this.insureCacheLoaded();
        if (!(_oObjModified instanceof ChnlDept)) {
            return;
        }
        ChnlDept chnlDept = (ChnlDept)_oObjModified;
        int nNewGroupId = chnlDept.getNewPropertyAsInt("GroupId", 0);
        int nGroupId = chnlDept.getGroupId();
        int nNewChannelId = chnlDept.getNewPropertyAsInt("ChannelId", 0);
        int nChannelId = chnlDept.getChannelId();
        int nNewContainsChildren = chnlDept.getNewPropertyAsInt("ContainsChildrenChnl", -1);
        int nContainsChildren = chnlDept.getPropertyAsInt("ContainsChildrenChnl", 0);
        this.removeFromCache(chnlDept);
        List<String> oValueByGroup = (ArrayList<String>)cache.get(this.getKeyCacheByGroup(Group.findById(nGroupId)));
        List<String> oValueByChannel = (ArrayList<String>)cache.get(this.getKeyCacheByChnl(Channel.findById(nChannelId)));
        int channelId = nNewChannelId == 0 ? nChannelId : nNewChannelId;
        int groupId = nNewGroupId == 0 ? nGroupId : nNewGroupId;
        int containsChildren = nNewContainsChildren == -1 ? nContainsChildren : nNewContainsChildren;
        String sNewValueOfGroup = this.makeValue(channelId, containsChildren);
        String sNewValueOfChannel = this.makeValue(groupId, containsChildren);
        if (nNewGroupId == 0) {
            if (oValueByGroup == null) {
                oValueByGroup = new ArrayList<String>();
            }
            oValueByGroup.add(sNewValueOfGroup);
            cache.set(this.getKeyCacheByGroup(Group.findById(nGroupId)), oValueByGroup);
        } else {
            Group newGroup = Group.findById(nNewGroupId);
            oValueByGroup = (List)cache.get(this.getKeyCacheByGroup(newGroup));
            if (oValueByGroup == null) {
                oValueByGroup = new ArrayList();
            }
            oValueByGroup.add(sNewValueOfGroup);
            cache.clear(this.getKeyCacheByGroup(newGroup));
            cache.set(this.getKeyCacheByGroup(newGroup), oValueByGroup);
        }
        if (nNewChannelId != 0) {
            Channel newChannel = Channel.findById(nNewChannelId);
            oValueByChannel = (List)cache.get(this.getKeyCacheByChnl(newChannel));
            if (oValueByChannel == null) {
                oValueByChannel = new ArrayList<String>();
            }
            oValueByChannel.add(sNewValueOfChannel);
            cache.clear(this.getKeyCacheByChnl(newChannel));
            cache.set(this.getKeyCacheByChnl(newChannel), oValueByChannel);
        } else {
            Channel channel = Channel.findById(nChannelId);
            oValueByChannel = (List)cache.get(this.getKeyCacheByChnl(channel));
            if (oValueByChannel == null) {
                oValueByChannel = new ArrayList();
            }
            oValueByChannel.add(sNewValueOfChannel);
            cache.set(this.getKeyCacheByChnl(channel), oValueByChannel);
        }
    }
}

