/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.message.notify.NotificationServer;
import com.trs.components.common.message.notify.Notifier;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyException;
import org.apache.log4j.Logger;

public class TemplateParseAngel
extends Thread {
    private static final Logger logger = Logger.getLogger((String)TemplateParseAngel.class.getName());
    private Object m_host;

    private TemplateParseAngel(Object _host) {
        this.m_host = _host;
    }

    public static void scanAll() {
        TemplateParseAngel angel = new TemplateParseAngel((Object)null);
        angel.start();
    }

    public static void scanIn(IPublishFolder _folder) {
        TemplateParseAngel angel = new TemplateParseAngel(_folder);
        angel.start();
    }

    public static void scan(Template _template) {
        if (_template == null || _template.isParsed()) {
            return;
        }
        TemplateParseAngel angel = new TemplateParseAngel(_template);
        angel.start();
    }

    @Override
    public void run() {
        ContextHelper.initContext(User.getSystem());
        if (this.m_host == null) {
            this.parseAllUnparsedTemplates();
        } else if (this.m_host instanceof Template) {
            this.parseTemplate((Template)this.m_host, null);
        } else {
            this.parseUnparsedTemplatesIn((IPublishFolder)this.m_host);
        }
    }

    private void parseAllUnparsedTemplates() {
        BaseObjs templates = null;
        try {
            WCMFilter filter = new WCMFilter("", "ISPARSED=0", "");
            templates = new Templates(ContextHelper.getLoginUser());
            templates.open(filter);
            if (templates != null && !templates.isEmpty()) {
                this.parseTemplates((Templates)templates);
            }
        }
        catch (Exception ex) {
            logger.error((Object)I18NMessage.get(TemplateParseAngel.class, "TemplateParseAngel.label1", "\u89e3\u6790\u5c1a\u672a\u89e3\u6790\u7684\u6a21\u677f\u53d1\u751f\u5f02\u5e38\uff01"), (Throwable)ex);
        }
        finally {
            if (templates != null) {
                templates.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseUnparsedTemplatesIn(IPublishFolder _root) {
        BaseObjs templates = null;
        try {
            TemplateMgr mgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
            WCMFilter filter = new WCMFilter("", "ISPARSED=0", "");
            templates = mgr.getManagedTemplates(_root, -1, filter, true);
            if (templates != null && !templates.isEmpty()) {
                this.parseTemplates((Templates)templates);
            }
        }
        catch (Exception ex) {
            logger.error((Object)(I18NMessage.get(TemplateParseAngel.class, "TemplateParseAngel.label2", "\u89e3\u6790") + _root.getInfo() + I18NMessage.get(TemplateParseAngel.class, "TemplateParseAngel.label3", "\u5c1a\u672a\u89e3\u6790\u7684\u6a21\u677f\u53d1\u751f\u5f02\u5e38\uff01")), (Throwable)ex);
        }
        finally {
            if (templates != null) {
                templates.clear();
            }
        }
    }

    private void parseTemplates(Templates _templates) {
        TemplateParseMgr parseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
        int nSize = _templates.size();
        for (int i = 0; i < nSize; ++i) {
            Template aTemplate = (Template)_templates.getAt(i);
            if (aTemplate == null) continue;
            this.parseTemplate(aTemplate, parseMgr);
        }
    }

    private void parseTemplate(Template _template, TemplateParseMgr _parseMgr) {
        try {
            if (_template.isParsed()) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("to parse " + _template.getInfo()));
            }
            if (_parseMgr == null) {
                _parseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            }
            _parseMgr.parse(_template);
        }
        catch (Exception ex) {
            logger.error((Object)(I18NMessage.get(TemplateParseAngel.class, "TemplateParseAngel.label2", "\u89e3\u6790") + _template.getInfo() + I18NMessage.get(TemplateParseAngel.class, "TemplateParseAngel.label4", "\u53d1\u751f\u5f02\u5e38\uff01")), (Throwable)ex);
            String sMessage = CMyException.getStackTraceText(ex);
            this.notifyWhenFailed(_template, sMessage);
        }
    }

    private void notifyWhenFailed(Template _template, String _sMessage) {
        String EVENT = "Publish.WhenTempateParseAngelFailed";
        try {
            if (NotificationServer.getInstance().needNotifyForEvent("Publish.WhenTempateParseAngelFailed")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"to send notification on event Publish.WhenTempateParseAngelFailed");
                }
                Notifier notifier = new Notifier();
                notifier.setParameter("TemplateInfo", _template.getInfo());
                notifier.setParameter("Message", _sMessage);
                notifier.executeOnEvent("Publish.WhenTempateParseAngelFailed");
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to notify when parsing " + _template.getInfo() + " failed!"), (Throwable)ex);
        }
    }
}

