/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.GroupUserCacheMgr;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.IUserCacheMgr;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUserCacheMgr;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.resource.DocLevel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyEncrypt;
import com.trs.infra.util.CMyString;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class User
extends CMSObj
implements Serializable {
    private static final long serialVersionUID = 1354095122078583355L;
    private static Logger s_logger = Logger.getLogger(User.class);
    public static final int OBJ_TYPE = 204;
    public static final String DB_TABLE_NAME = "WCMUSER";
    public static final String DB_ID_NAME = "USERID";
    public static final int USER_STATUS_APPLY = 0;
    public static final int USER_STATUS_REG = 30;
    public static final int USER_STATUS_DEL = 10;
    public static final int USER_STATUS_FORBID = 20;
    public static final int USER_STATUS_ALL = -1;
    public static final int USER_STATUS_DROPED = 40;
    public static final char USER_DROPED_NAME_FLAG = '$';
    public static final String SYSTEM_USERNAME = "system";
    private static final int SYSTEM_USEID = Integer.MAX_VALUE;
    private static User USER_SYSTEM = null;
    private boolean bLogined = false;
    private CMyDateTime dtLastLoginTime = null;
    private static final char[] INVALID_FOR_NAME = new char[]{'~', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '\'', '\"', ':', '>', '<', '?'};
    private boolean m_bCacheGroupsAndRoles = false;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 204;
    }

    @Override
    public boolean isValidInstance() {
        return super.isValidInstance() || this.isSystem();
    }

    public boolean isSystem() {
        return this.id == Integer.MAX_VALUE;
    }

    public boolean isForbidden() {
        return this.getStatus() == 20;
    }

    @Override
    public boolean equals(Object _another) {
        if (_another == this) {
            return true;
        }
        if (!(_another instanceof User)) {
            return false;
        }
        if (super.equals(_another)) {
            return true;
        }
        User _anotherUser = (User)_another;
        return this.isSystem() && _anotherUser.isSystem();
    }

    public String getName() {
        return (String)this.getProperty("USERNAME");
    }

    public boolean nameIs(String _name) {
        if (_name == null) {
            return false;
        }
        return _name.compareTo(this.getName()) == 0;
    }

    public boolean setName(String _name) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(User.class, "User.label1", "\u7528\u6237\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539(User.setName)"));
        }
        return this.setProperty("USERNAME", _name);
    }

    public boolean setPassword(String _password) throws WCMException {
        int nLen = _password.length();
        if (nLen < 8) {
            throw new WCMException(1104, I18NMessage.get(User.class, "User.label2", "\u5bc6\u7801\u8981\u6c42\u81f3\u5c114\u4e2a\u5b57\u7b26 (User.setPassword)"));
        }
        return this.setProperty("PASSWORD", _password);
    }

    public String getReminderQuestion() {
        return (String)this.getProperty("REMINDERQUESTION");
    }

    public boolean setReminderQuestion(String _reminderQuestion) throws WCMException {
        return this.setProperty("REMINDERQUESTION", _reminderQuestion);
    }

    public String getReminderAnswer() {
        return (String)this.getProperty("REMINDERANSWER");
    }

    public boolean setReminderAnswer(String _reminderAnswer) throws WCMException {
        return this.setProperty("REMINDERANSWER", _reminderAnswer);
    }

    public String getNickName() {
        return (String)this.getProperty("NICKNAME");
    }

    public boolean setNickName(String _nickName) throws WCMException {
        return this.setProperty("NICKNAME", _nickName);
    }

    public String getTrueName() {
        return (String)this.getProperty("TRUENAME");
    }

    public boolean setTrueName(String _trueName) throws WCMException {
        return this.setProperty("TRUENAME", _trueName);
    }

    public String getAddress() {
        return (String)this.getProperty("ADDRESS");
    }

    public boolean setAddress(String _address) throws WCMException {
        return this.setProperty("ADDRESS", _address);
    }

    public String getTel() {
        return (String)this.getProperty("TEL");
    }

    public boolean setTel(String _tel) throws WCMException {
        return this.setProperty("TEL", _tel);
    }

    public String getMobile() {
        return (String)this.getProperty("MOBILE");
    }

    public boolean setMobile(String _mobile) throws WCMException {
        return this.setProperty("MOBILE", _mobile);
    }

    public String getEmail() {
        return (String)this.getProperty("EMAIL");
    }

    public boolean setEmail(String _email) throws WCMException {
        return this.setProperty("EMAIL", _email);
    }

    public String getWxname() {
        return (String)this.getProperty("WXNAME");
    }

    public boolean setWxname(String _wxname) throws WCMException {
        return this.setProperty("WXNAME", _wxname);
    }

    public String getHeadImg() {
        return (String)this.getProperty("HEADIMG");
    }

    public boolean setHeadImg(String _headImg) throws WCMException {
        return this.setProperty("HEADIMG", _headImg);
    }

    public int getStatus() {
        return this.getPropertyAsInt("STATUS", 0);
    }

    public boolean setStatus(int _status) throws WCMException {
        if (!this.setProperty("STATUS", _status)) {
            return false;
        }
        if (_status == 30) {
            return this.setRegTime();
        }
        return true;
    }

    public String getStatusString() {
        if (this.isDeleted()) {
            return I18NMessage.get(User.class, "User.label3", "\u5df2\u5220\u9664");
        }
        return User.getStatusString(this.getStatus());
    }

    public int getLoginTimes() {
        return this.getPropertyAsInt("LOGINTIMES", 0);
    }

    public CMyDateTime getRegTime() {
        return this.getPropertyAsDateTime("REGTIME");
    }

    private boolean setRegTime() throws WCMException {
        CMyDateTime dtNow = new CMyDateTime();
        dtNow.setDateTimeWithCurrentTime();
        return this.setProperty("REGTIME", dtNow);
    }

    public CMyDateTime getLoginTime() {
        return this.getPropertyAsDateTime("LOGINTIME");
    }

    public CMyDateTime getLastLoginTime() {
        return this.dtLastLoginTime;
    }

    public boolean isPubMyInfo() {
        return this.getPropertyAsBoolean("IFPUBMYINFO", true);
    }

    public boolean setPubMyInfo(boolean _bPubMyInfo) throws WCMException {
        return this.setProperty("IFPUBMYINFO", _bPubMyInfo);
    }

    public int getMsgInterval() {
        return this.getPropertyAsInt("MSGINTERVAL", 0);
    }

    public boolean setMsgInterval(int _msgInterval) throws WCMException {
        return this.setProperty("MSGINTERVAL", _msgInterval);
    }

    public int getViewInterval() {
        return this.getPropertyAsInt("VIEWINTERVAL", 0);
    }

    public boolean setViewInterval(int _viewInterval) throws WCMException {
        return this.setProperty("VIEWINTERVAL", _viewInterval);
    }

    public int getPrice() {
        return this.getPropertyAsInt("PRICE", 0);
    }

    public boolean setPrice(int _nPrice) throws WCMException {
        return this.setProperty("PRICE", _nPrice);
    }

    public String getLoginIP() {
        return this.getAttributeValue("LOGINIP");
    }

    public boolean isDeleted() {
        return this.getPropertyAsBoolean("ISDELETED", true);
    }

    public boolean setDeleted(boolean _bDeleted) throws WCMException {
        return this.setProperty("ISDELETED", _bDeleted);
    }

    public int getPasswordLev() {
        return this.getPropertyAsInt("PASSWORDLEV", 0);
    }

    public boolean setPasswordLev(int _nPasswordLev) throws WCMException {
        return this.setProperty("PASSWORDLEV", _nPasswordLev);
    }

    private String cryptPassword(String _sPassword) {
        if (_sPassword == null) {
            return null;
        }
        return new CMyEncrypt().getMD5OfStr(_sPassword).substring(0, 15);
    }

    private String newCryptPassword(String _sPassword) {
        String sValue;
        char nSecondValue;
        int nSubLength;
        long lValue;
        if (_sPassword == null) {
            return null;
        }
        int cFirstPasswordChar = _sPassword.charAt(0);
        int nSeed = cFirstPasswordChar;
        if (nSeed < 0) {
            nSeed = 99;
        }
        if ((lValue = this.produceLongValue(nSeed)) < 10L) {
            lValue = 1234567L;
        }
        if ((nSubLength = (nSecondValue = (sValue = new Long(lValue).toString()).charAt(1)) % 10) < 3 || nSubLength > 7) {
            nSubLength = 3;
        }
        String sMD5Password = new CMyEncrypt().getMD5OfStr(_sPassword);
        int nCount = sMD5Password.length() / nSubLength + 1;
        String[] array_MD5Passwords = new String[nCount];
        for (int i = 0; i < nCount; ++i) {
            if (i < nCount - 1) {
                array_MD5Passwords[i] = sMD5Password.substring(i * nSubLength, (i + 1) * nSubLength);
                array_MD5Passwords[i] = this.disruptCharactersOrder(array_MD5Passwords[i]);
                continue;
            }
            array_MD5Passwords[i] = sMD5Password.substring(i * nSubLength, sMD5Password.length());
            array_MD5Passwords[i] = this.disruptCharactersOrder(array_MD5Passwords[i]);
        }
        array_MD5Passwords = this.disruptStringArray(array_MD5Passwords);
        StringBuffer sBuffNewMD5Password = new StringBuffer();
        for (int i = 0; i < array_MD5Passwords.length; ++i) {
            sBuffNewMD5Password.append(array_MD5Passwords[i]);
        }
        return sBuffNewMD5Password.toString().substring(0, 15);
    }

    private long produceLongValue(int nValue) {
        double dBase = 256.0;
        double dTemp1 = ((double)nValue + 0.123) * 17.0 + 139.0;
        double dTemp2 = (int)(dTemp1 / 256.0);
        double dTemp3 = dTemp1 - dTemp2 * dBase;
        double dValue = dTemp3 / 256.0 * 10000.0;
        return (long)dValue;
    }

    private String disruptCharactersOrder(String string) {
        char[] charArray = string.toCharArray();
        for (int i = 0; i < string.length() / 2; ++i) {
            char c = charArray[i];
            charArray[i] = charArray[string.length() - 1 - i];
            charArray[string.length() - 1 - i] = c;
        }
        String sNewArrayStr = new String(charArray);
        return sNewArrayStr;
    }

    private String[] disruptStringArray(String[] arrStringArray) {
        for (int i = 0; i < arrStringArray.length / 2; ++i) {
            String sTemp;
            if (i % 2 != 0 && arrStringArray.length % 2 == 0) {
                sTemp = arrStringArray[i];
                arrStringArray[i] = arrStringArray[arrStringArray.length - i];
                arrStringArray[arrStringArray.length - i] = sTemp;
            }
            if (i % 2 == 0 || arrStringArray.length % 2 == 0) continue;
            sTemp = arrStringArray[i];
            arrStringArray[i] = arrStringArray[arrStringArray.length - i - 1];
            arrStringArray[arrStringArray.length - i - 1] = sTemp;
        }
        String[] arrNewStringArray = arrStringArray;
        return arrNewStringArray;
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            String sName = (String)this.getAllProperty().get("USERNAME");
            if (sName == null) {
                throw new BizError(I18NMessage.get(User.class, "User.label4", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e"));
            }
            this.assertValidName(sName);
            String sNickName = (String)this.getAllProperty().get("NICKNAME");
            if (!CMyString.isEmpty(sNickName)) {
                this.assertValidName(sNickName);
            }
            if ((String)this.getAllProperty().get("PASSWORD") == null) {
                throw new BizError(I18NMessage.get(User.class, "User.label5", "\u5c5e\u6027Password\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if ((sName = sName.toLowerCase()).compareTo(SYSTEM_USERNAME) == 0) {
                throw new BizError(I18NMessage.get(User.class, "User.label6", "\u7528\u6237\u540d") + SYSTEM_USERNAME + I18NMessage.get(User.class, "User.label7", "\u7981\u6b62\u4f7f\u7528"));
            }
            String strCondition = "UserName='" + CMyString.filterForSQL(sName) + "'";
            if (this.checkExists(strCondition)) {
                throw new BizError(I18NMessage.get(User.class, "User.label6", "\u7528\u6237\u540d") + sName + I18NMessage.get(User.class, "User.label8", "\u5df2\u7ecf\u5b58\u5728"));
            }
            this.setName(sName);
        } else {
            String sNickName;
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(User.class, "User.label9", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(User.isValid)"));
            }
            if (this.isChangeProperty("NICKNAME") && !CMyString.isEmpty(sNickName = (String)this.getNewProperties().get("NICKNAME"))) {
                this.assertValidName(sNickName);
            }
            if (this.isChangeProperty("USERNAME")) {
                StringBuffer buffName = new StringBuffer(64);
                buffName.append(this.getName());
                buffName.append('$');
                buffName.append(this.getId());
                if (!this.getNewProperty("USERNAME").equals(buffName.toString())) {
                    throw new WCMException("\u4e0d\u80fd\u4fee\u6539\u7528\u6237\u540d");
                }
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            if (this.getProperty("ISDELETED") == null) {
                this.setDeleted(false);
            }
            if (this.getProperty("CRTIME") == null) {
                this.setCrTime();
            }
            if (this.getProperty("STATUS") == null) {
                this.setProperty("STATUS", 30L);
            }
            this.setProperty("LOGINTIMES", 0L);
            boolean isConfig = false;
            isConfig = ConfigServer.getServer().getSysConfigValue("NEW_CRYPT_PASSWORD", "false").equalsIgnoreCase("true");
            if (!isConfig) {
                this.setProperty("PASSWORD", this.cryptPassword((String)this.getAllProperty().get("PASSWORD")));
            } else {
                this.setProperty("PASSWORD", this.newCryptPassword((String)this.getAllProperty().get("PASSWORD")));
            }
            super.insert(_currUser);
        }
    }

    @Override
    public void update(User _currUser) throws WCMException {
        if (this.isChangeProperty("PASSWORD")) {
            boolean isConfig = false;
            isConfig = ConfigServer.getServer().getSysConfigValue("NEW_CRYPT_PASSWORD", "false").equalsIgnoreCase("true");
            if (!isConfig) {
                this.setProperty("PASSWORD", this.cryptPassword(this.getNewPropertyAsString("PASSWORD")));
            } else {
                this.setProperty("PASSWORD", this.newCryptPassword(this.getNewPropertyAsString("PASSWORD")));
            }
        }
        super.update(_currUser);
    }

    public boolean isLogined() {
        return this.bLogined;
    }

    public boolean passwordIs(String _password) {
        boolean bNewOK;
        String password = (String)this.getAllProperty().get("PASSWORD");
        if (password == null) {
            return false;
        }
        boolean bl = bNewOK = password.compareTo(this.newCryptPassword(_password)) == 0;
        if (bNewOK) {
            return true;
        }
        boolean bOldOK = password.compareTo(this.cryptPassword(_password)) == 0;
        boolean isConfig = false;
        try {
            isConfig = ConfigServer.getServer().getSysConfigValue("NEW_CRYPT_PASSWORD", "false").equalsIgnoreCase("true");
        }
        catch (WCMException e1) {
            e1.printStackTrace();
        }
        if (isConfig) {
            if (bOldOK) {
                try {
                    this.setProperty("PASSWORD", _password);
                    this.update(this);
                }
                catch (WCMException e) {
                    throw new RuntimeException("\u66f4\u65b0\u5bc6\u7801\u52a0\u5bc6\u65b9\u5f0f\u51fa\u9519\uff01", e);
                }
                return true;
            }
            return false;
        }
        return bOldOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int login(String _password, String _sRemoteAddr) throws WCMException {
        if (this.getAllProperty() == null) {
            return -1;
        }
        if (this.isDeleted()) {
            return 10;
        }
        int nStatus = this.getStatus();
        if (nStatus != 30) {
            return nStatus;
        }
        if (!this.passwordIs(_password)) {
            return -1;
        }
        if (this.bLogined) {
            this.logout();
        }
        User user = this;
        try {
            user = ContextHelper.getLoginUser();
        }
        catch (Exception ex) {
            user = this;
        }
        if (!this.canEdit(user)) {
            return -2;
        }
        try {
            CMyDateTime loginTime = this.getPropertyAsDateTime("LOGINTIME");
            CMyDateTime cMyDateTime = this.dtLastLoginTime = loginTime == null ? null : (CMyDateTime)loginTime.clone();
            if (loginTime == null) {
                loginTime = new CMyDateTime();
            }
            loginTime.setDateTimeWithCurrentTime();
            this.setProperty("LOGINTIME", loginTime);
            int nLoginTimes = this.getLoginTimes();
            this.setProperty("LOGINTIMES", nLoginTimes + 1);
            this.setAttribute("LoginIP", _sRemoteAddr);
            this.update(user);
            this.bLogined = true;
            int n = nStatus;
            return n;
        }
        finally {
            if (this.isLocked()) {
                this.cancelUpdate(this);
            }
        }
    }

    public void logout() {
        if (!this.bLogined) {
            return;
        }
        this.bLogined = false;
    }

    public static String getStatusString(int _status) {
        switch (_status) {
            case 0: {
                return I18NMessage.get(User.class, "User.label10", "\u5f85\u5f00\u901a");
            }
            case 10: {
                return I18NMessage.get(User.class, "User.label3", "\u5df2\u5220\u9664");
            }
            case 20: {
                return I18NMessage.get(User.class, "User.label11", "\u5df2\u505c\u7528");
            }
            case 30: {
                return I18NMessage.get(User.class, "User.label12", "\u5df2\u5f00\u901a");
            }
        }
        return I18NMessage.get(User.class, "User.label13", "\u672a\u77e5");
    }

    public boolean isAdministrator() throws WCMException {
        return Users.findAdministrators().indexOf(this.getId()) >= 0;
    }

    public boolean isSecurityAdmin() throws WCMException {
        String isStartSeparate = ConfigServer.getServer().getInitProperty("SEPARATION_OF_THREE_POWERS");
        if ("true".equalsIgnoreCase(isStartSeparate)) {
            return this.hasRightByRoleName(this, "SecurityAdmins");
        }
        return this.isAdministrator();
    }

    private boolean hasRightByRoleName(User _oUser, String _sRoleName) throws WCMException {
        RoleMgr roleMgr = new RoleMgr();
        Roles oCurrRoles = roleMgr.getSpecialRolesOfUser(_oUser, null);
        if (oCurrRoles == null || oCurrRoles.size() == 0) {
            return false;
        }
        for (int i = 0; i < oCurrRoles.size(); ++i) {
            Role oCurrRole = (Role)oCurrRoles.getAt(i);
            String sName = oCurrRole.getName();
            if (!sName.equals(_sRoleName)) continue;
            return true;
        }
        return false;
    }

    public boolean isAuditAdmin() throws WCMException {
        String isStartSeparate = ConfigServer.getServer().getInitProperty("SEPARATION_OF_THREE_POWERS");
        if ("true".equalsIgnoreCase(isStartSeparate)) {
            return this.hasRightByRoleName(this, "AuditAdmins");
        }
        return this.isAdministrator();
    }

    public void setCacheGroupsAndRoles(boolean _bCache) {
    }

    public String getGroupNames() throws WCMException {
        StringBuilder groupNames = new StringBuilder();
        Groups groups = this.getGroups();
        for (int i = 0; i < groups.size(); ++i) {
            Group group = (Group)groups.getAt(i);
            groupNames.append(group.getName());
            groupNames.append(",");
        }
        if (groupNames.length() > 0) {
            groupNames.deleteCharAt(groupNames.lastIndexOf(","));
        }
        return groupNames.toString();
    }

    public Groups getGroups() throws WCMException {
        return this.initGroups();
    }

    private Groups initGroups() throws WCMException {
        Groups groups = ((GroupUserCacheMgr)DreamFactory.createObjectById("GroupUserCacheMgr")).getGroups(this);
        Groups results = new Groups(this);
        for (int i = 0; i < groups.size(); ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            results.addElement(group);
        }
        return results;
    }

    public Roles getRoles() throws WCMException {
        return this.initRoles();
    }

    private Roles initRoles() throws WCMException {
        Roles roles = ((RoleUserCacheMgr)DreamFactory.createObjectById("RoleUserCacheMgr")).getRoles(this);
        Roles results = new Roles(this);
        for (int i = 0; i < roles.size(); ++i) {
            Role role = (Role)roles.getAt(i);
            if (role == null) continue;
            results.addElement(role);
        }
        if (roles.indexOf(2) < 0) {
            Role everyone = Role.findById(2);
            results.addElement(everyone);
        }
        return results;
    }

    public Rights getMyRights(int _objType) throws WCMException {
        WCMFilter filter = null;
        Rights rights = null;
        try {
            filter = new WCMFilter("", "OprType=" + this.getWCMType() + " and OprId=" + this.getId() + " and ObjType=" + _objType, "");
            rights = new Rights(null);
            rights.open(filter);
            return rights;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(User.class, "User.label14", "\u83b7\u53d6\u7528\u6237\u7684\u6743\u9650\u5bf9\u8c61\u96c6\u5408\u65f6\u5931\u8d25(User.getMyRights)"), ex);
        }
    }

    public RightValue getMyRightValue(CMSObj _obj) throws WCMException {
        if (_obj == null || !_obj.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(User.class, "User.label15", "\u65e0\u6548\u7684\u64cd\u4f5c\u5bf9\u8c61(User.getMyRightValue)"));
        }
        return this.getMyRightValue(_obj.getWCMType(), _obj.getId());
    }

    public RightValue getMyRightValue(int _objType, int _objId) throws WCMException {
        RightValue rightValue = new RightValue();
        try {
            rightValue.load(this, _objType, _objId);
            return rightValue;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(User.class, "User.label16", "\u83b7\u53d6\u7528\u6237\u5728\u6307\u5b9a\u5bf9\u8c61\u4e0a\u7684\u6743\u9650\u503c\u65f6\u5931\u8d25(User.getMyRightValue)"), ex);
        }
    }

    public DocLevel getDocLevel() throws WCMException {
        int nDocLevelId = this.getDocLevleId();
        if (nDocLevelId == 0) {
            return DocLevel.findById(1);
        }
        return DocLevel.findById(nDocLevelId);
    }

    public boolean setDocLevel(DocLevel _docLevel) throws WCMException {
        if (_docLevel == null) {
            return this.setDocLevel(0);
        }
        return this.setDocLevel(_docLevel.getId());
    }

    public int getDocLevleId() {
        return this.getPropertyAsInt("VIEWDOCLEVEL", 0);
    }

    public boolean setDocLevel(int _nDocLevelId) throws WCMException {
        return this.setProperty("VIEWDOCLEVEL", _nDocLevelId);
    }

    public static final User findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        if (_nId == Integer.MAX_VALUE && USER_SYSTEM != null) {
            return USER_SYSTEM;
        }
        return (User)BaseObj.findById(User.class, _nId);
    }

    public static final User createNewInstance() throws WCMException {
        return (User)BaseObj.createNewInstance(User.class);
    }

    public static final User findByKey(Object _oKey) throws WCMException {
        if ((Integer)_oKey == Integer.MAX_VALUE) {
            return User.getSystem();
        }
        return (User)BaseObj.findByKey(User.class, _oKey);
    }

    public static IUserCacheMgr getUserCacheMgr() throws WCMException {
        IUserCacheMgr userCacheMgr = (IUserCacheMgr)DreamFactory.createObjectById("IUserCacheMgr");
        if (userCacheMgr == null) {
            throw new WCMException(10, "IUserCacheMgr config invalid!");
        }
        return userCacheMgr;
    }

    public static final User findByName(String _sUserName) {
        if (SYSTEM_USERNAME.equals(_sUserName)) {
            return User.getSystem();
        }
        try {
            return User.getUserCacheMgr()._getUserByName(_sUserName);
        }
        catch (WCMException ex) {
            s_logger.error((Object)I18NMessage.get(User.class, "User.label17", "\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff01"), (Throwable)ex);
            return null;
        }
    }

    public static final User getSystem() {
        if (USER_SYSTEM == null) {
            User.makeSystem();
        }
        return USER_SYSTEM;
    }

    private static final synchronized void makeSystem() {
        if (USER_SYSTEM != null) {
            return;
        }
        try {
            User user = new User();
            user.setProperty("USERNAME", SYSTEM_USERNAME, false);
            user.setProperty("TRUENAME", I18NMessage.get(User.class, "User.label18", "\u865a\u62df\u7684\u7cfb\u7edf\u7528\u6237"), false);
            user.setProperty("LOGINIP", "127.0.0.1", false);
            user.id = Integer.MAX_VALUE;
            USER_SYSTEM = user;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(User.class, "User.label19", "[\u7528\u6237-") + this.getId() + "]";
    }

    private void assertValidName(String _name) throws WCMException {
        String sInvalid = "";
        char[] invalidChars = INVALID_FOR_NAME;
        for (int i = 0; i < invalidChars.length; ++i) {
            if (_name.indexOf(invalidChars[i]) == -1) continue;
            sInvalid = sInvalid + invalidChars[i];
        }
        if (sInvalid.length() > 0) {
            throw new WCMException(10, I18NMessage.get(User.class, "User.label20", "\u65e0\u6548\u7684\u7528\u6237\u540d[") + _name + I18NMessage.get(User.class, "User.label21", "],\u7528\u6237\u540d\u542b\u6709\u7279\u6b8a\u5b57\u7b26[") + sInvalid + "]!");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getAllProperty());
        out.writeObject(this.getNewProperties());
        out.writeInt(this.getId());
        out.writeBoolean(this.isAddMode());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setProperties((Hashtable)in.readObject());
        this.setNewProperties((Hashtable)in.readObject());
        this.id = in.readInt();
        this.bAddMode = in.readBoolean();
    }

    public static void main(String[] args) {
        String[] pPassword = new String[]{"trsdemo123", "trswcmadmin", "trsadmin@196", "trsadmin", "11111111", "12345678", "88888888"};
        for (int i = 0; i < pPassword.length; ++i) {
            System.out.println(pPassword[i]);
            System.out.println(new CMyEncrypt().getMD5OfStr(pPassword[i]).substring(0, 15));
        }
    }
}

