/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.domain.UpdUserScheduleCreator;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.ObjectMembers;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class UserMgr {
    private static final Logger m_oLogger = Logger.getLogger((String)UserMgr.class.getName());
    public static final String USER_DEFAULT_PASSWORD = "trsadmin";

    public Rights getUserRightsOnWCMObj(int _nObjType) throws WCMException {
        if (ContextHelper.getLoginUser() == null) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label1", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u8be5\u7528\u6237\u5728\u5176\u5b83\u5bf9\u8c61\u4e0a\u62e5\u6709\u7684\u6743\u9650!"));
        }
        WCMFilter aFilter = new WCMFilter("", "OprType=204 and OprId=" + ContextHelper.getLoginUser().getId() + " and ObjType=" + _nObjType, "");
        try {
            return Rights.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        }
        catch (WCMException ex) {
            m_oLogger.debug((Object)(I18NMessage.get(UserMgr.class, "UserMgr.label2", "\u83b7\u53d6\u7528\u6237\u7684\u6743\u9650\u5931\u8d25:") + ex.getStackTraceText()));
            throw new WCMException(1100, I18NMessage.get(UserMgr.class, "UserMgr.label3", "\u83b7\u53d6\u7528\u6237\u5728[") + WCMTypes.getObjName(_nObjType, true) + I18NMessage.get(UserMgr.class, "UserMgr.label4", "]\u5bf9\u8c61\u4e0a\u7684\u6743\u9650\u5931\u8d25!"), ex);
        }
    }

    public RightValue getMyRightValue(CMSObj _obj) throws WCMException {
        if (_obj == null || !_obj.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label5", "\u65e0\u6548\u7684\u64cd\u4f5c\u5bf9\u8c61(User.getMyRightValue)"));
        }
        return this.getMyRightValue(_obj.getWCMType(), _obj.getId());
    }

    public RightValue getMyRightValue(int _objType, int _objId) throws WCMException {
        try {
            RightValue rightValue = new RightValue();
            rightValue.load(ContextHelper.getLoginUser(), _objType, _objId);
            return rightValue;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(UserMgr.class, "UserMgr.label6", "\u83b7\u53d6\u7528\u6237\u5728\u6307\u5b9a\u5bf9\u8c61\u4e0a\u7684\u6743\u9650\u503c\u65f6\u5931\u8d25(User.getMyRightValue)"), ex);
        }
    }

    public Groups getGroups(User _dstUser) throws WCMException {
        if (_dstUser == null) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label7", "\u65e0\u6548\u7528\u6237\u5bf9\u8c61!"));
        }
        WCMFilter aFilter = new WCMFilter("wcmGrpUser", "UserId=" + _dstUser.getId(), "", "GroupId");
        return Groups.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Roles getRoles(User _dstUser) throws WCMException {
        if (_dstUser == null) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label7", "\u65e0\u6548\u7528\u6237\u5bf9\u8c61!"));
        }
        Roles aRoles = Roles.createNewInstance(ContextHelper.getLoginUser());
        WCMFilter aFilter = new WCMFilter("wcmRoleUser", "UserId=" + _dstUser.getId(), "", "RoleId");
        aRoles = Roles.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        if (aRoles.indexOf(2) < 0) {
            Role everyone = Role.findById(2);
            aRoles.addElement(everyone);
        }
        return aRoles;
    }

    public boolean delete(User _aUserToBeDeleted, boolean _bDrop) throws WCMException {
        if (_aUserToBeDeleted == null) {
            throw new WCMException(20, I18NMessage.get(UserMgr.class, "UserMgr.label8", "\u6b32\u5220\u9664\u7684\u7528\u6237\u4e3a\u7a7a\uff01"));
        }
        if (_aUserToBeDeleted == ContextHelper.getLoginUser()) {
            throw new WCMException(1002, I18NMessage.get(UserMgr.class, "UserMgr.label9", "\u60a8\u65e0\u6cd5\u5220\u9664\u81ea\u5df1\uff01"));
        }
        if (!_bDrop) {
            _aUserToBeDeleted.canEdit(this.getLoginUser());
            _aUserToBeDeleted.setDeleted(true);
            this.save(_aUserToBeDeleted);
            return true;
        }
        try {
            GroupMgr currGroupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
            Groups currGroups = this.getGroups(_aUserToBeDeleted);
            if (currGroups != null && !currGroups.isEmpty()) {
                for (int i = 0; i < currGroups.size(); ++i) {
                    Group oGroup = (Group)currGroups.getAt(i);
                    if (oGroup == null) continue;
                    currGroupMgr.removeUser(_aUserToBeDeleted, oGroup);
                }
            }
            RoleMgr currRoleMgr = (RoleMgr)DreamFactory.createObjectById("RoleMgr");
            Roles currRoles = this.getRoles(_aUserToBeDeleted);
            if (currRoles != null && !currRoles.isEmpty()) {
                for (int i = 0; i < currRoles.size(); ++i) {
                    Role oRole = (Role)currRoles.getAt(i);
                    if (oRole == null) continue;
                    currRoleMgr.removeUser(_aUserToBeDeleted, oRole);
                }
            }
            User currUser = this.getLoginUser();
            Rights rights = new Rights(currUser);
            WCMFilter filter = new WCMFilter("WCMRIGHT", "OprType=? and OprId=?", "");
            filter.addSearchValues(204);
            filter.addSearchValues(_aUserToBeDeleted.getId());
            rights.open(filter);
            rights.removeAll(true);
            filter = new WCMFilter("", "MEMBERTYPE=? AND MEMBERID=?", "", "");
            filter.addSearchValues(204);
            filter.addSearchValues(_aUserToBeDeleted.getId());
            ObjectMembers objectMembers = ObjectMembers.openWCMObjs(currUser, filter);
            objectMembers.removeAll(true);
            UpdUserScheduleCreator.scheduleUpdUserRelatedInfo(_aUserToBeDeleted, currUser);
            _aUserToBeDeleted.canEdit(currUser);
            StringBuffer buffName = new StringBuffer(64);
            buffName.append(_aUserToBeDeleted.getName());
            buffName.append('$');
            buffName.append(_aUserToBeDeleted.getId());
            _aUserToBeDeleted.setProperty("USERNAME", buffName.toString());
            _aUserToBeDeleted.setStatus(40);
            _aUserToBeDeleted.setDeleted(false);
            _aUserToBeDeleted.save(currUser);
            return true;
        }
        catch (WCMException ex) {
            m_oLogger.debug((Object)ex.getStackTraceText());
            throw new WCMException(1100, I18NMessage.get(UserMgr.class, "UserMgr.label13", "\u5f7b\u5e95\u5220\u9664\u7528\u6237\u5931\u8d25!"), ex);
        }
        catch (Exception e) {
            m_oLogger.debug((Object)("ex: " + e.toString()));
            return false;
        }
    }

    public boolean changeUserRegStatus(User _dstUser, int _nNewStatusId) throws WCMException {
        if (_dstUser == null) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label14", "\u8bf7\u6307\u5b9a\u4e00\u4e2a\u8981\u66f4\u6539\u7684\u7528\u6237\uff01"));
        }
        if (_nNewStatusId == _dstUser.getStatus()) {
            return true;
        }
        if (!_dstUser.canEdit(ContextHelper.getLoginUser())) {
            throw new WCMException(1012, I18NMessage.get(UserMgr.class, "UserMgr.label15", "\u5f53\u524d\u5bf9\u8c61\u53ef\u80fd\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u9501\u5b9a!"));
        }
        boolean bOperatSuccessed = _dstUser.setStatus(_nNewStatusId);
        _dstUser.update(ContextHelper.getLoginUser());
        return bOperatSuccessed;
    }

    public Users getConsignUsers(int _nModuleType) throws WCMException {
        String sNowTime = CMyDateTime.now().toString("yyyy-MM-dd");
        String sTimeSql = "StartTime<=" + this.getDBManager().getDBType().sqlDateTime(sNowTime + " 23:59:59", "YYYY-MM-DD HH24:MI:SS") + " and EndTime>=" + this.getDBManager().getDBType().sqlDateTime(sNowTime + " 00:00:00", "YYYY-MM-DD HH24:MI:SS");
        String sTrusteeWhere = "Status>0 and (" + sTimeSql + ") and Module=" + _nModuleType;
        String sWhere = "EXISTS(select Trustee from wcmTrusteeInfo where " + sTrusteeWhere + ")";
        WCMFilter aFilter = new WCMFilter("WCMUSER", sWhere, "");
        try {
            return Users.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        }
        catch (WCMException ex) {
            m_oLogger.debug((Object)(I18NMessage.get(UserMgr.class, "UserMgr.label16", "\u83b7\u53d6\u6307\u5b9a\u6a21\u5757\u7684\u6240\u6709\u7684\u59d4\u6258\u4eba\u5931\u8d25:") + ex.getStackTraceText()));
            throw new WCMException(1100, I18NMessage.get(UserMgr.class, "UserMgr.label17", "\u83b7\u53d6\u6307\u5b9a\u6a21\u5757\u7684\u6240\u6709\u7684\u59d4\u6258\u4eba\u5931\u8d25!"), ex);
        }
    }

    public Rights getMyRights(int _nOperatorType, int _nOperatorId, int _nObjType) throws WCMException {
        if (_nOperatorType != 204 && _nOperatorType != 203 && _nOperatorType != 201) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label18", "\u65e0\u6548\u7684\u64cd\u4f5c\u8005\u7c7b\u578b!"));
        }
        if (_nOperatorId <= 0 || _nObjType <= 0) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label19", "\u65e0\u6548\u7684\u5bf9\u8c61id!"));
        }
        String sWhere = "OprType=" + _nOperatorType + " and OprId=" + _nOperatorId + " and ObjType=" + _nObjType;
        WCMFilter aFilter = new WCMFilter("WCMRIGHT", sWhere, "");
        return Rights.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public User save(User _dstUser) throws WCMException {
        m_oLogger.debug((Object)I18NMessage.get(UserMgr.class, "UserMgr.label20", "\u3010LOG\u3011\u5f00\u59cb\u4fdd\u5b58\u7528\u6237\uff1aUserMgr.save"));
        this.validate(_dstUser);
        _dstUser = this.prepareSave(_dstUser);
        _dstUser.save(ContextHelper.getLoginUser());
        return _dstUser;
    }

    private void validate(User _dstUser) throws WCMException {
        if (_dstUser == null) {
            throw new WCMException(20, I18NMessage.get(UserMgr.class, "UserMgr.label21", "\u7528\u6237\u4e3a\u7a7a\uff01"));
        }
        if (_dstUser.getName() == null) {
            throw new WCMException(1106, I18NMessage.get(UserMgr.class, "UserMgr.label22", "\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        String sName = _dstUser.getName().trim();
        int len = CMyString.getBytesLength(sName);
        int MIN_LEN = 3;
        int MAX_LEN = 50;
        if (len < 3 || len > 50) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label23", "\u7528\u6237\u59d3\u540d\u4e0d\u5728\u957f\u5ea6\u8303\u56f4\u5185\uff01"));
        }
        if (!this.isNameValid(sName)) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label24", "\u7528\u6237\u540d\u4e2d\u5305\u542b\u65e0\u6548\u5b57\u7b26\uff01"));
        }
        if (_dstUser.isAddMode() && User.findByName(sName) != null) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label25", "\u7528\u6237\u540d\u5df2\u7ecf\u5b58\u5728\uff01"));
        }
        if (sName.compareTo("system") == 0) {
            throw new WCMException(1104, I18NMessage.get(UserMgr.class, "UserMgr.label26", "\u7528\u6237\u540d") + "system" + I18NMessage.get(UserMgr.class, "UserMgr.label27", "\u7981\u6b62\u4f7f\u7528"));
        }
    }

    private User prepareSave(User _dstUser) throws WCMException {
        String sPassword;
        if (_dstUser.getNickName() == null) {
            _dstUser.setNickName(_dstUser.getName());
        }
        if ((sPassword = _dstUser.getPropertyAsString("PASSWORD")) == null || sPassword.trim().length() == 0) {
            _dstUser.setProperty("PASSWORD", USER_DEFAULT_PASSWORD);
        }
        return _dstUser;
    }

    public boolean resetPassword(User _dstUser, String _sOldPassword, String _sNewPassword) throws WCMException {
        if (_dstUser == null) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label28", "\u65e0\u6548\u7684\u7528\u6237!"));
        }
        if (!_dstUser.passwordIs(_sOldPassword)) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label29", "\u9519\u8bef\u7684\u65e7\u5bc6\u7801,\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u65e7\u5bc6\u7801!"));
        }
        if (!_dstUser.canEdit(this.getLoginUser())) {
            throw new WCMException(1013, I18NMessage.get(UserMgr.class, "UserMgr.label30", "\u5bf9\u8c61\u5df2\u7ecf\u88ab\u7528\u6237[") + _dstUser.getLockerUserName() + I18NMessage.get(UserMgr.class, "UserMgr.label31", "]\u9501\u5b9a!\u4e0d\u80fd\u88ab\u5f53\u524d\u7528\u6237[") + this.getLoginUserName() + I18NMessage.get(UserMgr.class, "UserMgr.label32", "]\u4fee\u6539!"));
        }
        _dstUser.setProperty("PASSWORD", _sNewPassword);
        _dstUser.update(ContextHelper.getLoginUser());
        return true;
    }

    public boolean resetPassword(User _dstUser) throws WCMException {
        if (_dstUser == null) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label28", "\u65e0\u6548\u7684\u7528\u6237!"));
        }
        User user = this.getLoginUser();
        if (user == null) {
            throw new WCMException(1002, I18NMessage.get(UserMgr.class, "UserMgr.label33", "\u64cd\u4f5c\u6ca1\u6709\u76f8\u5173\u7684\u7528\u6237!"));
        }
        String sPassword = ConfigServer.getServer().getInitProperty("SYSUSERPWD");
        _dstUser.canEdit(user);
        _dstUser.setProperty("PASSWORD", sPassword);
        _dstUser.update(user);
        return true;
    }

    public boolean resetPassword(User _dstUser, String _sNewPassword) throws WCMException {
        if (_dstUser == null) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label28", "\u65e0\u6548\u7684\u7528\u6237!"));
        }
        User user = this.getLoginUser();
        if (user == null) {
            throw new WCMException(1002, I18NMessage.get(UserMgr.class, "UserMgr.label33", "\u64cd\u4f5c\u6ca1\u6709\u76f8\u5173\u7684\u7528\u6237!"));
        }
        _dstUser.canEdit(user);
        _dstUser.setProperty("PASSWORD", _sNewPassword);
        _dstUser.update(user);
        return true;
    }

    private boolean isNameValid(String _sName) {
        String sInvalid = "\\\"'!@#$%^&*()";
        for (int i = 0; i < sInvalid.length(); ++i) {
            String sChar = sInvalid.substring(i, i + 1);
            if (_sName.indexOf(sChar) == -1) continue;
            return false;
        }
        return true;
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null || !currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label34", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(UserMgr.class, "UserMgr.label35", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return currDBManager;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private String getLoginUserName() {
        User loginUser = this.getLoginUser();
        if (loginUser == null) {
            return "";
        }
        return loginUser.getName();
    }

    public boolean isAdminOfGroup(User _user) throws WCMException {
        if (_user == null) {
            return false;
        }
        String sSql = "SELECT COUNT(*) FROM WCMGRPUSER WHERE IsAdministrator=1 AND UserId=" + _user.getId();
        return DBManager.getDBManager().sqlExecuteIntQuery(sSql) >= 1;
    }

    public boolean isManagerOfRole(User _user) throws WCMException {
        if (_user == null) {
            return false;
        }
        String sSql = "SELECT COUNT(*) FROM WCMROLEUSER WHERE RoleId IN (SELECT RoleId FROM WCMROLE WHERE RoleName='RoleManagers') AND UserId=" + _user.getId();
        return DBManager.getDBManager().sqlExecuteIntQuery(sSql) >= 1;
    }

    public boolean isManagerOfUser(User _user) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        GroupMgr groupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        Groups groups = this.getGroups(_user);
        if (groups == null || groups.isEmpty()) {
            return this.isAdminOfGroup(loginUser);
        }
        for (int i = 0; i < groups.size(); ++i) {
            if (!groupMgr.isAdministrator((Group)groups.getAt(i), loginUser, true)) continue;
            return true;
        }
        return false;
    }

    public Users getCanManagerUsers(User _oUser) throws WCMException {
        if (_oUser == null) {
            return null;
        }
        User loginUser = ContextHelper.getLoginUser();
        Users users = Users.createNewInstance(loginUser);
        GroupMgr groupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        Groups groups = groupMgr.getGroups(_oUser, null);
        for (int i = 0; i < groups.size(); ++i) {
            Group group = (Group)groups.getAt(i);
            users.addWith(groupMgr.getUsers(group, null, true));
        }
        return users;
    }
}

