/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.ajaxservice.xmlconvertors.BaseWCMObjectToXML;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.FlowEngineHelper;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import org.dom4j.Element;

public class FlowDocToXML
extends BaseWCMObjectToXML {
    private static final int FLAG = 1;
    private static final int NODEID = 2;
    private static final int PRENODEID = 3;
    private static final int TOUSERS = 4;
    private static final int TOUSERID = 5;
    private static final int POSTDESC = 6;
    private static final int POSTUSER = 7;

    @Override
    protected String[][] getSpecialElementAttributes(MethodContext context, BaseObj object) {
        return null;
    }

    @Override
    protected String[][] getSpecialProperty(MethodContext _methodContext, BaseObj _currObj, int _nPropertyId, Object _currValue) throws ConvertException {
        FlowDoc flowDoc = (FlowDoc)_currObj;
        switch (_nPropertyId) {
            case 1: {
                return new String[][]{{"Name", flowDoc.getFlagDesc()}, {"Id", String.valueOf(flowDoc.getFlag())}};
            }
            case 2: {
                try {
                    FlowNode currNode = flowDoc.getNode();
                    if (currNode == null) {
                        return null;
                    }
                    return new String[][]{{"Name", currNode.getName()}, {"Id", String.valueOf(currNode.getId())}};
                }
                catch (Exception e) {
                    throw new ConvertException(I18NMessage.get(FlowDocToXML.class, "FlowDocToXML.label1", "\u6784\u9020\u5f53\u524d\u8282\u70b9\u5931\u8d25\uff01"), e);
                }
            }
            case 3: {
                try {
                    FlowNode currNode = flowDoc.getPreNode();
                    if (currNode == null) {
                        return null;
                    }
                    return new String[][]{{"Name", currNode.getName()}, {"Id", String.valueOf(currNode.getId())}};
                }
                catch (Exception e) {
                    throw new ConvertException(I18NMessage.get(FlowDocToXML.class, "FlowDocToXML.label1", "\u6784\u9020\u5f53\u524d\u8282\u70b9\u5931\u8d25\uff01"), e);
                }
            }
            case 4: {
                try {
                    return new String[][]{{flowDoc.getToUserTrueNames()}};
                }
                catch (Exception e) {
                    throw new ConvertException(I18NMessage.get(FlowDocToXML.class, "FlowDocToXML.label2", "\u6784\u9020\u63a5\u53d7\u7528\u6237\u5931\u8d25\uff01"), e);
                }
            }
            case 5: {
                if (flowDoc.getToUserIds() != null && flowDoc.getToUserIds().length() > 0) {
                    return null;
                }
                try {
                    return new String[][]{{flowDoc.getToUserNames()}};
                }
                catch (Exception e) {
                    throw new ConvertException(I18NMessage.get(FlowDocToXML.class, "FlowDocToXML.label2", "\u6784\u9020\u63a5\u53d7\u7528\u6237\u5931\u8d25\uff01"), e);
                }
            }
            case 7: {
                User oPostUser = flowDoc.getPostUser();
                String sUserName = oPostUser.getName();
                String sUserTrueName = oPostUser.getTrueName();
                if (sUserTrueName != null && !"".equals(sUserTrueName)) {
                    sUserName = sUserTrueName;
                }
                return new String[][]{{sUserName}};
            }
            case 6: {
                StringBuffer sbResult = new StringBuffer(_currValue.toString().length());
                String[] pComments = FlowEngineHelper.parseComments(flowDoc);
                if (pComments != null) {
                    for (int i = 0; i < pComments.length; ++i) {
                        sbResult.append(pComments[i]);
                        sbResult.append(":\n");
                        sbResult.append(pComments[++i]);
                        sbResult.append("\n");
                    }
                }
                return new String[][]{{sbResult.toString()}};
            }
        }
        return null;
    }

    @Override
    protected String[][] getSpecialRootAttributes(MethodContext context, BaseObjs objects) {
        return null;
    }

    @Override
    protected String[][] getSpecialRootAttributes(MethodContext context, BaseObj object) {
        return null;
    }

    @Override
    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("Flag", 1);
        this.registerHostSpecialProperty("NodeId", 2, "Node");
        this.registerHostSpecialProperty("PreNodeId", 3, "PreNode");
        this.registerHostSpecialProperty("ToUsers", 4);
        this.registerHostSpecialProperty("PostDesc", 6);
        this.registerHostSpecialProperty("ToUserId", 5, "ToUsers");
        this.registerHostSpecialProperty("Postuser", 7);
    }

    @Override
    public String[] registerTargetClassName() {
        return new String[]{FlowDoc.class.getName(), FlowDocs.class.getName()};
    }

    @Override
    protected Element makeElementFromBaseObj(MethodContext _methodContext, String _sTagName, BaseObj _baseObj, boolean _bLoadText, String[] _pSelectFields) throws ConvertException {
        FlowDoc currFlowDoc = (FlowDoc)_baseObj;
        Element elBaseObj = super.makeElementFromBaseObj(_methodContext, _sTagName, _baseObj, _bLoadText, _pSelectFields);
        Element elComments = elBaseObj.addElement("Comments");
        String[] pComments = FlowEngineHelper.parseComments(currFlowDoc);
        if (pComments != null) {
            for (int i = 0; i < pComments.length; ++i) {
                Element elComment = elComments.addElement("Comment");
                elComment.addElement("User").addCDATA(pComments[i]);
                elComment.addElement("Content").addCDATA(pComments[++i]);
            }
        }
        return elBaseObj;
    }
}

