/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.ajaxservice.WCMDocumentHelper;
import com.trs.ajaxservice.xmlconvertors.BaseWCMObjectToXML;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.DocBaks;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import org.apache.log4j.Logger;

public class DocumentToXML
extends BaseWCMObjectToXML {
    private static Logger logger = Logger.getLogger(DocumentToXML.class);
    private static final int DOCCHANNEL = 1;
    private static final int DOCSTATUS = 2;
    private static final int DOCHTMLCON = 3;
    private static final int DOCTYPE = 4;
    private static final int DOCSOURCE = 5;
    private static final int OPERUSER = 6;
    private static final int OPERTIME = 7;
    private static final int DOCVERSION = 8;

    @Override
    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("DOCCHANNEL", 1);
        this.registerHostSpecialProperty("DOCSTATUS", 2);
        this.registerHostSpecialProperty("DOCHTMLCON", 3);
        this.registerHostSpecialProperty("DOCTYPE", 4);
        this.registerHostSpecialProperty("DOCSOURCE", 5);
        this.registerHostSpecialProperty("OPERUSER", 6);
        this.registerHostSpecialProperty("OPERTIME", 7);
        this.registerHostSpecialProperty("DOCVERSION", 8);
    }

    @Override
    protected String[][] getSpecialProperty(MethodContext _methodContext, BaseObj _currObj, int _nPropertyId, Object _currValue) throws ConvertException {
        Document document = (Document)_currObj;
        try {
            switch (_nPropertyId) {
                case 1: {
                    return this.makeChannelValue(_currValue);
                }
                case 2: {
                    int nCurrChannelId = _methodContext.getValue("ChannelId", 0);
                    return this.makeStatus(_currValue, document, nCurrChannelId);
                }
                case 6: {
                    int nCurrChannelId = _methodContext.getValue("ChannelId", 0);
                    return this.makeOperUser(_currValue, document, nCurrChannelId);
                }
                case 7: {
                    int nCurrChannelId = _methodContext.getValue("ChannelId", 0);
                    return this.makeOperTime(_methodContext, _currValue, document, nCurrChannelId);
                }
                case 3: {
                    return this.makeHTMLCon(document);
                }
                case 4: {
                    return new String[][]{{"Type", _currValue.toString()}, {"Name", document.getTypeString()}};
                }
                case 5: {
                    return this.makeDocSource(_currValue, document);
                }
                case 8: {
                    int nVersion = 1;
                    if (_currValue != null) {
                        nVersion = ((Number)_currValue).intValue() + 1;
                    }
                    return new String[][]{{String.valueOf(nVersion)}};
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)(I18NMessage.get(DocumentToXML.class, "DocumentToXML.label1", "\u8f6c\u6362\u5bf9\u8c61[") + _currObj + I18NMessage.get(DocumentToXML.class, "DocumentToXML.label2", "]\u6570\u636e[") + _nPropertyId + I18NMessage.get(DocumentToXML.class, "DocumentToXML.label3", "]\u5931\u8d25\uff01")), (Throwable)e);
            throw new ConvertException(I18NMessage.get(DocumentToXML.class, "DocumentToXML.label4", "\u8f6c\u6362\u6570\u636e[") + _nPropertyId + I18NMessage.get(DocumentToXML.class, "DocumentToXML.label3", "]\u5931\u8d25\uff01"), e);
        }
        return null;
    }

    private String[][] makeDocSource(Object _currValue, Document _document) throws WCMException {
        String sValue = "";
        Source source = _document.getSource();
        if (source != null) {
            sValue = source.getName();
        }
        return new String[][]{{"Id", _currValue.toString()}, {"Name", sValue}};
    }

    private String[][] makeHTMLCon(Document _document) throws WCMException {
        switch (_document.getType()) {
            case 20: {
                return new String[][]{{_document.getHtmlContentWithImgFilter(null, false)}};
            }
            case 10: {
                return new String[][]{{CMyString.transDisplay(_document.getContent(), false)}};
            }
            case 40: {
                return new String[][]{{I18NMessage.get(DocumentToXML.class, "DocumentToXML.label5", "\u5916\u90e8\u6587\u4ef6")}};
            }
            case 30: {
                return new String[][]{{I18NMessage.get(DocumentToXML.class, "DocumentToXML.label6", "\u94fe\u63a5\u6587\u6863")}};
            }
        }
        return new String[][]{{I18NMessage.get(DocumentToXML.class, "DocumentToXML.label7", "\u672a\u77e5\u7c7b\u578b\u6587\u6863[Type=") + _document.getType() + "]"}};
    }

    private String[][] makeStatus(Object _currValue, Document _currDocument, int _nCurrChannelId) throws WCMException {
        ChnlDoc chnlDoc;
        Status status = null;
        status = _nCurrChannelId == 0 || _currDocument.getChannelId() == _nCurrChannelId ? Status.findById(((Long)_currValue).intValue()) : ((chnlDoc = this.findChnlDoc(_currDocument, _nCurrChannelId)) != null ? chnlDoc.getStatus() : Status.findById(((Long)_currValue).intValue()));
        if (status == null) {
            return new String[][]{{"ID", "0"}, {"NAME", I18NMessage.get(DocumentToXML.class, "DocumentToXML.label8", "\u672a\u77e5")}};
        }
        return new String[][]{{"ID", status.getKey().toString()}, {"NAME", status.getDisp()}};
    }

    private String[][] makeOperUser(Object _currValue, Document _currDocument, int _nCurrChannelId) throws WCMException {
        ChnlDoc chnlDoc;
        String sOperUser = _nCurrChannelId == 0 || _currDocument.getChannelId() == _nCurrChannelId ? (_currValue == null ? "" : _currValue.toString()) : ((chnlDoc = this.findChnlDoc(_currDocument, _nCurrChannelId)) != null ? chnlDoc.getOperUserName() : (_currValue == null ? "" : _currValue.toString()));
        return new String[][]{{sOperUser}};
    }

    private String[][] makeOperTime(MethodContext _methodContext, Object _currValue, Document _currDocument, int _nCurrChannelId) throws WCMException {
        ChnlDoc chnlDoc;
        CMyDateTime dtOperTime = _nCurrChannelId == 0 || _currDocument.getChannelId() == _nCurrChannelId ? (CMyDateTime)_currValue : ((chnlDoc = this.findChnlDoc(_currDocument, _nCurrChannelId)) != null ? chnlDoc.getOperTime() : (CMyDateTime)_currValue);
        String sOperTime = dtOperTime != null && !dtOperTime.isNull() ? this.convertDateTimeValueToString(_methodContext, dtOperTime) : "";
        return new String[][]{{sOperTime}};
    }

    private ChnlDoc findChnlDoc(Document _currDocument, int _nCurrChannelId) throws WCMException {
        Object value = _currDocument.getProperty("ChnlDoc");
        if (value == null) {
            ChnlDoc chnlDoc = ChnlDoc.findByDocAndChnl(_currDocument.getId(), _nCurrChannelId);
            if (chnlDoc != null) {
                _currDocument.setProperty("ChnlDoc", chnlDoc, false);
            } else {
                _currDocument.setProperty("ChnlDoc", new NullValue(0), false);
            }
            return chnlDoc;
        }
        if (value instanceof ChnlDoc) {
            return (ChnlDoc)value;
        }
        return null;
    }

    private String[][] makeChannelValue(Object _currValue) throws WCMException {
        Channel channel = Channel.findById(Math.abs(((Long)_currValue).intValue()));
        if (channel == null) {
            return new String[][]{{"ID", "0"}, {"NAME", I18NMessage.get(DocumentToXML.class, "DocumentToXML.label8", "\u672a\u77e5")}, {"RIGHTVALUE", "0"}, {"CHANNELTYPE", "0"}};
        }
        String rightValue = "";
        User loginUser = ContextHelper.getLoginUser();
        rightValue = loginUser.isAdministrator() || loginUser.equals(channel.getCrUser()) ? RightValue.getAdministratorValues() : AuthServer.getRightValue((CMSObj)channel, loginUser).toString();
        return new String[][]{{"ID", channel.getKey().toString()}, {"NAME", channel.getDispDesc()}, {"RIGHTVALUE", rightValue}, {"CHANNELTYPE", String.valueOf(channel.getType())}};
    }

    @Override
    public String[] registerTargetClassName() {
        return new String[]{Documents.class.getName(), Document.class.getName(), DocBaks.class.getName()};
    }

    @Override
    protected String[][] getSpecialRootAttributes(MethodContext context, BaseObjs objects) {
        return null;
    }

    @Override
    protected String[][] getSpecialRootAttributes(MethodContext context, BaseObj object) throws ConvertException {
        try {
            return new String[][]{{"CanEdit", String.valueOf(AuthServer.hasRight(ContextHelper.getLoginUser(), (CMSObj)((Document)object), 32))}};
        }
        catch (WCMException e) {
            throw new ConvertException(I18NMessage.get(DocumentToXML.class, "DocumentToXML.label9", "\u6784\u9020\u6587\u6863\u6839\u8282\u70b9\u5c5e\u6027\u5931\u8d25\uff01"), e);
        }
    }

    @Override
    protected String[][] getSpecialElementAttributes(MethodContext _methodContext, BaseObj object) throws ConvertException {
        Document document = (Document)object;
        String[] sRightInfo = null;
        if (_methodContext.getValue("ContainsRight", false)) {
            try {
                User loginUser = ContextHelper.getLoginUser();
                Channel currChannel = this.makeCurrChannel(_methodContext);
                String sRightValue = WCMDocumentHelper.makeRightValue(_methodContext, loginUser, currChannel, document);
                sRightInfo = new String[]{"Right", sRightValue};
            }
            catch (Exception e) {
                System.out.println(_methodContext.getValues());
                throw new ConvertException(I18NMessage.get(DocumentToXML.class, "DocumentToXML.label10", "\u6784\u9020[") + document + I18NMessage.get(DocumentToXML.class, "DocumentToXML.label11", "]\u6743\u9650\u4fe1\u606f\u5931\u8d25!"), e);
            }
        }
        int nCurrChannelId = _methodContext.getValue("ChannelId", 0);
        ChnlDoc chnlDoc = null;
        String[] sTopedInfo = null;
        try {
            chnlDoc = this.findChnlDoc(document, nCurrChannelId);
            if (chnlDoc != null) {
                sTopedInfo = new String[]{"Topped", String.valueOf(chnlDoc.isTopped())};
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new String[][]{sTopedInfo, sRightInfo};
    }

    private Channel makeCurrChannel(MethodContext _methodContext) throws WCMException {
        String sKey = "CurrChannel";
        Channel currChannel = (Channel)_methodContext.getContextCacheData(sKey);
        if (currChannel != null) {
            return currChannel;
        }
        int nCurrChannelId = _methodContext.getValue("ChannelId", 0);
        if (nCurrChannelId <= 0) {
            return null;
        }
        currChannel = Channel.findById(nCurrChannelId);
        _methodContext.putContextCacheData(sKey, currChannel);
        return currChannel;
    }
}

