/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.JSONHelper;
import com.trs.ajaxservice.PageOperatorsForServiceHelper;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.WebSiteHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.wcm.MyPlugin;
import com.trs.components.wcm.channel.IVChannelParser;
import com.trs.components.wcm.channel.VChannel;
import com.trs.components.wcm.channel.VChannelManager;
import com.trs.components.wcm.content.domain.ChannelExporter;
import com.trs.components.wcm.content.domain.ChannelImporter;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.domain.intelligence.IIntellMgr;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import com.trs.infra.util.Reports;
import com.trs.presentation.plugin.PluginConfig;
import com.trs.wcm.config.PageOperators;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class WebSiteServiceProvider
implements IGlueServiceProvider {
    private ChannelMgr m_oChannelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");

    @Override
    public void delete(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        WebSites sites = WebSites.findByIds(loginUser, _methContext.getObjectIds());
        boolean bDrop = _methContext.getValue("Drop", false);
        int nRightIndex = 2;
        if (!AuthServer.hasRightInObjects(loginUser, sites, nRightIndex)) {
            throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label1", "\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u8fd9\u4e9b\u680f\u76ee[ID=") + sites.getIdListAsString() + "].");
        }
        int nSize = sites.size();
        for (int i = 0; i < nSize; ++i) {
            WebSite channel = (WebSite)sites.getAt(i);
            if (channel == null) continue;
            this.m_oChannelMgr.delete(channel, bDrop);
        }
    }

    @Override
    public Object query(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nSiteType = _methContext.getValue("SiteType", 0);
        int nSiblingSiteId = _methContext.getValue("SiblingSiteId", 0);
        if (nSiblingSiteId > 0) {
            WebSite site = this.findSiteById(nSiblingSiteId);
            nSiteType = site.getPropertyAsInt("SiteType", 0);
        }
        this.validatePluginRight(nSiteType);
        WCMFilter queryFilter = _methContext.getExtraWCMFilter();
        boolean forIndividual = _methContext.getValue("forIndividual", true);
        HttpServletRequest request = _methContext.getServiceContext().getRequest();
        Hashtable customSiteIdHt = request != null ? (Hashtable)request.getSession().getAttribute("customSite") : new Hashtable();
        return WebSiteHelper.getWebSitesByTypeWithIndividual(loginUser, nSiteType, queryFilter, customSiteIdHt, forIndividual);
    }

    private void validatePluginRight(int _nSiteType) throws Exception {
        switch (_nSiteType) {
            case 1: {
                if (PluginConfig.isStartPhoto()) break;
                throw new Exception(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label2", "\u60a8\u6ca1\u6709\u8d2d\u4e70\u56fe\u7247\u9009\u4ef6\uff01"));
            }
            case 2: {
                if (PluginConfig.isStartVideo()) break;
                throw new Exception(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label2", "\u60a8\u6ca1\u6709\u8d2d\u4e70\u56fe\u7247\u9009\u4ef6\uff01"));
            }
            case 4: {
                CMyBitsValue bitsValue = new CMyBitsValue(MyPlugin.getPluginCode());
                if (bitsValue.getBit(2)) break;
                throw new Exception(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label3", "\u60a8\u6ca1\u6709\u8d2d\u4e70\u5143\u6570\u636e\u7ba1\u7406\u9009\u4ef6\uff01"));
            }
        }
    }

    @Override
    public int save(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        WebSite site = null;
        int nObjectId = _methodContext.getObjectId();
        if (nObjectId == 0) {
            site = new WebSite();
            if (!loginUser.isAdministrator()) {
                throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label4", "\u60a8\u4e0d\u662f\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u521b\u5efa\u7ad9\u70b9\uff01"));
            }
        } else {
            site = WebSite.findById(nObjectId);
            if (site == null) {
                throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label5", "\u6307\u5b9a\u7684\u7ad9\u70b9\u4e0d\u5b58\u5728![ObjectId=") + _methodContext.getObjectId() + "]");
            }
            int nRightIndex = 1;
            if (!AuthServer.hasRight(loginUser, (CMSObj)site, nRightIndex)) {
                throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label6", "\u60a8\u6ca1\u6709\u4fee\u6539\u7ad9\u70b9![") + site + "]");
            }
            site.validCanEditAndLock(loginUser);
        }
        String[] pLogicFields = new String[]{"ObjectId"};
        site = (WebSite)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, site, pLogicFields);
        this.validatePluginRight(site.getType());
        this.m_oChannelMgr.save(site);
        return site.getId();
    }

    @Override
    public Object findById(MethodContext _context) throws Throwable {
        User loginUser = this.getLoginUser();
        if (_context.getObjectId() == 0) {
            WebSite site = new WebSite();
            return site;
        }
        WebSite webSite = WebSite.findById(_context.getObjectId());
        if (webSite == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(_context.getObjectId()), WCMTypes.getLowerObjName(103)}));
        }
        int nRightIndex = 64;
        if (!AuthServer.hasRight(loginUser, (CMSObj)webSite, nRightIndex)) {
            throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label21", "\u60a8[") + loginUser.getName() + I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label32", "]\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u7ad9\u70b9[Id=") + webSite.getId() + "]!");
        }
        return webSite;
    }

    @Override
    public Object findByIds(MethodContext _context) throws Throwable {
        return WebSites.findByIds(this.getLoginUser(), _context.getObjectIds());
    }

    public PageOperators getOperators(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nObjectId = _methContext.getObjectId();
        if (nObjectId > 0) {
            WebSite website = this.findSiteById(nObjectId);
            return PageOperatorsForServiceHelper.makeCMSObjOpertators(loginUser, "website", website);
        }
        String sObjectIds = _methContext.getObjectIds();
        if (sObjectIds != null && sObjectIds.length() > 0) {
            WebSites websites = WebSites.findByIds(loginUser, sObjectIds);
            if (websites.isEmpty()) {
                throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label7", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7ad9\u70b9[ObjectIds=") + sObjectIds + "].");
            }
            if (websites.size() == 1) {
                return PageOperatorsForServiceHelper.makeCMSObjOpertators(loginUser, "website", (CMSObj)websites.getAt(0));
            }
            return PageOperatorsForServiceHelper.makeCMSBaseObjsOpertators(loginUser, "websites", websites);
        }
        throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label8", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u83b7\u53d6\u65b9\u5f0f\uff01"));
    }

    public PageOperators getDocumentOperators(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nObjectId = _methContext.getObjectId();
        if (nObjectId > 0) {
            WebSite website = this.findSiteById(nObjectId);
            return PageOperatorsForServiceHelper.makeCMSObjOpertators(loginUser, "documentInWebsite", website);
        }
        throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label8", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u83b7\u53d6\u65b9\u5f0f\uff01"));
    }

    public PageOperators getOperatorsInSite(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nObjectId = _methContext.getObjectId();
        if (nObjectId > 0) {
            WebSite site = this.findSiteById(nObjectId);
            return PageOperatorsForServiceHelper.makeCMSObjOpertators(loginUser, "WebSiteHost", site);
        }
        throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label8", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u83b7\u53d6\u65b9\u5f0f\uff01"));
    }

    public PageOperators getOperatorsInSiteRoot() throws Throwable {
        User loginUser = this.getLoginUser();
        if (!loginUser.isAdministrator()) {
            return new PageOperators(null);
        }
        return PageOperatorsForServiceHelper.makeCMSObjOpertators(loginUser, "WebSiteRoot", null);
    }

    public String findSiteTypeDesc(MethodContext _MethodContext2) throws Throwable {
        User loginUser = this.getLoginUser();
        HashMap<String, String> hmValues = new HashMap<String, String>(2);
        String sRight = null;
        sRight = loginUser.isAdministrator() ? RightValue.getAdministratorValues() : "0";
        hmValues.put("right", sRight);
        hmValues.put("desc", WebSiteServiceProvider.findSiteTypeDesc(_MethodContext2.getObjectId()));
        _MethodContext2.setReturnJSON(true);
        return "{\nWEBSITEROOT:" + JSONHelper.toSimpleJSON(hmValues, 1) + "\n}";
    }

    public static String findSiteTypeDesc(int _nSiteType) throws Throwable {
        switch (_nSiteType) {
            case 0: {
                return I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label9", "\u6587\u5b57\u5e93");
            }
            case 1: {
                return I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label10", "\u56fe\u7247\u5e93");
            }
            case 2: {
                return I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label11", "\u89c6\u9891\u5e93");
            }
            case 4: {
                return I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label12", "\u8d44\u6e90\u5e93");
            }
        }
        return I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label9", "\u6587\u5b57\u5e93");
    }

    public String export(MethodContext _MethodContext2) throws Throwable {
        User loginUser = this.getLoginUser();
        WebSites sites = WebSites.findByIds(loginUser, _MethodContext2.getObjectIds());
        boolean bContainsChildren = _MethodContext2.getValue("ContainsChildren", true);
        boolean bContainsRelated = _MethodContext2.getValue("ContainsRelated", true);
        this.removeNoRightSite(loginUser, sites, 1);
        ChannelExporter exporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
        _MethodContext2.setContentTypeIsHTML();
        return exporter.export(sites, bContainsChildren, bContainsRelated);
    }

    public String importSites(MethodContext _MethodContext2) throws Throwable {
        User loginUser = this.getLoginUser();
        String sImportFile = _MethodContext2.getValue("ImportFile");
        WCMAJAXServiceHelper.validateFile(sImportFile);
        String sImportXSLFile = _MethodContext2.getValue("ImportXSLFile");
        WCMAJAXServiceHelper.validateFile(sImportXSLFile);
        if (!loginUser.isAdministrator()) {
            throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + loginUser.getName() + I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label14", "]\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u5bfc\u5165\u7ad9\u70b9\uff01"));
        }
        ChannelImporter importer = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
        try {
            return importer.importFromFile(sImportFile, sImportXSLFile, null).toJSONXML();
        }
        catch (WCMException e) {
            throw new WCMException(1100, I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label15", "\u5bfc\u5165\u7ad9\u70b9\u5931\u8d25!"), e);
        }
    }

    public String createFrom(MethodContext _MethodContext2) throws Throwable {
        User loginUser = this.getLoginUser();
        int nSrcSiteId = _MethodContext2.getValue("SrcSiteId", 0);
        boolean ContainsRelated = _MethodContext2.getValue("ContainsRelated", true);
        WebSite srcSite = this.findSiteById(nSrcSiteId);
        if (!loginUser.isAdministrator()) {
            throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + loginUser.getName() + I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label16", "]\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u521b\u5efa\u7ad9\u70b9\uff01"));
        }
        ChannelExporter exporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
        ChannelImporter importer = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
        Reports reports = new Reports("");
        try {
            String sXmlFile = exporter.export(srcSite, true, ContainsRelated);
            reports = importer.importFromFile(sXmlFile, null, null);
            reports.setTitle(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label17", "\u7c7b\u4f3c\u521b\u5efa\u7ad9\u70b9"));
            int[] aSiteIds = reports.getResultIds();
            Report report = null;
            List result = reports.getSucessedReporter();
            if (!result.isEmpty()) {
                report = (Report)result.get(0);
                report.setRportTitle(CMyString.format(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label18", "\u6210\u529f\u521b\u5efa\u7ad9\u70b9[{0}]!"), new Object[]{WebSite.findById(aSiteIds[0])}));
            } else {
                report = reports.getFailedReporterAt(0);
                report.setRportTitle(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label19", "\u521b\u5efa\u7ad9\u70b9\u5931\u8d25!"));
            }
            return reports.toJSONXML();
        }
        catch (WCMException e) {
            throw new WCMException(1100, I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label20", "\u7c7b\u4f3c\u521b\u5efa\u680f\u76ee\u5931\u8d25!"), e);
        }
    }

    public int autoCreate(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sSiteKind = _methodContext.getValue("SiteKind");
        String sSiteStyle = _methodContext.getValue("SiteStyle");
        String sSiteName = _methodContext.getValue("SiteName");
        String sSiteDesc = _methodContext.getValue("SiteDesc");
        if (!loginUser.isAdministrator()) {
            throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label21", "\u60a8[") + loginUser.getName() + I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label22", "]\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u521b\u5efa\u7ad9\u70b9\uff01"));
        }
        IIntellMgr intellMgr = (IIntellMgr)DreamFactory.createObjectById("IIntellMgr");
        Reports currReports = intellMgr.createNewSiteFrom(sSiteKind, sSiteStyle, sSiteName, sSiteDesc);
        int[] arIds = currReports.getResultIds();
        if (arIds == null || arIds.length == 0) {
            throw new Error(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label23", "\u65b0\u5efa\u7ad9\u70b9\u8d85\u51fa\u5f53\u524d\u6ce8\u518c\u7801\u9650\u5236\uff0c\u5982\u9700\u589e\u52a0\uff0c\u8bf7\u4e0eTRS\u516c\u53f8\u8054\u7cfb\uff0c\u611f\u8c22\u60a8\u4f7f\u7528TRS\u4ea7\u54c1\uff01"));
        }
        return arIds[0];
    }

    public void changeOrder(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nSrcSiteId = _methodContext.getValue("SrcSiteId", 0);
        WebSite srcSite = this.findSiteById(nSrcSiteId);
        int nDstSiteId = _methodContext.getValue("DstSiteId", 0);
        WebSite dstSite = null;
        if (nDstSiteId > 0) {
            dstSite = this.findSiteById(nDstSiteId);
        }
        if (!AuthServer.hasRight(loginUser, (CMSObj)srcSite, 1)) {
            throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + loginUser.getName() + I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label24", "]\u6ca1\u6709\u6743\u9650\u6539\u53d8\u680f\u76ee[") + srcSite.getName() + I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label25", "]\u7684\u987a\u5e8f\uff01"));
        }
        if (!srcSite.canEdit(loginUser)) {
            throw new WCMException(srcSite + I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label26", "\u5df2\u7ecf\u88ab[") + srcSite.getLockerUserName() + I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label27", "]\u9501\u5b9a\uff0c\u60a8\u4e0d\u80fd\u505a\u4efb\u4f55\u79fb\u52a8\u64cd\u4f5c\uff01"));
        }
        int nNewOrder = dstSite == null ? -1 : dstSite.getOrder();
        srcSite.setOrder(nNewOrder);
        this.m_oChannelMgr.save(srcSite);
    }

    public WebSites getRecycleSites(MethodContext _methodContext) throws Throwable {
        int nSiteType;
        User loginUser = this.getLoginUser();
        WCMFilter filter = new WCMFilter(_methodContext.getQueryFilter());
        if (filter == null) {
            filter = new WCMFilter();
        }
        if ((nSiteType = _methodContext.getValue("SiteType", -1)) >= 0) {
            filter.mergeWith(new WCMFilter(null, "SiteType=" + nSiteType, null));
        }
        WebSites sites = this.m_oChannelMgr.getRecycleSites(filter);
        if (loginUser.isAdministrator()) {
            return sites;
        }
        for (int i = sites.size() - 1; i >= 0; --i) {
            WebSite site = (WebSite)sites.getAt(i);
            if (site != null && AuthServer.hasRight(loginUser, (CMSObj)site, 2)) continue;
            sites.removeAt(i, false);
        }
        return sites;
    }

    public void restoreSites(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        boolean bRestoreAll = _methodContext.getValue("RestoreAll", false);
        WebSites sites = null;
        if (bRestoreAll) {
            WCMFilter filter = new WCMFilter(_methodContext.getQueryFilter());
            sites = this.m_oChannelMgr.getRecycleSites(filter);
        } else {
            sites = WebSites.findByIds(loginUser, _methodContext.getObjectIds());
        }
        if (sites.size() == 0) {
            throw new WCMException(200006, I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label29", "\u7ad9\u70b9\u56de\u6536\u7ad9\u4e2d\u6ca1\u6709\u4efb\u4f55\u53ef\u4ee5\u8fd8\u539f\u7684\u7ad9\u70b9\uff01"));
        }
        int nSize = sites.size();
        for (int i = 0; i < nSize; ++i) {
            WebSite site = (WebSite)sites.getAt(i);
            if (site == null || !AuthServer.hasRight(loginUser, (CMSObj)site, 2)) continue;
            this.m_oChannelMgr.restore(site);
        }
    }

    public void clearRecycle() throws Throwable {
        User loginUser = this.getLoginUser();
        WebSites sites = this.m_oChannelMgr.getRecycleSites(null);
        if (sites.size() == 0) {
            throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label30", "\u7ad9\u70b9\u56de\u6536\u7ad9\u4e2d\u6ca1\u6709\u4efb\u4f55\u53ef\u4ee5\u5220\u9664\u7684\u7ad9\u70b9\uff01"));
        }
        int nSize = sites.size();
        for (int i = 0; i < nSize; ++i) {
            WebSite site = (WebSite)sites.getAt(i);
            if (site == null || !AuthServer.hasRight(loginUser, (CMSObj)site, 2)) continue;
            this.m_oChannelMgr.delete(site, true);
        }
    }

    public boolean existsSimilarName(MethodContext _methodContext) throws Throwable {
        WCMFilter existFilter = new WCMFilter("WCMWEBSITE", "SiteName=? and SiteId<>?", "", "SiteId");
        existFilter.addSearchValues(0, _methodContext.getValue("SiteName"));
        existFilter.addSearchValues(1, _methodContext.getObjectId());
        return DBManager.getDBManager().sqlExecuteIntQuery(existFilter) > 0;
    }

    public Object existsSimilarDataPath(MethodContext _methodContext) throws Throwable {
        WCMFilter existFilter = new WCMFilter("WCMWEBSITE", "SiteId<>?and exists(select FolderId from WCMFolderPublishConfig where FolderType=103 and FolderId=WCMWebSite.SiteId and DataPath=?)", "", "SiteId");
        existFilter.addSearchValues(_methodContext.getObjectId());
        existFilter.addSearchValues(_methodContext.getValue("DataPath"));
        int nSiteId = DBManager.getDBManager().sqlExecuteIntQuery(existFilter);
        if (nSiteId > 0) {
            WebSite website = WebSite.findById(nSiteId);
            if (website == null) {
                return "";
            }
            return website.getDesc() + "-" + website.getId();
        }
        return "";
    }

    private WebSite findSiteById(int _nObjectId) throws WCMException {
        WebSite website = WebSite.findById(_nObjectId);
        if (website == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(_nObjectId), WCMTypes.getLowerObjName(103)}));
        }
        return website;
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }

    private void removeNoRightSite(User _loginUser, WebSites _sites, int _nRightIndex) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return;
        }
        for (int i = _sites.size() - 1; i >= 0; --i) {
            WebSite site = (WebSite)_sites.getAt(i);
            if (site == null || AuthServer.hasRight(_loginUser, (CMSObj)site, _nRightIndex)) continue;
            _sites.removeAt(i, false);
        }
    }

    public void createFromFile(MethodContext _methodContext) throws Exception {
        User loginUser = this.getLoginUser();
        if (!loginUser.isAdministrator()) {
            throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label4", "\u60a8\u4e0d\u662f\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u521b\u5efa\u7ad9\u70b9\uff01"));
        }
        int nType = _methodContext.getValue("SiteType", 0);
        this.validatePluginRight(nType);
        String sImportFile = _methodContext.getValue("ImportFile");
        sImportFile = FilesMan.getFilesMan().mapFilePath(sImportFile, 0) + sImportFile;
        WCMSystemObject parent = new WCMSystemObject(nType);
        IVChannelParser parser = (IVChannelParser)DreamFactory.createObjectById("IVChannelParser");
        VChannel vchannel = parser.parse(sImportFile);
        VChannelManager manager = (VChannelManager)DreamFactory.createObjectById("VChannelManager");
        StringBuffer url = _methodContext.getServiceContext().getRequest().getRequestURL();
        String uri = _methodContext.getServiceContext().getRequest().getRequestURI();
        url.replace(url.indexOf(uri), url.length(), "");
        ContextParameters.set1(url.toString());
        manager.save(parent, vchannel);
        ContextParameters.get1();
    }

    public WebSites getSitesForCurrUser(MethodContext _methodContext) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        int nRightIndex = _methodContext.getValue("RightIndex", 7);
        WCMFilter queryFilter = _methodContext.getExtraWCMFilter();
        WCMFilter filter = new WCMFilter("", "Status>=0", "");
        filter.mergeWith(queryFilter);
        boolean forIndividual = _methodContext.getValue("forIndividual", false);
        Hashtable customSiteIdHt = (Hashtable)_methodContext.getServiceContext().getRequest().getSession().getAttribute("customSite");
        return WebSiteHelper.getWebSitesByRightIndex(loginUser, nRightIndex, filter, customSiteIdHt, forIndividual);
    }
}

