/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.ajaxservice.WCMApplyFormProcessServiceHelper;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.ajaxservice.xmlconvertors.XMLToCMSObj;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.definition.Flow;
import com.trs.components.gkml.sqgk.persistent.ApplyForm;
import com.trs.components.gkml.sqgk.persistent.ApplyForms;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.HashMap;
import java.util.Map;

public class ApplyFormServiceProvider
implements ISelfDefinedServiceProvider {
    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public void startDocumentInFlow(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        ApplyForm applyForm = ApplyForm.findById(_methodContext.getObjectId());
        if (applyForm == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u4f9d\u7533\u8bf7\u4e0d\u5b58\u5728![ObjectId=" + _methodContext.getObjectId() + "]");
        }
        if (!AuthServer.hasRight(loginUser, (CMSObj)applyForm, 32)) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u8ba9\u4f9d\u7533\u8bf7[" + applyForm.toString() + "]\u6d41\u8f6c\uff01");
        }
        WCMApplyFormProcessServiceHelper.startApplyFormInFlow(loginUser, applyForm, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAppendixes(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nAppendixType = _methodContext.getValue("AppendixType", 60);
        int nApplyFormId = _methodContext.getValue("ApplyFormId", 0);
        ApplyForm applyForm = ApplyForm.findById(nApplyFormId);
        int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
        if (nFlowDocId > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(loginUser, applyForm, nFlowDocId, 0, "\u4fdd\u5b58\u9644\u4ef6");
        } else if (!AuthServer.hasRight(loginUser, (CMSObj)applyForm, 32)) {
            throw new WCMException(1002, "\u60a8\u4e0d\u80fd\u8fdb\u884c[\u4fdd\u5b58\u9644\u4ef6]\u64cd\u4f5c\uff01");
        }
        XMLToCMSObj xmlToCMSObj = new XMLToCMSObj(loginUser, new Appendix());
        xmlToCMSObj.parse(_methodContext.getValue("AppendixesXML"));
        String sUseingIds = xmlToCMSObj.getObjectIds();
        if (!CMyString.isEmpty(sUseingIds)) {
            DBManager.getDBManager().sqlExecuteUpdate("delete from WCMAppendix where AppDocId=" + -nApplyFormId + " and AppFlag=" + nAppendixType + " and APPENDIXID not in (" + sUseingIds + ")");
        } else {
            DBManager.getDBManager().sqlExecuteUpdate("delete from WCMAppendix where AppDocId=" + -nApplyFormId + " and AppFlag=" + nAppendixType);
        }
        boolean bException = true;
        try {
            int nSize = xmlToCMSObj.getCMSObjs().length;
            for (int i = 0; i < nSize; ++i) {
                Appendix appendix = (Appendix)xmlToCMSObj.getCMSObjs()[i];
                if (appendix == null) continue;
                appendix.setSerialNo(i + 1);
                if (appendix.isAddMode()) {
                    appendix.setFlag(nAppendixType);
                    appendix.setDocId(-nApplyFormId);
                    this.moveAppendixFile(appendix);
                }
                appendix.save();
            }
            bException = false;
        }
        finally {
            if (bException) {
                xmlToCMSObj.cancelUpdate();
            }
        }
    }

    private void moveAppendixFile(Appendix _currAppendix) throws WCMException {
        int nApdFlag = _currAppendix.getFlag();
        String sNewFileName = _currAppendix.getFile();
        if (sNewFileName == null) {
            return;
        }
        if (nApdFlag != 40 && sNewFileName.indexOf(47) < 0) {
            boolean bNotProcessed;
            FilesMan aFilesMan = FilesMan.getFilesMan();
            String sFileFlag = aFilesMan.getFileFlag(sNewFileName);
            boolean bl = bNotProcessed = sFileFlag != "W0" && sFileFlag != "P0";
            if (bNotProcessed) {
                try {
                    sNewFileName = 10 == nApdFlag ? aFilesMan.moveWCMFile(sNewFileName, "P0", false) : aFilesMan.moveWCMFile(sNewFileName, "W0", false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            _currAppendix.setFileExt(CMyFile.extractFileExt(sNewFileName));
            _currAppendix.setFile(CMyFile.extractFileName(sNewFileName));
        }
    }

    public String getFlowingStat(MethodContext _context) throws Throwable {
        try {
            Flow currFlow = WCMApplyFormProcessServiceHelper.getFlow();
            Map hFlowingPath = this.parseFlowingPath(currFlow.getPropertyAsString("OperationMarkEnum"));
            if (hFlowingPath == null || hFlowingPath.isEmpty()) {
                return null;
            }
            this.fillFromRecords(hFlowingPath, _context);
            StringBuffer sb = new StringBuffer();
            for (Map.Entry entry : hFlowingPath.entrySet()) {
                Object key = entry.getKey();
                Integer value = (Integer)entry.getValue();
                if (key == null || value == null) continue;
                String sContent = WCMProcessServiceHelper.makeXMLNode("StageName", key.toString());
                sContent = sContent + WCMProcessServiceHelper.makeXMLNode("StageCounter", String.valueOf(value));
                sb.append(WCMProcessServiceHelper.makeXMLNode("Stage", sContent, false));
            }
            String result = WCMProcessServiceHelper.makeXMLNode("Stages", sb.toString(), false);
            sb.setLength(0);
            return result;
        }
        catch (WCMException ex) {
            return WCMProcessServiceHelper.makeXMLNode("errmsg", ex.getMessage());
        }
    }

    private Map fillFromRecords(Map hRaw, MethodContext _context) throws Throwable {
        ApplyForms applyForms = ApplyForms.createNewInstance(this.getLoginUser());
        applyForms.open(_context.getExtraWCMFilter());
        if (applyForms == null || applyForms.size() <= 0) {
            return null;
        }
        ApplyForm applyForm = null;
        CPager currPager = new CPager(-1);
        int nDataSize = applyForms.size();
        currPager.setItemCount(nDataSize);
        for (int i = currPager.getFirstItemIndex() - 1; i < currPager.getLastItemIndex(); ++i) {
            String opt;
            applyForm = (ApplyForm)applyForms.getAt(i);
            if (applyForm == null || CMyString.isEmpty(opt = applyForm.getPropertyAsString("FLOWOPERATIONMARK"))) continue;
            Integer counter = (Integer)hRaw.get(opt);
            if (counter == null) {
                counter = new Integer(0);
            }
            hRaw.put(opt, new Integer(counter + 1));
        }
        return hRaw;
    }

    public Map parseFlowingPath(String _sPath) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        String sPath = _sPath;
        if (CMyString.isEmpty(sPath)) {
            return result;
        }
        String[] parts = (sPath = sPath.replaceAll("(\\{|\\}|\\[|\\])", "")).split(",");
        if (parts.length <= 2) {
            return result;
        }
        for (int i = 1; i < parts.length - 1; ++i) {
            String sName = parts[i];
            if (CMyString.isEmpty(sName)) continue;
            result.put(sName, null);
        }
        return result;
    }
}

