/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.remoting;

import com.trs.dev4.jdk16.exception.BussinessException;
import com.trs.dev4.jdk16.remoting.IExecutor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class Executor
implements IExecutor,
ApplicationContextAware {
    protected ApplicationContext applicationContext;

    @Override
    public Object service(String beanName, String methodName, Object ... args) {
        Object beanService = this.applicationContext.getBean(beanName);
        if (beanService == null) {
            throw new BussinessException("no bean[" + beanName + "] exsited.");
        }
        Method actionMethod = null;
        try {
            Class<?> clazzService = beanService.getClass();
            Method[] methods = clazzService.getMethods();
            int i = 0;
            while (i < methods.length) {
                Class<?>[] argsTypes;
                Method currMethod = methods[i];
                if (currMethod.getName().equals(methodName) && (argsTypes = currMethod.getParameterTypes()).length == args.length) {
                    boolean isMatched = true;
                    int j = 0;
                    while (j < argsTypes.length) {
                        Class<?> currArgClaz;
                        Class<?> currDefArgClaz;
                        if (!(args[j] == null || (currDefArgClaz = argsTypes[j]).equals(currArgClaz = args[j].getClass()) || currDefArgClaz.isAssignableFrom(currArgClaz) || currDefArgClaz.equals(Integer.TYPE) && currArgClaz.equals(Integer.class) || currDefArgClaz.equals(Double.TYPE) && currArgClaz.equals(Double.class) || currDefArgClaz.equals(Long.TYPE) && currArgClaz.equals(Long.class))) {
                            isMatched = false;
                            break;
                        }
                        ++j;
                    }
                    if (isMatched) {
                        actionMethod = currMethod;
                        break;
                    }
                }
                ++i;
            }
        }
        catch (SecurityException e) {
            throw new BussinessException(e);
        }
        if (actionMethod == null) {
            throw new BussinessException("no public method[" + methodName + "]  in bean[" + beanName + "]");
        }
        try {
            return actionMethod.invoke(beanService, args);
        }
        catch (IllegalArgumentException e) {
            throw new BussinessException(e);
        }
        catch (IllegalAccessException e) {
            throw new BussinessException(e);
        }
        catch (InvocationTargetException e) {
            throw new BussinessException(e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

