/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.model;

import com.trs.dev4.jdk16.exception.BussinessException;
import com.trs.dev4.jdk16.model.Configuration;
import com.trs.dev4.jdk16.utils.AssertUtil;
import com.trs.dev4.jdk16.utils.ObjectUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GroupedConfiguration {
    private List<Configuration> listConfigs;
    private String prefix;

    public GroupedConfiguration(List<Configuration> listConfigs) {
        this.assertValid(listConfigs);
        this.listConfigs = listConfigs;
        this.prefix = listConfigs.get(0).getPrefix();
    }

    private void assertValid(List<Configuration> listConfigs) {
        AssertUtil.notNullOrEmpty(listConfigs, "\u5206\u7ec4\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a.");
        HashSet<String> prefixs = new HashSet<String>();
        for (Configuration configuration : listConfigs) {
            prefixs.add(configuration.getPrefix());
        }
        if (prefixs.size() != 1) {
            throw new BussinessException("\u914d\u7f6e\u524d\u7f00\u4e0d\u552f\u4e00: " + prefixs + ".");
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public List<Configuration> getListConfigs() {
        return this.listConfigs;
    }

    public Map<String, Configuration> getMapConfigs() {
        HashMap<String, Configuration> resultMap = new HashMap<String, Configuration>();
        for (Configuration configuration : this.listConfigs) {
            if (!ObjectUtil.equals(configuration.getPrefix(), this.prefix)) continue;
            resultMap.put(configuration.getName(), configuration);
        }
        return resultMap;
    }
}

