/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.dao;

import com.trs.dev4.jdk16.dao.GroupByResult;
import java.io.Serializable;
import java.util.List;

public class PagedList<T>
implements Serializable {
    private static final long serialVersionUID = -6670794331035414475L;
    private List<T> pageItems;
    private int pageIndex;
    private int pageSize;
    private int totalItemCount;
    private int thisPageTotal;
    private int pageTotal;
    private int prevPage;
    private int nextPage;
    private int step;
    private int startPage;
    private int endPage;
    private GroupByResult groupByResult;

    public PagedList(List<T> pageItems, int totalItemCount) {
        this(pageItems, 0, 20, totalItemCount);
    }

    public PagedList(List<T> pageItems, int pageIndex, int pageSize, int totalItemCount) {
        this(pageIndex, pageSize, totalItemCount, pageItems, 10);
    }

    @Deprecated
    public PagedList() {
    }

    public PagedList(List<T> pageItems) {
        this.pageIndex = 0;
        this.pageSize = pageItems.size();
        this.totalItemCount = pageItems.size();
        this.pageItems = pageItems;
        this.thisPageTotal = pageItems.size();
    }

    public PagedList(int pageIndex, int pageSize, int totalItemCount, List<T> pageItems, int step) {
        this.pageIndex = pageIndex < 0 ? 0 : pageIndex;
        this.pageSize = pageSize <= 0 ? 5 : pageSize;
        this.totalItemCount = totalItemCount;
        this.pageItems = pageItems;
        this.thisPageTotal = pageItems == null ? 0 : pageItems.size();
        this.computePageIndex(step);
    }

    public PagedList(int pageIndex, int pageSize, int totalItemCount, List<T> pageItems, int step, GroupByResult groupByResult) {
        this(pageIndex, pageSize, totalItemCount, pageItems, step);
        this.groupByResult = groupByResult;
    }

    public PagedList(int pageIndex, int pageSize, int totalItemCount, List<T> pageItems, GroupByResult groupByResult) {
        this(pageIndex, pageSize, totalItemCount, pageItems, 10);
        this.groupByResult = groupByResult;
    }

    private void computePageIndex(int stepValue) {
        this.pageTotal = this.totalItemCount <= 0 ? 0 : this.totalItemCount / this.pageSize + (this.totalItemCount % this.pageSize == 0 ? 0 : 1);
        this.prevPage = this.pageIndex == 0 ? 0 : this.pageIndex - 1;
        this.nextPage = this.pageIndex >= this.pageTotal - 1 ? this.pageTotal - 1 : this.pageIndex + 1;
        this.step = stepValue;
        this.startPage = this.pageIndex / this.step * this.step;
        this.endPage = this.startPage + this.step >= this.pageTotal ? this.pageTotal - 1 : this.startPage + this.step;
    }

    public T get(int index) {
        return this.pageItems.get(index);
    }

    public List<T> getPageItems() {
        return this.pageItems;
    }

    public int getTotalItemCount() {
        return this.totalItemCount;
    }

    public int getTotalPageCount() {
        return this.getPageTotal();
    }

    public int getPageTotal() {
        return this.pageTotal;
    }

    public int getFirstPageNo() {
        return 0;
    }

    public int getLastPageNo() {
        return this.pageTotal - 1;
    }

    public boolean isFirstPage() {
        return this.isFirstPage(this.getPageIndex());
    }

    public boolean isLastPage() {
        return this.isLastPage(this.getPageIndex());
    }

    public boolean isFirstPage(int page) {
        return page <= 0;
    }

    public boolean isLastPage(int page) {
        return page >= this.getTotalPageCount() - 1;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getThisPageTotal() {
        return this.thisPageTotal;
    }

    public int getStep() {
        return this.step;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public int getPrevPage() {
        return this.prevPage;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PagedList [pageIndex=").append(this.pageIndex);
        builder.append(", total=").append(this.totalItemCount);
        builder.append(", thisPageTotal=").append(this.thisPageTotal);
        if (this.pageItems != null) {
            builder.append("; pageItems=").append(this.pageItems);
        }
        builder.append("]");
        return builder.toString();
    }

    public GroupByResult getGroupByResult() {
        return this.groupByResult;
    }

    public void setGroupByResult(GroupByResult groupByResult) {
        this.groupByResult = groupByResult;
    }

    public int size() {
        return this.pageItems == null ? 0 : this.pageItems.size();
    }
}

