/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.actionlog.impl;

import com.trs.dev4.jdk16.actionlog.IActionlogExtendable;
import com.trs.dev4.jdk16.actionlog.IActionlogManager;
import com.trs.dev4.jdk16.actionlog.LogEnums;
import com.trs.dev4.jdk16.actionlog.impl.Actionlog;
import com.trs.dev4.jdk16.dao.SearchFilter;
import com.trs.dev4.jdk16.model.BaseEntity;
import com.trs.dev4.jdk16.model.BaseManager;
import com.trs.dev4.jdk16.model.IEntity;
import com.trs.dev4.jdk16.session.ISessionUser;
import com.trs.dev4.jdk16.session.RequestContext;
import com.trs.dev4.jdk16.session.impl.ContextHelper;
import com.trs.dev4.jdk16.utils.ClassUtil;
import com.trs.dev4.jdk16.utils.DateUtil;
import org.apache.log4j.Logger;

public class LocalActionlogManager
extends BaseManager<Actionlog>
implements IActionlogManager {
    private static final Logger logger = Logger.getLogger(LocalActionlogManager.class);
    private String sysFlag;

    @Override
    public void archive(SearchFilter searchfilter) {
    }

    @Override
    public void saveOrUpdate(Actionlog log) {
        if (log.getResult() == LogEnums.Result.FAIL) {
            log.setOperDesc(String.valueOf(log.getOperType()) + ".errorlog");
        } else {
            log.setOperDesc(String.valueOf(log.getOperType()) + ".log");
        }
        super.update(log);
    }

    @Override
    public Actionlog createActionlog(IEntity ientity, String operType, LogEnums.Result result, long startTime, long spentTime) {
        ISessionUser sessionUser = ContextHelper.getLoginUser();
        Actionlog actionlog = new Actionlog();
        actionlog.setResult(result);
        actionlog.isScored();
        actionlog.setLogLevel(LogEnums.Level.INFO);
        actionlog.setOperType((Object)((Object)LogEnums.LabelPrefix.OPERTYPE) + operType);
        actionlog.setOperDesc((Object)((Object)LogEnums.LabelPrefix.OPERDESC) + operType);
        actionlog.setObjId(ientity.getId());
        if (sessionUser != null) {
            actionlog.setOperUserId(sessionUser.getId());
            actionlog.setOperUserName(sessionUser.getUserName());
        }
        actionlog.setObjType((Object)((Object)LogEnums.LabelPrefix.OBJTYPE) + ClassUtil.getSimpleName(ientity).toLowerCase());
        actionlog.setStartTime(startTime);
        actionlog.setSpentTime(spentTime);
        actionlog.setSysFlag(this.sysFlag);
        return actionlog;
    }

    @Override
    public void update(Actionlog actionlog) {
        this.saveOrUpdate(actionlog);
    }

    @Override
    public void setSysFlag(String s) {
        this.sysFlag = s;
    }

    @Override
    public Actionlog createActionlog(Object operator, Object object, String operType, LogEnums.Result result, long startTime, long spentTime, String applicationKey) {
        if (applicationKey == null) {
            applicationKey = this.sysFlag;
        }
        Actionlog actionlog = new Actionlog();
        if (ISessionUser.class.isInstance(operator)) {
            ISessionUser sessionUser = (ISessionUser)operator;
            if (operator == null) {
                sessionUser = ContextHelper.getLoginUser();
                logger.info((Object)("Try get sessionUser(" + operator + ") from ContextHelper."));
            }
            if (sessionUser != null) {
                actionlog.setRemoteAddr(sessionUser.getLoginedIP());
                actionlog.setOperUserId(sessionUser.getId());
                actionlog.setOperUserName(sessionUser.getUserName());
                actionlog.setCreatedTime(DateUtil.getCurrentTimeMillis());
                actionlog.setCreatedUser(sessionUser.getUserName());
                actionlog.setCreatedUserId(sessionUser.getId());
            }
        } else if (RequestContext.class.isInstance(operator)) {
            RequestContext requestContext = (RequestContext)operator;
            actionlog.setRemoteAddr(requestContext.getClientIP());
            actionlog.setOperUserId(requestContext.getUserId());
            actionlog.setOperUserName(requestContext.getUserName());
            actionlog.setCreatedTime(DateUtil.getCurrentTimeMillis());
            actionlog.setCreatedUser(requestContext.getUserName());
            actionlog.setCreatedUserId(requestContext.getUserId());
            actionlog.setUserAgent(requestContext.getUserAgent());
            actionlog.setProxyIPs(requestContext.getProxyIPs());
            actionlog.setCallerStackBrief(requestContext.getCallerStackBrief());
            applicationKey = requestContext.getSysFlag();
        } else {
            logger.debug((Object)("Operator(" + operator + ") isn't ISessionUser instance."));
            actionlog.setRemoteAddr("(localhost)");
            actionlog.setOperUserId(-2);
            actionlog.setOperUserName(operator.toString());
            actionlog.setCreatedUser(operator.toString());
            actionlog.setCreatedTime(DateUtil.getCurrentTimeMillis());
            actionlog.setCreatedUserId(-2);
        }
        actionlog.setResult(result);
        actionlog.isScored();
        actionlog.setLogLevel(LogEnums.Level.INFO);
        actionlog.setOperType(String.valueOf(applicationKey) + "." + operType);
        if (IEntity.class.isInstance(object)) {
            IEntity entity = (IEntity)object;
            actionlog.setObjId(entity.getId());
            if (object instanceof BaseEntity) {
                actionlog.setOperTitle(((BaseEntity)object).getDescription());
            } else {
                actionlog.setOperTitle(entity.toString());
            }
            logger.debug((Object)("Object(" + object + ") is IEntity instance."));
        } else {
            actionlog.setOperTitle(object.toString());
            logger.debug((Object)("Object(" + object + ") isn't IEntity instance."));
        }
        if (IActionlogExtendable.class.isInstance(object)) {
            IActionlogExtendable extendable = (IActionlogExtendable)object;
            actionlog.setExtendField1(extendable.getExtend1());
            actionlog.setExtendField2(extendable.getExtend2());
            actionlog.setExtendField3(extendable.getExtend3());
            logger.debug((Object)("Object(" + object + ") is IActionlogExtendable instance,extend1:" + actionlog.getExtendField1() + ",extend2:" + actionlog.getExtendField2() + ",extend3:" + actionlog.getExtendField3()));
        } else {
            logger.debug((Object)("Object(" + object + ") isn't IActionlogExtendable instance."));
        }
        actionlog.setObjType(String.valueOf(applicationKey) + "." + object.getClass().getSimpleName().toLowerCase() + ".objType");
        actionlog.setStartTime(startTime);
        actionlog.setSpentTime(spentTime);
        actionlog.setSysFlag(applicationKey);
        return actionlog;
    }
}

