/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class SimpleMappingExceptionResolver
implements HandlerExceptionResolver,
Ordered {
    public static final String DEFAULT_EXCEPTION_ATTRIBUTE = "exception";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private Map exceptionMappings;
    private String defaultErrorView;
    private List mappedHandlers;
    private String exceptionAttribute = "exception";

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setExceptionMappings(Properties mappings) throws ClassNotFoundException {
        this.exceptionMappings = new HashMap();
        Iterator<Object> it = mappings.keySet().iterator();
        while (it.hasNext()) {
            String exceptionClassName = (String)it.next();
            String viewName = mappings.getProperty(exceptionClassName);
            Class<?> exceptionClass = Class.forName(exceptionClassName, true, Thread.currentThread().getContextClassLoader());
            this.exceptionMappings.put(exceptionClass, viewName);
        }
    }

    public void setDefaultErrorView(String defaultErrorView) {
        this.defaultErrorView = defaultErrorView;
        this.logger.info((Object)("Default error view is '" + this.defaultErrorView + "'"));
    }

    public void setMappedHandlers(List mappedHandlers) {
        this.mappedHandlers = mappedHandlers;
    }

    public void setExceptionAttribute(String exceptionAttribute) {
        this.exceptionAttribute = exceptionAttribute;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionMappings != null && (this.mappedHandlers == null || this.mappedHandlers.contains(handler))) {
            Iterator it = this.exceptionMappings.keySet().iterator();
            while (it.hasNext()) {
                Class exceptionClass = (Class)it.next();
                if (!exceptionClass.isInstance(ex)) continue;
                String viewName = (String)this.exceptionMappings.get(exceptionClass);
                return this.getModelAndView(viewName, ex);
            }
        }
        return this.defaultErrorView != null ? this.getModelAndView(this.defaultErrorView, ex) : null;
    }

    protected ModelAndView getModelAndView(String viewName, Exception ex) {
        ModelAndView mv = new ModelAndView(viewName);
        if (this.exceptionAttribute != null) {
            mv.addObject(this.exceptionAttribute, ex);
        }
        return mv;
    }
}

