/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.xml;

import java.io.IOException;
import java.io.Writer;
import org.apache.soap.util.StringUtils;

public final class NSStack {
    private static final int START_ARRAY_SIZE = 32;
    private String[] URIStack = new String[32];
    private String[] prefixStack = new String[32];
    private int[] scope = new int[32];
    private int top = 0;
    private int iterator = -1;
    private static final String NSPREFIX = "ns";
    private int nsPrefixCount = 0;
    private static String[] predefinedNamespaces;

    public NSStack() {
        this.scope[0] = -1;
    }

    private static synchronized String getPredefinedNamespace(int nsCount) {
        if (predefinedNamespaces == null) {
            predefinedNamespaces = new String[32];
            for (int i = 0; i < 32; ++i) {
                NSStack.predefinedNamespaces[i] = NSPREFIX + (i + 1);
            }
        } else if (nsCount >= predefinedNamespaces.length) {
            int length = predefinedNamespaces.length;
            String[] newnamespace = new String[length * 2];
            System.arraycopy(predefinedNamespaces, 0, newnamespace, 0, length);
            for (int i = 0; i < length; ++i) {
                newnamespace[i + length] = NSPREFIX + (i + length + 1);
            }
            predefinedNamespaces = newnamespace;
        }
        return predefinedNamespaces[nsCount];
    }

    public void pushScope() {
        ++this.top;
        int length = this.scope.length;
        if (this.top >= length) {
            int[] newscope = new int[length * 2];
            System.arraycopy(this.scope, 0, newscope, 0, length);
            this.scope = newscope;
        }
        this.scope[this.top] = this.iterator;
    }

    public void popScope() {
        this.iterator = this.scope[this.top];
        this.scope[this.top] = 0;
        --this.top;
    }

    public void addNSDeclaration(String prefix, String namespaceURI) {
        int length = this.URIStack.length;
        ++this.iterator;
        if (this.iterator >= length) {
            String[] newstack = new String[length * 2];
            System.arraycopy(this.URIStack, 0, newstack, 0, length);
            this.URIStack = newstack;
            newstack = new String[length * 2];
            System.arraycopy(this.prefixStack, 0, newstack, 0, length);
            this.prefixStack = newstack;
        }
        this.URIStack[this.iterator] = namespaceURI.intern();
        if (prefix == null) {
            prefix = "";
        }
        this.prefixStack[this.iterator] = prefix.intern();
    }

    public String addNSDeclaration(String URI2) {
        String uniquePrefix = this.getPrefixFromURI(URI2);
        if (uniquePrefix == null) {
            while (this.getURIFromPrefix(uniquePrefix = NSStack.getPredefinedNamespace(this.nsPrefixCount++)) != null) {
            }
            this.addNSDeclaration(uniquePrefix, URI2);
        }
        return uniquePrefix;
    }

    public String getPrefixFromURI(String namespaceURI) {
        if (namespaceURI == null || namespaceURI.equals("")) {
            return null;
        }
        namespaceURI = namespaceURI.intern();
        for (int cursor = this.iterator; cursor >= 0; --cursor) {
            if (this.URIStack[cursor] != namespaceURI) continue;
            return this.prefixStack[cursor];
        }
        return null;
    }

    public String getPrefixFromURI(String namespaceURI, Writer sink) throws IOException {
        String prefix = this.getPrefixFromURI(namespaceURI);
        if (prefix == null) {
            prefix = this.addNSDeclaration(namespaceURI);
            sink.write(" xmlns:");
            sink.write(prefix);
            sink.write("=\"");
            sink.write(namespaceURI);
            sink.write(34);
        }
        return prefix;
    }

    public String getURIFromPrefix(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        prefix = prefix.intern();
        for (int cursor = this.iterator; cursor >= 0; --cursor) {
            if (this.prefixStack[cursor] != prefix) continue;
            return this.URIStack[cursor];
        }
        return null;
    }

    public void dump() {
        int end = this.iterator;
        int start = 0;
        for (int cursor = this.top; cursor >= 0; --cursor) {
            start = this.scope[cursor] + 1;
            System.out.println("Level: " + cursor);
            for (int j = start; j <= end; ++j) {
                System.out.println("    Map:" + this.URIStack[j] + " -> " + this.prefixStack[j]);
            }
            end = start - 1;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(2048);
        int end = this.iterator;
        int start = 0;
        for (int cursor = this.top; cursor >= 0; --cursor) {
            start = this.scope[cursor] + 1;
            sb.append("Level: ").append(cursor).append(" (").append(start).append(" to ").append(end).append(')').append(StringUtils.lineSeparator);
            for (int j = start; j <= end; ++j) {
                sb.append("    Map:").append(this.URIStack[j]).append(" -> ").append(this.prefixStack[j]).append(StringUtils.lineSeparator);
            }
            end = start - 1;
        }
        return sb.toString();
    }
}

