/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.transport.smtp;

import com.ibm.network.mail.base.InternetAddress;
import com.ibm.network.mail.base.MimeBodyPart;
import com.ibm.network.mail.base.MimeMessage;
import com.ibm.network.mail.pop3.event.MessageEvent;
import com.ibm.network.mail.pop3.event.MessageListener;
import com.ibm.network.mail.pop3.event.StatusListener;
import com.ibm.network.mail.smtp.event.StatusEvent;
import com.ibm.network.mail.smtp.protocol.CoreProtocolBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.smtp.POP3StatusListener;
import org.apache.soap.transport.smtp.SMTPConstants;

public class SOAPSMTPConnection
implements SOAPTransport {
    private String fromAddr;
    private String subject;
    private Object waitObject = new Object();
    private long popPollDelay;
    private boolean responseReceived = false;
    private Hashtable responseHeaders = new Hashtable();
    private BufferedReader responseReader = null;
    CoreProtocolBean smtpBean = new CoreProtocolBean();
    com.ibm.network.mail.pop3.protocol.CoreProtocolBean pop3Bean = new com.ibm.network.mail.pop3.protocol.CoreProtocolBean();
    private SOAPContext responseSOAPContext;

    public SOAPSMTPConnection(String fromAddr, String subject, String smtpServer, long popPollDelay, String popServer, String popLogin, String popPassword) {
        this.fromAddr = fromAddr;
        this.subject = subject;
        this.popPollDelay = popPollDelay;
        this.smtpBean.setSmtpServerHost(smtpServer);
        this.smtpBean.addStatusListener(new com.ibm.network.mail.smtp.event.StatusListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(StatusEvent e) {
                System.err.println("DONE: " + e.getStatusString());
                Object object = SOAPSMTPConnection.this.waitObject;
                synchronized (object) {
                    SOAPSMTPConnection.this.waitObject.notify();
                }
            }

            public void processStatus(StatusEvent e) {
                System.err.println("Status update: " + e.getStatusString());
            }
        });
        this.responseReader = null;
        this.pop3Bean.setPOP3ServerHost(popServer);
        this.pop3Bean.setUserOptions(popLogin, popPassword, false, false);
        this.pop3Bean.addMessageListener(new MessageListener(){

            public void messageReceived(MessageEvent me) {
                String from;
                String to;
                String soapAction;
                MimeMessage msg = me.getMessage();
                String subj = msg.getHeader(SMTPConstants.SMTP_HEADER_SUBJECT);
                if (subj != null) {
                    SOAPSMTPConnection.this.responseHeaders.put(SMTPConstants.SMTP_HEADER_SUBJECT, subj);
                }
                if ((soapAction = msg.getHeader("SOAPAction")) != null) {
                    SOAPSMTPConnection.this.responseHeaders.put("SOAPAction", soapAction);
                }
                if ((to = msg.getHeader(SMTPConstants.SMTP_HEADER_TO)) != null) {
                    SOAPSMTPConnection.this.responseHeaders.put(SMTPConstants.SMTP_HEADER_TO, to);
                }
                if ((from = msg.getHeader(SMTPConstants.SMTP_HEADER_FROM)) != null) {
                    SOAPSMTPConnection.this.responseHeaders.put(SMTPConstants.SMTP_HEADER_FROM, from);
                }
                MimeBodyPart mbp = (MimeBodyPart)msg.getContent();
                byte[] ba = (byte[])mbp.getContent();
                String baStr = new String(ba);
                try {
                    SOAPSMTPConnection.this.responseSOAPContext = new SOAPContext();
                    SOAPSMTPConnection.this.responseSOAPContext.setRootPart(baStr, "text/xml");
                }
                catch (Exception ioe) {
                    ioe.printStackTrace();
                }
                SOAPSMTPConnection.this.responseReader = new BufferedReader(new StringReader(baStr));
                SOAPSMTPConnection.this.responseReceived = true;
            }
        });
        this.pop3Bean.addStatusListener((StatusListener)new POP3StatusListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(URL toAddr, String actionURI, Hashtable headers, Envelope env, SOAPMappingRegistry smr, SOAPContext ctx) throws SOAPException {
        MimeMessage msg = new MimeMessage();
        MimeBodyPart mbp = new MimeBodyPart();
        StringWriter sw = new StringWriter();
        try {
            env.marshall(sw, smr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        mbp.setContent((Object)sw.toString(), "text/xml");
        mbp.setEncoding(4);
        mbp.setDisposition(2);
        msg.setContent((Object)mbp, "");
        msg.addHeader("Subject", this.subject);
        msg.addHeader("SOAPAction", actionURI);
        msg.addHeader("From", this.fromAddr);
        msg.addRecipients(0, new InternetAddress[]{new InternetAddress(toAddr.getFile())});
        this.smtpBean.sendMessage(msg);
        try {
            Object e = this.waitObject;
            synchronized (e) {
                this.waitObject.wait();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized BufferedReader receive() {
        if (this.responseReader == null) {
            this.responseReceived = false;
            while (!this.responseReceived) {
                try {
                    if (this.pop3Bean.isReady()) {
                        System.err.println("SOAPSMTPConnection: Polling for response ..");
                        this.pop3Bean.receiveMessage();
                        if (this.responseReceived) break;
                    }
                    Thread.sleep(this.popPollDelay);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.responseReader;
    }

    public synchronized Hashtable getHeaders() {
        if (this.responseReader == null) {
            this.receive();
        }
        return this.responseHeaders;
    }

    public synchronized SOAPContext getResponseSOAPContext() {
        if (this.responseReader == null) {
            this.receive();
        }
        return this.responseSOAPContext;
    }
}

