/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.tags;

import java.util.Enumeration;
import org.htmlparser.HTMLRenderer;
import org.htmlparser.tags.HTMLTag;

public class HTMLImageTag
extends HTMLTag {
    public static final String IMAGE_TAG_FILTER = "-i";
    protected String imageURL;

    public HTMLImageTag(String imageURL, int imageBegin, int imageEnd, String tagLine, String tagContents) {
        super(imageBegin, imageEnd, tagContents, tagLine);
        this.imageURL = imageURL;
    }

    public HTMLImageTag(String imageURL, int imageBegin, int imageEnd, String tagLine, String tagContents, int _nLine) {
        super(imageBegin, imageEnd, tagContents, tagLine, _nLine);
        this.imageURL = imageURL;
    }

    public String getImageURL() {
        return this.imageURL;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("IMAGE TAG : Image at ").append(this.imageURL).append("; begins at : ").append(this.elementBegin()).append("; ends at : ").append(this.elementEnd())));
    }

    public String toHTML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<IMG ");
        int i = 0;
        Enumeration e = this.parsed.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ++i;
            if (key == "$<TAGNAME>$") continue;
            String value = this.getParameter(key);
            sb.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(key))).append("=\"").append(value).append("\""))));
            if (i >= this.parsed.size()) continue;
            sb.append(" ");
        }
        sb.append(">");
        return sb.toString();
    }

    public String toHTML(HTMLRenderer renderer) {
        if (renderer == null) {
            return this.toHTML();
        }
        return renderer.renderImagesToHTML(this);
    }

    public void setImageURL(String imageURL) {
        this.imageURL = imageURL;
        this.parsed.put("SRC", imageURL);
    }

    static {
        IMAGE_TAG_FILTER = IMAGE_TAG_FILTER;
    }
}

