/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import java.util.Hashtable;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLReader;
import org.htmlparser.HTMLStringNode;
import org.htmlparser.tags.HTMLEndTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.HTMLParserException;
import org.htmlparser.util.HTMLParserFeedback;

public abstract class HTMLTagScanner {
    protected String filter;
    protected HTMLParserFeedback feedback;

    public HTMLTagScanner() {
        this.filter = "";
    }

    public HTMLTagScanner(String filter) {
        this.filter = filter;
    }

    public String absorb(String s, char c) {
        int index = s.indexOf(c);
        if (index != -1) {
            s = s.substring(index + 1, s.length());
        }
        return s;
    }

    public static String absorbLeadingBlanks(String s) {
        String temp = new String(s);
        while (temp.length() != 0 && temp.charAt(0) == ' ') {
            temp = temp.substring(1, temp.length());
        }
        return temp;
    }

    public boolean evaluate(String s, HTMLTagScanner previousOpenScanner) {
        return true;
    }

    public static String extractXMLData(HTMLNode node, String tagName, HTMLReader reader) throws HTMLParserException {
        try {
            String string;
            HTMLEndTag endTag;
            String xmlData = "";
            boolean xmlTagFound = HTMLTagScanner.isXMLTagFound(node, tagName);
            if (xmlTagFound) {
                try {
                    do {
                        if ((node = reader.readElement()) == null) continue;
                        if (node instanceof HTMLStringNode) {
                            HTMLStringNode stringNode = (HTMLStringNode)node;
                            if (xmlData.length() > 0) {
                                xmlData = String.valueOf(String.valueOf(xmlData)).concat(" ");
                            }
                            xmlData = String.valueOf(String.valueOf(xmlData)).concat(String.valueOf(String.valueOf(stringNode.getText())));
                            continue;
                        }
                        if (node instanceof HTMLEndTag) continue;
                        xmlTagFound = false;
                    } while (node instanceof HTMLStringNode);
                }
                catch (Exception e) {
                    throw new HTMLParserException("HTMLTagScanner.extractXMLData() : error while trying to find xml tag", e);
                }
            }
            if (xmlTagFound && node != null && node instanceof HTMLEndTag && !(endTag = (HTMLEndTag)node).getText().equals(tagName)) {
                xmlTagFound = false;
            }
            if (xmlTagFound) {
                string = xmlData;
                return string;
            }
            string = null;
            return string;
        }
        catch (Exception e) {
            throw new HTMLParserException("HTMLTagScanner.extractXMLData() : Error occurred while trying to extract xml tag", e);
        }
    }

    public String getFilter() {
        return this.filter;
    }

    public static boolean isXMLTagFound(HTMLNode node, String tagName) {
        HTMLTag tag;
        boolean xmlTagFound = false;
        if (node instanceof HTMLTag && (tag = (HTMLTag)node).getText().toUpperCase().indexOf(tagName) == 0) {
            xmlTagFound = true;
        }
        return xmlTagFound;
    }

    public final HTMLTag createScannedNode(HTMLTag tag, String url, HTMLReader reader, String currLine) throws HTMLParserException {
        HTMLTag thisTag = this.scan(tag, url, reader, currLine);
        thisTag.setThisScanner(this);
        thisTag.setParsed(tag.getParsed());
        return thisTag;
    }

    public abstract HTMLTag scan(HTMLTag var1, String var2, HTMLReader var3, String var4) throws HTMLParserException;

    public String removeChars(String s, char occur) {
        StringBuffer newString = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == occur) continue;
            newString.append(ch);
        }
        return newString.toString();
    }

    public String removeChars(String s, String occur) {
        int index;
        StringBuffer newString = new StringBuffer();
        do {
            if ((index = s.indexOf(occur)) == -1) continue;
            newString.append(s.substring(0, index));
            s = s.substring(index + occur.length());
        } while (index != -1);
        newString.append(s);
        return newString.toString();
    }

    public abstract String[] getID();

    public final void setFeedback(HTMLParserFeedback feedback) {
        this.feedback = feedback;
    }

    public static Hashtable adjustScanners(HTMLReader pReader) {
        Hashtable tempScanners = new Hashtable();
        tempScanners = pReader.getParser().getScanners();
        pReader.getParser().flushScanners();
        return tempScanners;
    }

    public static void restoreScanners(HTMLReader pReader, Hashtable tempScanners) {
        pReader.getParser().setScanners(tempScanners);
    }

    public String insertEndTagBeforeNode(HTMLNode node, String currentLine) {
        String newLine = currentLine.substring(0, node.elementBegin());
        newLine = String.valueOf(String.valueOf(newLine)).concat("</A>");
        newLine = String.valueOf(String.valueOf(newLine)).concat(String.valueOf(String.valueOf(currentLine.substring(node.elementBegin(), currentLine.length()))));
        return newLine;
    }
}

