/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import org.htmlparser.HTMLReader;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.tags.HTMLDoctypeTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.HTMLParserException;

public class HTMLDoctypeScanner
extends HTMLTagScanner {
    private String language;
    private String type;

    public HTMLDoctypeScanner() {
    }

    public HTMLDoctypeScanner(String filter) {
        super(filter);
    }

    public void extractLanguage(HTMLTag tag) {
        this.language = tag.getParameter("LANGUAGE");
    }

    public HTMLTag scan(HTMLTag tag, String url, HTMLReader reader, String currentLine) throws HTMLParserException {
        try {
            HTMLDoctypeTag docTypeTag;
            String tagContents = tag.getText();
            tagContents = tagContents.substring(9, tagContents.length());
            HTMLDoctypeTag hTMLDoctypeTag = docTypeTag = new HTMLDoctypeTag(tag.elementBegin(), tag.elementEnd(), tagContents, currentLine, tag.getLine());
            return hTMLDoctypeTag;
        }
        catch (Exception e) {
            throw new HTMLParserException("HTMLDoctypeScanner.scan() : Error in scanning doctype tag, current line = ".concat(String.valueOf(String.valueOf(currentLine))), e);
        }
    }

    public void setLanguage(String newLanguage) {
        this.language = newLanguage;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public String[] getID() {
        String[] ids = new String[]{"!DOCTYPE"};
        return ids;
    }
}

