/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLReader;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.tags.HTMLAppletTag;
import org.htmlparser.tags.HTMLEndTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.HTMLParserException;

public class HTMLAppletScanner
extends HTMLTagScanner {
    private String className;
    private String archive;
    private String codebase;

    public HTMLAppletScanner() {
    }

    public HTMLAppletScanner(String filter) {
        super(filter);
    }

    public void extractFields(HTMLTag tag) {
        this.className = tag.getParameter("CODE");
        this.archive = tag.getParameter("ARCHIVE");
        this.codebase = tag.getParameter("CODEBASE");
    }

    public String getArchive() {
        return this.archive;
    }

    public String getClassName() {
        return this.className;
    }

    public String getCodebase() {
        return this.codebase;
    }

    public HTMLTag scan(HTMLTag tag, String url, HTMLReader reader, String currLine) throws HTMLParserException {
        try {
            HTMLAppletTag appTag;
            String tagContents = tag.getText();
            this.extractFields(tag);
            HTMLEndTag endTag = null;
            HTMLNode node = null;
            boolean endScriptFound = false;
            Vector buff = new Vector();
            Vector<HTMLTag> misc = new Vector<HTMLTag>();
            Hashtable<String, String> table = new Hashtable<String, String>();
            do {
                if ((node = reader.readElement()) instanceof HTMLEndTag) {
                    endTag = (HTMLEndTag)node;
                    if (!endTag.getText().toUpperCase().equals("APPLET")) continue;
                    endScriptFound = true;
                    continue;
                }
                if (!(node instanceof HTMLTag)) continue;
                HTMLTag htag = (HTMLTag)node;
                String paramName = htag.getParameter("NAME");
                if (paramName != null && paramName.length() != 0) {
                    String paramValue = htag.getParameter("VALUE");
                    table.put(paramName, paramValue);
                    continue;
                }
                misc.addElement(htag);
            } while (!endScriptFound && node != null);
            if (node == null && !endScriptFound) {
                StringBuffer msg = new StringBuffer();
                Enumeration e = table.elements();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    msg.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(key))).append("=").append(table.get(key)).append("\n"))));
                }
                throw new HTMLParserException("HTMLAppletScanner.scan() : Went into a potential infinite loop - tags must be malformed.\nTable contents : ".concat(String.valueOf(String.valueOf(msg.toString()))));
            }
            HTMLAppletTag hTMLAppletTag = appTag = new HTMLAppletTag(node.elementBegin(), node.elementEnd(), tag.getText(), currLine, this.className, this.archive, this.codebase, table, misc, tag.getLine());
            return hTMLAppletTag;
        }
        catch (Exception e) {
            throw new HTMLParserException("HTMLAppletScannet.scan(): Error in scanning applet tag, current line = ".concat(String.valueOf(String.valueOf(currLine))), e);
        }
    }

    public void setArchive(String newArchive) {
        this.archive = newArchive;
    }

    public void setClassName(String newClassName) {
        this.className = newClassName;
    }

    public void setCodebase(String newCodebase) {
        this.codebase = newCodebase;
    }

    public String[] getID() {
        String[] ids = new String[]{"APPLET"};
        return ids;
    }
}

