/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.trsserver.task;

import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.log4j.Logger;

public class DBHelper {
    private static Logger logger = Logger.getLogger(DBHelper.class);

    public static DBFieldInfo[] queryDBFields(String _sTableName) throws WCMException {
        DBManager dbManager = DBManager.getDBManager();
        String SQL = "select * from " + _sTableName;
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement(SQL);
            oPreStmt.setMaxRows(1);
            result = oPreStmt.executeQuery();
            ResultSetMetaData metaData = result.getMetaData();
            DBFieldInfo[] pDFieldInfos = new DBFieldInfo[metaData.getColumnCount()];
            int nSize = metaData.getColumnCount();
            for (int i = 1; i <= nSize; ++i) {
                pDFieldInfos[i - 1] = new DBFieldInfo(metaData.getColumnName(i), metaData.getColumnType(i));
            }
            DBFieldInfo[] dBFieldInfoArray = pDFieldInfos;
            return dBFieldInfoArray;
        }
        catch (Exception ex) {
            throw new WCMException("Fail to query!", ex);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    public static class DBFieldInfo {
        private int m_nType;
        private String m_sName;

        public DBFieldInfo(String _sName, int _nType) {
            this.m_sName = _sName;
            this.m_nType = _nType;
        }

        public int getType() {
            return this.m_nType;
        }

        public String getName() {
            return this.m_sName;
        }
    }
}

