/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcag2.validator;

import com.trs.infra.I18NMessage;
import com.trs.wcag2.HTMLUtil;
import com.trs.wcag2.validator.AbstractValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HtmlLangValidator
extends AbstractValidator {
    protected String m_sType = I18NMessage.get(HtmlLangValidator.class, "HtmlLangValidator.label1", "\u591a\u8bed\u8a00");
    protected Object m_oWarning = I18NMessage.get(HtmlLangValidator.class, "HtmlLangValidator.label2", "html\u8282\u70b9\u4e0a\u6ca1\u6709\u6307\u5b9alang/xml:lang\u5c5e\u6027\u6216\u5c5e\u6027\u503c\u4e3a\u7a7a");
    protected String m_oExample = I18NMessage.get(HtmlLangValidator.class, "HtmlLangValidator.label3", "\u5728HTML\u8282\u70b9\u4e0a\u6dfb\u52a0lang\u5c5e\u6027\u548c\u503c\uff0c\u4f8b\u5982\uff1a<br>") + "<br>&nbsp;&nbsp;&lt;html <span style=\"color:blue\">lang=\"cn\"</span>&gt;";

    @Override
    public Object doValid(String content, HashMap known) {
        ArrayList<String[]> rst = new ArrayList<String[]>();
        String eleName = "HTML";
        List tags = HTMLUtil.findTagStartHTML(content, eleName);
        if (tags.size() > 0) {
            int[] pos = (int[])tags.get(0);
            String sTagOuterHTML = content.substring(pos[0], pos[1]);
            String sAttrs = HTMLUtil.getEleAttrs(sTagOuterHTML, eleName);
            HashMap hs = HTMLUtil.makeHsAttrs(sAttrs);
            int[] lenPos = HTMLUtil.getPosition(content.substring(0, pos[0]));
            if ((hs.get("lang") == null || "".equals(hs.get("lang"))) && (hs.get("xml:lang") == null || "".equals(hs.get("xml:lang")))) {
                rst.add(new String[]{String.valueOf(lenPos[0]), String.valueOf(lenPos[1]), sTagOuterHTML});
                return rst;
            }
        }
        return null;
    }

    @Override
    public Object getWarnObj() {
        return this.m_oWarning;
    }

    @Override
    public String getType() {
        return this.m_sType;
    }

    @Override
    public Object getExampleObj() {
        return this.m_oExample;
    }
}

