/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.domain;

import com.trs.DreamFactory;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.cache.ICacheMgr;
import com.trs.scm.domain.SCMGroupUserCacheMgr;
import com.trs.scm.persistent.SCMGroup;
import com.trs.scm.persistent.SCMGroups;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SCMGroupsCacheMgr
implements ICacheMgr {
    private static Logger logger = Logger.getLogger(SCMGroupUserCacheMgr.class);
    private Map<String, SCMGroup> m_hSCMGroupsCache = null;
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");

    @Override
    public void clear() {
    }

    @Override
    public boolean init() throws WCMException {
        return this.doStart();
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.doStart();
    }

    private synchronized boolean doStart() throws WCMException {
        if (cache.exists(this.getKey()).booleanValue()) {
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"cache begin....");
        }
        if (this.m_hSCMGroupsCache == null) {
            this.initSCMGroupsCache();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"cache was inited....");
        }
        return true;
    }

    private void initSCMGroupsCache() throws WCMException {
        SCMGroups oSCMGroups = this.loadSCMGroups();
        int nSize = oSCMGroups.size();
        for (int i = 0; i < nSize; ++i) {
            SCMGroup oSCMGroup = (SCMGroup)oSCMGroups.getAt(i);
            if (oSCMGroup == null) continue;
            this.save(oSCMGroup);
        }
        cache.set(this.getKey(), "true");
    }

    private void save(SCMGroup oSCMGroup) {
        int groupId = oSCMGroup.getId();
        String key = this.getKey(groupId);
        cache.lrem(key, 0L, key);
        cache.set(key, groupId);
        LinkedList<String> keys = (LinkedList<String>)cache.get(this.getKey("key"));
        if (keys == null) {
            keys = new LinkedList<String>();
            keys.add(key);
        } else if (!keys.contains(key)) {
            keys.add(key);
        }
        cache.set(this.getKey("key"), keys);
    }

    private SCMGroups loadSCMGroups() throws WCMException {
        SCMGroups oSCMGroups = SCMGroups.openWCMObjs(null, null);
        return oSCMGroups;
    }

    private void ensureCacheLoaded() throws WCMException {
        if (!cache.exists(this.getKey()).booleanValue()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Ensure the SCM Cache is loaded!");
            }
            this.doStart();
        }
    }

    @Override
    public void notifyOnAddObj(BaseObj objAdded) throws WCMException {
        if (!this.isListening(objAdded)) {
            return;
        }
        this.ensureCacheLoaded();
        SCMGroup oSCMGroup = (SCMGroup)objAdded;
        this.save(oSCMGroup);
    }

    @Override
    public void notifyOnDelObj(BaseObj objDeleted, int eventType) throws WCMException {
        if (!this.isListening(objDeleted)) {
            return;
        }
        this.ensureCacheLoaded();
        SCMGroup oSCMGroup = (SCMGroup)objDeleted;
        cache.clear(this.getKey(oSCMGroup.getId()));
    }

    @Override
    public void notifyOnModifyObj(BaseObj objModified, int eventType) throws WCMException {
        if (!this.isListening(objModified)) {
            return;
        }
        this.ensureCacheLoaded();
        SCMGroup oSCMGroup = (SCMGroup)objModified;
        this.save(oSCMGroup);
    }

    private boolean isListening(BaseObj _oBaseObj) {
        return _oBaseObj != null && _oBaseObj instanceof SCMGroup;
    }

    private String getKey(Integer groupId) {
        if (groupId == null) {
            return null;
        }
        return this.getKey() + "." + groupId;
    }

    private String getKey(String key) {
        return this.getKey() + "." + key;
    }

    private String getKey() {
        return SCMGroupsCacheMgr.class.getName();
    }

    public SCMGroups getAllSCMGroups() throws WCMException {
        SCMGroups oGroups = SCMGroups.createNewInstance(null);
        List keys = (List)cache.get(this.getKey("key"));
        if (keys == null) {
            return oGroups;
        }
        for (String key : keys) {
            SCMGroup group = SCMGroup.findById((Integer)cache.get(key));
            oGroups.addElement(group);
        }
        return oGroups;
    }

    public HashMap getSCMGroupsCache() throws WCMException {
        List keys = (List)cache.get(this.getKey("key"));
        if (keys != null) {
            for (String key : keys) {
                SCMGroup group = SCMGroup.findById((Integer)cache.get(key));
                this.m_hSCMGroupsCache.put(key, group);
            }
        }
        return (HashMap)this.m_hSCMGroupsCache;
    }
}

