/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.stat.domain;

import com.trs.components.wcm.stat.domain.ChartStyle;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.store.FileService;
import java.io.OutputStream;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class ChartWriter {
    public static void generateChart(String _sFilepath, JFreeChart oChart) throws CMyException {
        ChartWriter.generateChart(_sFilepath, oChart, null);
    }

    public static void generateChart(String _sFilepath, JFreeChart oChart, ChartStyle _oStyle) throws CMyException {
        OutputStream fos = null;
        try {
            fos = new FileService(_sFilepath).getOutputStream();
        }
        catch (Exception ex) {
            throw new CMyException(I18NMessage.get(ChartWriter.class, "ChartWriter.label1", "\u6587\u4ef6[") + _sFilepath + I18NMessage.get(ChartWriter.class, "ChartWriter.label2", "]\u6ca1\u6709\u627e\u5230\uff01"), ex);
        }
        ChartWriter.generateChart(fos, oChart, _oStyle);
    }

    public static void generateChart(OutputStream _os, JFreeChart oChart) throws CMyException {
        ChartWriter.generateChart(_os, oChart, null);
    }

    public static void generateChart(OutputStream _os, JFreeChart oChart, ChartStyle _oStyle) throws CMyException {
        OutputStream os = null;
        if (_oStyle == null) {
            _oStyle = ChartStyle.getDefaultStyle();
        }
        try {
            os = _os;
            ChartUtilities.writeChartAsJPEG((OutputStream)_os, (float)1.0f, (JFreeChart)oChart, (int)_oStyle.getChartWidth(), (int)_oStyle.getChartHeight(), null);
        }
        catch (Exception ex) {
            throw new CMyException(I18NMessage.get(ChartWriter.class, "ChartWriter.label3", "\u8f93\u51fa\u56fe\u8868\u65f6\u51fa\u9519!"), ex);
        }
        finally {
            if (os == null) {
                return;
            }
            try {
                os.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

