/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.region;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.region.CellInfos;
import com.trs.components.wcm.publish.region.RegionEmployMgr;
import com.trs.components.wcm.publish.region.RegionEmploys;
import com.trs.components.wcm.publish.region.RegionInfo;
import com.trs.components.wcm.publish.region.RegionInfos;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.persistent.IdFilterSqlUtil;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.List;

public class RegionServiceProvider
implements IGlueServiceProvider {
    @Override
    public void delete(MethodContext _oContext) throws Throwable {
        User loginUser = this.getLoginUser();
        RegionInfos regionInfos = RegionInfos.findByIds(loginUser, _oContext.getObjectIds());
        for (int i = 0; i < regionInfos.size(); ++i) {
            RegionInfo oRegionInfo = (RegionInfo)regionInfos.getAt(i);
            if (oRegionInfo == null) continue;
            try {
                this.validRight(loginUser, oRegionInfo, WCMRightTypes.REGION_DELETE);
            }
            catch (Exception e) {
                continue;
            }
            oRegionInfo.delete(loginUser);
            this.deleteCellInfos(oRegionInfo);
            this.deleteRegionEmploy(oRegionInfo);
        }
    }

    @Override
    public Object query(MethodContext _oContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nChannelId = _oContext.getValue("ChannelId", 0);
        int nWebSiteId = _oContext.getValue("WebSiteId", 0);
        boolean bContainsChildren = _oContext.getValue("ContainsChildren", false);
        WCMFilter filter = new WCMFilter();
        String sOrderBy = _oContext.getValue("orderby");
        if (CMyString.isEmpty(sOrderBy)) {
            sOrderBy = "REGIONINFOID desc";
        }
        filter.setOrder(sOrderBy);
        StringBuffer buff = new StringBuffer(256);
        if (nChannelId > 0) {
            Channel channel = Channel.findById(nChannelId);
            if (channel == null) {
                throw new WCMException("\u6307\u5b9a\u680f\u76ee\u4e0d\u5b58\u5728[ID=" + nChannelId + "]");
            }
            this.validRight(loginUser, channel, WCMRightTypes.REGION_LIST);
            buff.append("channelid=?");
            filter.addSearchValues(nChannelId);
            if (bContainsChildren) {
                StringBuffer buffChildrenIds = new StringBuffer(512);
                this.makeQueryAllChildren(buffChildrenIds, channel, this.getLoginUser());
                if (buffChildrenIds.length() > 1) {
                    IdFilterSqlUtil.RangeSQL rangeSQL = IdFilterSqlUtil.make("CHANNELID", buffChildrenIds.substring(1));
                    buff.append(" or ");
                    buff.append(rangeSQL.getSql());
                    int[] ids = rangeSQL.getValues();
                    if (ids != null) {
                        int len = ids.length;
                        for (int i = 0; i < len; ++i) {
                            filter.addSearchValues(ids[i]);
                        }
                    }
                    buffChildrenIds.setLength(0);
                }
            }
        } else if (nWebSiteId > 0) {
            WebSite website = WebSite.findById(nWebSiteId);
            if (website == null) {
                throw new WCMException("\u6307\u5b9a\u7ad9\u70b9\u4e0d\u5b58\u5728[ID=" + nWebSiteId + "]");
            }
            this.validRight(loginUser, website, WCMRightTypes.REGION_LIST);
            buff.append("WEBSITEID=?");
            filter.addSearchValues(nWebSiteId);
            if (bContainsChildren) {
                buff.append(" or CHANNELID in ");
                buff.append("(select CHANNELID from WCMCHANNEL where SITEID=? and STATUS=0)");
                filter.addSearchValues(nWebSiteId);
            }
        }
        filter.setWhere(buff.toString());
        filter.mergeWith(_oContext.getExtraWCMFilter());
        return RegionInfos.openWCMObjs(null, filter);
    }

    private void makeQueryAllChildren(StringBuffer result, Channel channel, User user) throws WCMException {
        List<Channel> children = channel.getChildren(user);
        if (children == null || children.isEmpty()) {
            return;
        }
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Channel child = children.get(i);
            if (child == null || child.isDeleted()) continue;
            result.append(',').append(child.getId());
            this.makeQueryAllChildren(result, child, user);
        }
    }

    @Override
    public int save(MethodContext _oContext) throws Throwable {
        RegionInfo regionInfo = null;
        User loginUser = ContextHelper.getLoginUser();
        int nObjectId = _oContext.getObjectId();
        if (nObjectId > 0) {
            regionInfo = RegionInfo.findById(nObjectId);
            if (regionInfo == null) {
                throw new WCMException("\u6307\u5b9a\u7684\u5bfc\u8bfb\u4e0d\u5b58\u5728[ID=" + nObjectId + "]");
            }
            this.validRight(loginUser, regionInfo, WCMRightTypes.REGION_EDIT);
        } else {
            regionInfo = new RegionInfo();
            regionInfo.setChannelId(_oContext.getValue("ChannelId", 0));
            regionInfo.setWebSiteId(_oContext.getValue("WebSiteId", 0));
            this.validRight(loginUser, regionInfo, WCMRightTypes.REGION_ADD);
        }
        regionInfo = (RegionInfo)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _oContext, regionInfo, null);
        String sRegionName = regionInfo.getName();
        if (this.checkRegionName(nObjectId, sRegionName)) {
            throw new WCMException("\u4e0d\u5141\u8bb8\u521b\u5efa\u540c\u540d\u7684\u5bfc\u8bfb\uff01");
        }
        regionInfo.save(loginUser);
        return regionInfo.getId();
    }

    public boolean existsSimilarName(MethodContext _oContext) throws Throwable {
        String sRegionName = _oContext.getValue("Rname");
        if (sRegionName == null || "".equals(sRegionName.trim())) {
            throw new WCMException("\u5fc5\u987b\u4f20\u5165\u53c2\u6570\u5bfc\u8bfb\u540d\u79f0\u3010Rname\u3011\uff01");
        }
        int nObjectId = _oContext.getValue("ObjectId", 0);
        return this.checkRegionName(nObjectId, sRegionName);
    }

    private boolean checkRegionName(int _nRegionId, String sRegionName) throws WCMException {
        WCMFilter filter = new WCMFilter("XWCMREGIONINFO", "", "", "RegionInfoId");
        StringBuffer sWhereBuffer = new StringBuffer();
        sWhereBuffer.append("RName=?");
        if (_nRegionId > 0) {
            sWhereBuffer.append(" and RegionInfoId not in (" + _nRegionId + ")");
        }
        filter.addSearchValues(sRegionName);
        filter.setWhere(sWhereBuffer.toString());
        return DBManager.getDBManager().sqlExecuteIntQuery(filter) > 0;
    }

    @Override
    public Object findById(MethodContext _oContext) throws Throwable {
        int nObjectId = _oContext.getObjectId();
        if (nObjectId == 0) {
            return null;
        }
        RegionInfo region = this.findById(nObjectId);
        this.validRight(this.getLoginUser(), region, WCMRightTypes.REGION_DETAIL);
        return region;
    }

    @Override
    public Object findByIds(MethodContext _oContext) throws Throwable {
        return null;
    }

    private RegionInfo findById(int _nRegionId) throws WCMException {
        RegionInfo region = RegionInfo.findById(_nRegionId);
        if (region == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5bfc\u8bfb\u5bf9\u8c61\uff01[ID=" + _nRegionId + "]");
        }
        return region;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void deleteCellInfos(RegionInfo region) throws WCMException {
        if (region == null) {
            return;
        }
        CellInfos cells = CellInfos.findCellInfos(region, null);
        if (cells != null) {
            cells.removeAll();
        }
    }

    private void deleteRegionEmploy(RegionInfo region) throws WCMException {
        if (region == null) {
            return;
        }
        RegionEmployMgr regionEmployMgr = (RegionEmployMgr)DreamFactory.createObjectById("RegionEmployMgr");
        RegionEmploys regionEmploys = regionEmployMgr.getRegionEmploysByRegion(region);
        if (regionEmploys == null) {
            return;
        }
        regionEmploys.removeAll();
    }

    private boolean validRight(User loginUser, RegionInfo _oRegionInfo, int nRightIndex) throws WCMException {
        int nChannelId = _oRegionInfo.getChannelId();
        int nWebSiteId = _oRegionInfo.getWebSiteId();
        Channel channel = Channel.findById(nChannelId);
        WebSite website = WebSite.findById(nWebSiteId);
        BaseChannel baseChannel = channel;
        if (baseChannel == null) {
            baseChannel = website;
        }
        if (baseChannel != null) {
            if (!AuthServer.hasRight(loginUser, (CMSObj)baseChannel, nRightIndex)) {
                throw new WCMException("\u60a8[" + loginUser.getName() + "]\u6ca1\u6709\u6743\u9650\u7ba1\u7406[" + baseChannel + "]\u7684\u5bfc\u8bfb\uff01");
            }
        } else {
            throw new WCMException("\u6307\u5b9a\u5bfc\u8bfb\u6240\u5728\u7684\u680f\u76ee[ID=" + nChannelId + "]\u548c\u7ad9\u70b9[ID=" + nWebSiteId + "\u4e0d\u5b58\u5728");
        }
        return true;
    }

    private boolean validRight(User loginUser, CMSObj cmsObj, int nRightIndex) throws WCMException {
        if (!AuthServer.hasRight(loginUser, cmsObj, nRightIndex)) {
            throw new WCMException("\u60a8[" + loginUser.getName() + "]\u6ca1\u6709\u6743\u9650\u7ba1\u7406[" + cmsObj + "]\u7684\u5bfc\u8bfb\uff01");
        }
        return true;
    }
}

