/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.filter;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;

public class FilterOptionGroup
extends CMSObj {
    public static final int OBJ_TYPE = 1310565549;
    public static final String DB_TABLE_NAME = "XWCMFILTEROPTIONGROUP";
    public static final String DB_ID_NAME = "FILTEROPTIONGROUPID";
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 1310565549;
    }

    public String getOptionGroupName() {
        return this.getPropertyAsString("OPTIONGROUPNAME");
    }

    public boolean setOptionGroupName(String _sOptionGroupName) throws WCMException {
        return this.setProperty("OPTIONGROUPNAME", _sOptionGroupName);
    }

    public String getOptionGroupDesc() {
        return this.getPropertyAsString("OPTIONGROUPDESC");
    }

    public boolean setOptionGroupDesc(String _sOptionGroupDesc) throws WCMException {
        return this.setProperty("OPTIONGROUPDESC", _sOptionGroupDesc);
    }

    public int getFilterId() {
        return this.getPropertyAsInt("FILTERID", 0);
    }

    public boolean setFilterId(int _nFilterId) throws WCMException {
        return this.setProperty("FILTERID", _nFilterId);
    }

    public int getOrder() {
        return this.getPropertyAsInt("FORDER", 0);
    }

    public boolean setOrder(int _nForder) throws WCMException {
        return this.setProperty("FORDER", _nForder);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("OPTIONGROUPNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(FilterOptionGroup.class, "FilterOptionGroup.label1", "\u5c5e\u6027OptionGroupName\u6ca1\u6709\u8bbe\u7f6e(FilterOptionGroup.isValid)"));
            }
            if (this.getProperty("FORDER") == null) {
                throw new WCMException(1106, I18NMessage.get(FilterOptionGroup.class, "FilterOptionGroup.label2", "\u5c5e\u6027Forder\u6ca1\u6709\u8bbe\u7f6e(FilterOptionGroup.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(FilterOptionGroup.class, "FilterOptionGroup.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(FilterOptionGroup.isValid)"));
        }
        this.changeOrder();
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    private void changeOrder() throws WCMException {
        int nMaxOrder;
        int nNewOrder;
        int nMoveBeginAt = 0;
        int nMoveEndAt = 0;
        int nMoveDirection = 0;
        if (this.isAddMode()) {
            nNewOrder = this.getOrder();
            nMaxOrder = this.getMaxOrder();
            if (nNewOrder == -1) {
                nNewOrder = nMaxOrder + 1;
                this.setOrder(nNewOrder);
                return;
            }
            nMoveDirection = 1;
            nMoveEndAt = nMaxOrder;
            nMoveBeginAt = nNewOrder;
        } else {
            if (!this.isChangeProperty("FORDER")) {
                return;
            }
            nNewOrder = this.getNewPropertyAsInt("FORDER", -1);
            if (nNewOrder == -1) {
                nMaxOrder = this.getMaxOrder();
                if (nMaxOrder == this.getOrder()) {
                    nNewOrder = this.getOrder();
                } else {
                    nMoveDirection = -1;
                    nMoveEndAt = nMaxOrder;
                    nMoveBeginAt = this.getOrder() + 1;
                    nNewOrder = nMaxOrder;
                }
            } else if (nNewOrder > this.getOrder()) {
                nMoveDirection = -1;
                nMoveEndAt = nNewOrder;
                nMoveBeginAt = this.getOrder() + 1;
            } else {
                nMoveDirection = 1;
                nMoveEndAt = this.getOrder() - 1;
                nMoveBeginAt = nNewOrder;
            }
        }
        String sRegionWhere = "FORDER>=" + nMoveBeginAt + " AND FORDER <= " + nMoveEndAt + " and FILTERID=" + this.getFilterId();
        String sMoveSql = "UPDATE XWCMFILTEROPTIONGROUP SET FORDER = FORDER+(" + nMoveDirection + ") WHERE " + sRegionWhere;
        DBManager.getDBManager().sqlExecuteUpdate(sMoveSql);
        this.setOrder(nNewOrder);
    }

    private int getMaxOrder() throws WCMException {
        String SQL_QUERY_MAX_ORDER = "select max(FORDER) from XWCMFILTEROPTIONGROUP where FILTERID=?";
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(FORDER) from XWCMFILTEROPTIONGROUP where FILTERID=?", new int[]{this.getFilterId()});
    }

    public static final FilterOptionGroup findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (FilterOptionGroup)BaseObj.findById(FilterOptionGroup.class, _nId);
    }

    public static final FilterOptionGroup createNewInstance() throws WCMException {
        return (FilterOptionGroup)BaseObj.createNewInstance(FilterOptionGroup.class);
    }

    public static final FilterOptionGroup findByKey(Object _oKey) throws WCMException {
        return (FilterOptionGroup)BaseObj.findByKey(FilterOptionGroup.class, _oKey);
    }
}

