/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.config.PublishDistributionTargetType;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.distribute.IFileDistristributor;
import com.trs.components.common.publish.domain.distribute.PublishDistributionCacheMgr;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.components.common.publish.persistent.distribute.PublishDistributions;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import org.apache.log4j.Logger;

public class PublishDistributionMgr {
    private static final Logger s_logger = Logger.getLogger(PublishDistributionMgr.class);
    public static int MAXTARGETS_EACHFOLDER = 2;
    private PublishDistributionCacheMgr m_oCache;

    public static final IFileDistristributor makeDistristributor(PublishDistribution _distribution) throws WCMException {
        PublishDistributionTargetType targetType = null;
        String sTargetType = _distribution.getTargetType();
        targetType = PublishServerConfigMapper.lookupDistributionTargetTypeByName(sTargetType);
        if (targetType == null) {
            throw new WCMException(1100, "Unknown publish distribution target type [" + sTargetType + "]!");
        }
        IFileDistristributor distributor = targetType.createDistributor();
        try {
            distributor.setTargetRoot(_distribution);
        }
        catch (Exception e) {
            throw new WCMException(220, "Failed to create file distributors!", e);
        }
        return distributor;
    }

    public PublishDistributionMgr() {
        try {
            this.m_oCache = (PublishDistributionCacheMgr)DreamFactory.createObjectById("PublishDistributionCacheMgr");
            MAXTARGETS_EACHFOLDER = PublishServerConfigMapper.getDistributionConfig().getMaxTargetsEachFolder();
        }
        catch (Exception ex) {
            s_logger.error((Object)"Failed to load publish distribution config!", (Throwable)ex);
        }
    }

    public void save(PublishDistribution _distribution) throws WCMException {
        if (_distribution == null) {
            throw new WCMException(10, "Valid distribution required!");
        }
        if (_distribution.isAddMode()) {
            String sSql = "SELECT COUNT(*) FROM " + _distribution.getDbTableName() + " WHERE FolderId=" + _distribution.getFolderId() + " AND FolderType=" + _distribution.getFolderType();
            int nExisted = DBManager.getDBManager().sqlExecuteIntQuery(sSql);
            if (nExisted >= MAXTARGETS_EACHFOLDER) {
                throw new WCMException(1100, I18NMessage.get(PublishDistributionMgr.class, "PublishDistributionMgr.label1", "\u5206\u53d1\u76ee\u6807\u5df2\u8d85\u8fc7\u8bbe\u7f6e\u7684\u6700\u5927\u6570[") + MAXTARGETS_EACHFOLDER + I18NMessage.get(PublishDistributionMgr.class, "PublishDistributionMgr.label2", "],\u4e0d\u80fd\u518d\u6dfb\u52a0\u5206\u53d1\u8bbe\u7f6e!"));
            }
        }
        _distribution.save(ContextHelper.getLoginUser());
    }

    public void delete(PublishDistribution _distribution) throws WCMException {
        if (_distribution == null) {
            throw new WCMException(10, "Valid distribution required!");
        }
        _distribution.delete(ContextHelper.getLoginUser());
    }

    public PublishDistributions getDistributionsOf(IPublishFolder _folder, boolean _bExcludingDisabled, WCMFilter _filter) throws WCMException {
        if (_folder == null) {
            throw new WCMException(10, "Valid publish folder required!");
        }
        try {
            String sWhere = "FOLDERID=" + _folder.getId() + " AND FOLDERTYPE=" + _folder.getType();
            if (_bExcludingDisabled) {
                sWhere = sWhere + " AND ENABLED=1";
            }
            PublishDistributions distributions = new PublishDistributions(ContextHelper.getLoginUser(), MAXTARGETS_EACHFOLDER, 1);
            WCMFilter aFilter = new WCMFilter("", sWhere, "");
            aFilter.mergeWith(_filter);
            distributions.open(aFilter);
            return distributions;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to fetch the publish distribution settings!", ex);
        }
    }
}

