/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.job;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.common.job.Schedule;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;

public class Schedules
extends CMSBaseObjs {
    public Schedules(User _currUser) {
        super(_currUser);
    }

    public Schedules(User _currUser, int initialCapacity, int capacityIncrement) {
        super(_currUser, initialCapacity, capacityIncrement);
    }

    @Override
    protected String getDbTableName() {
        return "WCMSCHEDULE";
    }

    @Override
    public String getIdFieldName() {
        return "SCHID";
    }

    @Override
    public Class getElementClass() {
        return Schedule.class;
    }

    @Override
    public BaseObjs newInstance() throws Exception {
        return new Schedules(this.currUser);
    }

    public Schedule getByName(String _sName) {
        Schedule aSchedule = null;
        int nCount = this.size();
        for (int i = 0; i < nCount; ++i) {
            aSchedule = (Schedule)this.getAt(i);
            if (aSchedule != null && aSchedule.getName().compareTo(_sName) == 0) {
                return aSchedule;
            }
            aSchedule = null;
        }
        this.currIndex = -3;
        return null;
    }

    public static final Schedules findByIds(User _currUser, String _sIds) throws WCMException {
        if (_sIds.length() <= 0) {
            throw new WCMException(10, I18NMessage.get(Schedules.class, "Schedules.label1", "\u6307\u5b9a\u5bf9\u8c61ID\u5e8f\u5217\u65e0\u6548\uff01"));
        }
        return (Schedules)CMSBaseObjs.findWCMObjsByIds(_currUser, Schedules.class, _sIds);
    }

    public static final Schedules openWCMObjs(User _currUser, WCMFilter _filter) throws WCMException {
        return (Schedules)CMSBaseObjs.openWCMObjs(_currUser, Schedules.class, _filter);
    }

    public static Schedules createNewInstance(User _currUser) throws WCMException {
        return (Schedules)CMSBaseObjs.createInstance(_currUser, Schedules.class);
    }

    public static Schedules findUnfinishedSchedules(User _currUser, CMyDateTime _dtTime) throws WCMException {
        String sWhere = "SchMode<>3";
        sWhere = sWhere + " or (SchMode=3 and SCHSTATUS<7 and ETime>=" + DBManager.getDBManager().getDBType().sqlDateTime(_dtTime.toString(), "YYYY-MM-DD HH24:MI:SS") + ")";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        return Schedules.openWCMObjs(_currUser, aFilter);
    }
}

