/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageServer;
import com.trs.components.common.message.Messages;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class MessageServiceProvider
implements IGlueServiceProvider {
    @Override
    public void delete(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        MessageServer.delete(loginUser, _methodContext.getObjectIds());
    }

    @Override
    public Object query(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nReadFlag = _methodContext.getValue("ReadFlag", 1);
        String sMsgTypes = _methodContext.getValue("MsgTypes");
        int[] pMsgType = CMyString.splitToInt(sMsgTypes, ",");
        WCMFilter filter = new WCMFilter();
        StringBuffer sbSQL = new StringBuffer(128);
        sbSQL.append("lower(SendType) like '%message%'");
        if (pMsgType != null) {
            sbSQL.append(" and (");
            sbSQL.append("MsgType=?");
            filter.addSearchValues(0, pMsgType[0]);
            int len = pMsgType.length;
            for (int i = 1; i < len; ++i) {
                sbSQL.append(" or ");
                sbSQL.append("MsgType=?");
                filter.addSearchValues(i, pMsgType[i]);
            }
            sbSQL.append(")");
        }
        filter.setWhere(sbSQL.toString());
        WCMFilter extraFilter = _methodContext.getExtraWCMFilter();
        if (extraFilter != null) {
            filter.mergeWith(extraFilter);
        }
        filter.mergeWith(_methodContext.getExtraWCMFilter());
        return MessageServer.getMessages(nReadFlag, loginUser, filter);
    }

    @Override
    public int save(MethodContext _methodContext) throws Throwable {
        throw new WCMException(1103, I18NMessage.get(MessageServiceProvider.class, "MessageServiceProvider.label1", "\u6d88\u606f\u4e2d\u5fc3\u4e0d\u652f\u6301\u4fdd\u5b58\u64cd\u4f5c!"));
    }

    @Override
    public Object findById(MethodContext _methodContext) throws Throwable {
        int nObjectId;
        User loginUser = this.getLoginUser();
        Message message = MessageServer.findById(loginUser, nObjectId = _methodContext.getObjectId());
        if (message == null) {
            throw new WCMException(1100, I18NMessage.get(MessageServiceProvider.class, "MessageServiceProvider.label2", "\u6307\u5b9a\u7684\u6d88\u606f\u5bf9\u8c61[Id=") + nObjectId + I18NMessage.get(MessageServiceProvider.class, "MessageServiceProvider.label3", "]\u6ca1\u6709\u627e\u5230!"));
        }
        return message;
    }

    @Override
    public Object findByIds(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        return MessageServer.findByIds(loginUser, _methodContext.getObjectIds());
    }

    public boolean hasUnreadMessage(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sMsgTypes = _methodContext.getValue("MsgTypes");
        int[] pMsgType = CMyString.splitToInt(sMsgTypes, ",");
        return MessageServer.hasUnreadMessage(loginUser, pMsgType);
    }

    public int sendMessage(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Message message = Message.createNewInstance();
        WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, message, null);
        message.setReceivers(204, _methodContext.getValue("UserIds"));
        message.setReceivers(201, _methodContext.getValue("GroupIds"));
        message.setReceivers(203, _methodContext.getValue("RoleIds"));
        MessageServer.send(message);
        return message.getId();
    }

    public void setReadFlag(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        boolean bReaded = _methodContext.getValue("Readed", true);
        Messages messages = MessageServer.findByIds(loginUser, _methodContext.getObjectIds());
        int nSize = messages.size();
        for (int i = 0; i < nSize; ++i) {
            Message message = (Message)messages.getAt(i);
            if (message == null) continue;
            MessageServer.setMessageReaded(message, loginUser, bReaded);
        }
    }

    public void clearInbox() throws WCMException {
        User loginUser = this.getLoginUser();
        MessageServer.emptyInbox(loginUser);
    }

    public void clearOutbox() throws WCMException {
        User loginUser = this.getLoginUser();
        MessageServer.emptyOutbox(loginUser);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

