/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.xml.node;

import com.trs.dev4.jdk16.xml.AbstractNode;

public class SimpleNode
extends AbstractNode {
    protected String nodeValue;
    private boolean CDATANeeded = false;

    public SimpleNode(String nodeName, String nodeValue) {
        super(nodeName);
        this.nodeValue = nodeValue;
        this.CDATANeeded = true;
    }

    public SimpleNode(String nodeName, String nodeValue, boolean CDATANeeded) {
        super(nodeName);
        this.nodeValue = nodeValue;
        this.CDATANeeded = CDATANeeded;
    }

    public SimpleNode(String nodeName, int nodeValue) {
        super(nodeName);
        this.nodeValue = String.valueOf(nodeValue);
        this.CDATANeeded = false;
    }

    @Override
    protected boolean hasNodeValue() {
        return this.nodeValue != null && this.nodeValue.length() > 0;
    }

    @Override
    protected String getNodeValue() {
        if (!this.CDATANeeded) {
            return this.nodeValue;
        }
        StringBuffer sb = new StringBuffer(this.nodeValue.length() + 20);
        sb.append("<![CDATA[").append(this.nodeValue).append("]]>");
        return sb.toString();
    }

    public boolean isCDATANeeded() {
        return this.CDATANeeded;
    }

    public void setCDATANeeded(boolean needed) {
        this.CDATANeeded = needed;
    }

    public void setNodeValue(String nodeValue) {
        this.nodeValue = nodeValue;
    }
}

