/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.session.impl;

import com.trs.dev4.jdk16.servlet24.CookieHelper;
import com.trs.dev4.jdk16.servlet24.RequestUtil;
import com.trs.dev4.jdk16.session.ApplicationSessionException;
import com.trs.dev4.jdk16.session.ISessionHandler;
import com.trs.dev4.jdk16.session.ISessionUser;
import com.trs.dev4.jdk16.session.impl.ApplicationSession;
import com.trs.dev4.jdk16.session.impl.SessionIdGenerator;
import com.trs.dev4.jdk16.utils.NetUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class BaseSessionHandler<T extends ISessionUser>
implements ISessionHandler<T> {
    protected static final String SESSION_DENY_COUNT_MAX = "session.deny.countMax";
    protected static final String SESSION_DENY_REMOTE_ADDR = "session.deny.remoteAddr";
    protected static final String SESSION_DENY_DURATION = "session.deny.duration";
    private static final String UCSID_COOKIE_NAME = "UCSID";
    private static final String UCSID_REQUEST_ATTR = "UCSID_REQUEST_ATTR";
    private static final Logger logger = Logger.getLogger(BaseSessionHandler.class);
    private static final String ATTR_VERIFY_CODE = "verifyCode";
    private String sessionIdSuffix = "";
    private String hostAddress = NetUtil.getLocalHostIP();

    public BaseSessionHandler() {
        if (StringHelper.isEmpty(this.sessionIdSuffix)) {
            this.sessionIdSuffix = this.hostAddress.substring(this.hostAddress.lastIndexOf(46));
        }
    }

    @Override
    public T getUser(HttpServletRequest request, HttpServletResponse response) {
        String ucsid = this.getUCSID(request, response);
        ApplicationSession as = this.getApplicationSession(ucsid);
        logger.debug((Object)("Request (" + request.getRequestURI() + ") : ucsid=(" + ucsid + "), as=(" + as + ")"));
        if (as == null) {
            return null;
        }
        return this.getUser(as.getUserName());
    }

    protected String getUCSID(HttpServletRequest request, HttpServletResponse response) {
        return this.getUCSID(request, response, true);
    }

    protected String getUCSID(HttpServletRequest request, HttpServletResponse response, boolean create) {
        CookieHelper cookieHelper = new CookieHelper(request, response, this.getDomain());
        String ucsid = cookieHelper.getValue(UCSID_COOKIE_NAME);
        if (!StringHelper.isEmpty(ucsid)) {
            logger.debug((Object)("Found UCSID(" + ucsid + ") from Cookie."));
            return ucsid;
        }
        ApplicationSession as = (ApplicationSession)request.getAttribute(UCSID_REQUEST_ATTR);
        if (as != null) {
            logger.debug((Object)("Found UCSID(" + as.getId() + ") from RequestAttribute."));
            return as.getId();
        }
        return create ? this.createUCSID() : "";
    }

    protected abstract T getUser(String var1);

    @Override
    public boolean isLogined(HttpServletRequest request, HttpServletResponse response) {
        String ucsid = this.getUCSID(request, response);
        ApplicationSession as = this.getApplicationSession(ucsid);
        logger.debug((Object)("Request (" + request.getRequestURI() + ") : ucsid=(" + ucsid + "), as=(" + as + ")"));
        return as == null ? false : as.isLogined();
    }

    @Override
    public boolean isLogined(String userName) {
        return true;
    }

    @Override
    public void login(HttpServletRequest request, HttpServletResponse response, T user) {
        if (!this.allowLogin(user)) {
            return;
        }
        ApplicationSession as = this.getApplicationSession(request, response, true);
        as.setUserId(user.getId());
        as.setUserName(user.getUserName());
        as.setNickName(user.getNickName());
        as.setRemoteAddr(request.getRemoteAddr());
        logger.debug((Object)("User (" + user.getNickName() + ") logined with as=(" + as.getId() + ")"));
        this.applicationSessionUpdated(as);
        this.userLogin(user, as);
    }

    protected boolean allowLogin(T user) {
        return true;
    }

    protected abstract void userLogin(T var1, ApplicationSession var2);

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response) {
        String ucsid = this.getUCSID(request, response);
        ApplicationSession as = this.getApplicationSession(ucsid);
        if (as == null) {
            logger.error((Object)("Can't found ApplicationSession with UCSID(" + ucsid + ")."));
            return;
        }
        this.applicationSessionDeleted(as);
        T user = this.getUser(as.getUserName());
        if (user != null) {
            logger.error((Object)("Found User(" + user + ") with userName(" + as.getUserName() + ")."));
            this.userLogout(user, as);
        } else {
            logger.error((Object)("Can't found User with userName(" + as.getUserName() + ")."));
        }
        CookieHelper cookieHelper = new CookieHelper(request, response);
        cookieHelper.removeCookie(UCSID_COOKIE_NAME, this.getDomain());
    }

    protected abstract void applicationSessionDeleted(ApplicationSession var1);

    protected abstract void userLogout(T var1, ApplicationSession var2);

    @Override
    public String getUserNick(HttpServletRequest request, HttpServletResponse response) {
        String ucsid = this.getUCSID(request, response);
        ApplicationSession as = this.getApplicationSession(ucsid);
        if (as == null) {
            return "";
        }
        logger.debug((Object)("Request (" + request.getRequestURI() + ") : ucsid=(" + ucsid + "), as=(" + as + ")"));
        return as.getNickName();
    }

    @Override
    public int getUserId(HttpServletRequest request, HttpServletResponse response) {
        String ucsid = this.getUCSID(request, response);
        ApplicationSession as = this.getApplicationSession(ucsid);
        if (as == null) {
            logger.info((Object)("Request (" + request.getRequestURI() + ") : ucsid=(" + ucsid + ") without ApplicationSession."));
            return -1;
        }
        logger.debug((Object)("Request (" + request.getRequestURI() + ") : ucsid=(" + ucsid + "), as=(" + as.toString() + ")"));
        return as.getUserId();
    }

    @Override
    public boolean isVerified(HttpServletRequest request, HttpServletResponse response) {
        String verifyCode = request.getParameter(ATTR_VERIFY_CODE);
        if (StringHelper.isEmpty(verifyCode)) {
            return true;
        }
        String ucsid = this.getUCSID(request, response);
        ApplicationSession as = this.getApplicationSession(ucsid);
        logger.debug((Object)("Verify verifyCode (" + as.getVerifyCode() + ") with verifyCode/parameter(" + verifyCode + ")."));
        return verifyCode.equalsIgnoreCase(as.getVerifyCode());
    }

    @Override
    public void setVerifyCode(HttpServletRequest request, HttpServletResponse response, String verifyCode) {
        String ucsid = this.getUCSID(request, response);
        ApplicationSession as = this.getApplicationSession(ucsid);
        as.setVerifyCode(verifyCode);
        logger.debug((Object)("ApplicationSession (" + as.toString() + ") updated with verifyCode(" + verifyCode + ")."));
        this.applicationSessionUpdated(as);
    }

    protected abstract void applicationSessionUpdated(ApplicationSession var1);

    @Override
    public boolean isOnline(String userName) {
        return false;
    }

    protected ApplicationSession buildApplicationSession(String ucsid, String remoteAddr) {
        ApplicationSession as = ApplicationSession.buildAnonymousApplicationSession(ucsid, remoteAddr);
        as.setHostAddress(this.getHostAddress());
        this.applicationSessionCreated(as);
        return as;
    }

    protected String getHostAddress() {
        return this.hostAddress;
    }

    protected abstract void applicationSessionCreated(ApplicationSession var1);

    private String createUCSID() {
        return new SessionIdGenerator(this.getUCSIDSuffix()).generateSessionId();
    }

    protected String getUCSIDSuffix() {
        return this.sessionIdSuffix;
    }

    @Override
    public Map<String, Object> statistic() {
        HashMap<String, Object> statistic = new HashMap<String, Object>();
        return statistic;
    }

    @Override
    public ApplicationSession getApplicationSession(HttpServletRequest request, HttpServletResponse response, boolean create) {
        CookieHelper cookieHelper = new CookieHelper(request, response, this.getDomain());
        ApplicationSession as = null;
        String ucsid = cookieHelper.getValue(UCSID_COOKIE_NAME);
        logger.debug((Object)("Found UCSID(" + ucsid + ") with Cookie."));
        if (!StringHelper.isEmpty(ucsid)) {
            as = this.getApplicationSession(ucsid);
        }
        as = as == null ? (ApplicationSession)request.getAttribute(UCSID_REQUEST_ATTR) : as;
        String requestUrl = RequestUtil.getRelativePath(request);
        if (create && as == null) {
            ucsid = this.createUCSID();
            String remoteAddr = RequestUtil.getClientIP(request);
            logger.debug((Object)("New UCSID (" + ucsid + ") created for remoteAddr(" + remoteAddr + ")."));
            as = this.buildApplicationSession(ucsid, remoteAddr);
            as.setConsole(requestUrl.startsWith("/console"));
            cookieHelper.addCookie(UCSID_COOKIE_NAME, as.getId());
            request.setAttribute(UCSID_REQUEST_ATTR, (Object)as);
        }
        return as;
    }

    protected boolean isSessionLimitUrl(String remoteAddr, String requestUrl) {
        String[] limitUrlPrefixes = this.getSessionLimitUrlPrefixes();
        if (limitUrlPrefixes.length <= 0) {
            return false;
        }
        String[] stringArray = limitUrlPrefixes;
        int n = limitUrlPrefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String limitUrlPrefix = stringArray[n2];
            if (requestUrl.startsWith(limitUrlPrefix)) {
                logger.debug((Object)("RequestUrl(" + requestUrl + ") starts with (" + limitUrlPrefix + ")."));
                return true;
            }
            logger.debug((Object)("RequestUrl(" + requestUrl + ") not starts with (" + limitUrlPrefix + ")."));
            ++n2;
        }
        return false;
    }

    protected String[] getSessionLimitUrlPrefixes() {
        return new String[0];
    }

    protected boolean assertSessionCount() {
        return true;
    }

    protected boolean assertRemoteAddr(String remoteAddr) {
        return true;
    }

    protected String getRedirectUrl(String reason) {
        return "";
    }

    protected boolean assertDuration(String applicationSessionId) {
        return true;
    }

    protected String getDomain() {
        return null;
    }

    @Override
    public void updateLastModified(ApplicationSession as) {
        as.access();
        this.applicationSessionUpdated(as);
    }

    @Override
    public T getUser(HttpServletRequest request) {
        String ucsid = this.getUCSID(request, null);
        ApplicationSession as = this.getApplicationSession(ucsid);
        logger.debug((Object)("Request (" + request.getRequestURI() + ") : ucsid=(" + ucsid + "), as=(" + as + ")"));
        return as != null ? (T)this.getUser(as.getUserName()) : null;
    }

    @Override
    public String getApplicationSessionId(HttpServletRequest request, HttpServletResponse response, boolean create) {
        return this.getUCSID(request, response, create);
    }

    @Override
    public boolean ignoreUrl(HttpServletRequest request, HttpServletResponse response) {
        String[] ignoreUrls = this.getIgnoreUrls();
        if (ignoreUrls.length <= 0) {
            return false;
        }
        String requestUrl = RequestUtil.getRelativePath(request);
        String[] stringArray = ignoreUrls;
        int n = ignoreUrls.length;
        int n2 = 0;
        while (n2 < n) {
            String ignoreUrl = stringArray[n2];
            if (requestUrl.startsWith(ignoreUrl)) {
                logger.debug((Object)("RequestUrl(" + requestUrl + ") starts with (" + ignoreUrl + ")."));
                return true;
            }
            logger.debug((Object)("RequestUrl(" + requestUrl + ") not starts with (" + ignoreUrl + ")."));
            ++n2;
        }
        return false;
    }

    protected String[] getIgnoreUrls() {
        return new String[0];
    }

    @Override
    public int countTotalUsers() {
        return 0;
    }

    @Override
    public int countLoginedUsers() {
        return 0;
    }

    @Override
    public boolean canProcess(HttpServletRequest request, HttpServletResponse response) {
        if (!this.assertDuration(this.getApplicationSessionId(request, response, false))) {
            throw new ApplicationSessionException(SESSION_DENY_DURATION, this.getRedirectUrl(SESSION_DENY_DURATION));
        }
        String remoteAddr = RequestUtil.getClientIP(request);
        if (!this.assertRemoteAddr(remoteAddr)) {
            throw new ApplicationSessionException(SESSION_DENY_REMOTE_ADDR, this.getRedirectUrl(SESSION_DENY_REMOTE_ADDR));
        }
        String requestUrl = RequestUtil.getRelativePath(request);
        if (!requestUrl.startsWith("/console") && this.assertSessionCount()) {
            throw new ApplicationSessionException(SESSION_DENY_COUNT_MAX, this.getRedirectUrl(SESSION_DENY_COUNT_MAX));
        }
        return true;
    }
}

