/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl.transport;

import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.impl.ClusterReceiverBase;
import com.trs.infra.cluster.impl.transport.DatagramPacketPool;
import com.trs.infra.cluster.impl.transport.DatagramPacketQueue;
import java.net.DatagramPacket;
import org.apache.log4j.Logger;

public class ReceiverByUDP
extends ClusterReceiverBase {
    private static final Logger s_logger;
    private long readBytes;
    private int readBytesHalf;
    private DatagramPacketQueue dataPacketQueue;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.impl.transport.ReceiverByUDP");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    protected ReceiverByUDP(String name, DatagramPacketQueue dataPacketQueue) {
        super(name);
        this.dataPacketQueue = dataPacketQueue;
    }

    public ReceiverByUDP(DatagramPacketQueue dataPacketQueue) {
        this("ReceiverByUDP", dataPacketQueue);
    }

    protected void doReceive() {
        DatagramPacketPool.CDP cdp = null;
        while ((cdp = this.dataPacketQueue.get()) != null) {
            this.doReceive(cdp.getDatePacket());
            cdp.reuse();
        }
    }

    private final void doReceive(DatagramPacket datePacket) {
        byte[] buffer = datePacket.getData();
        int offset = datePacket.getOffset();
        int length = datePacket.getLength();
        this.incSendBytes(length);
        ClusterMessage message = this.getMessageFromHeader(buffer);
        if (message == null) {
            return;
        }
        message.setSourceAddress(datePacket.getAddress());
        message.setSourcePort(datePacket.getPort());
        message.stuffBody(buffer, offset);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("UDP receive:" + message));
        }
        this.dispatch(message, null);
    }

    protected long getReadBytes() {
        return this.readBytes + (long)this.readBytesHalf;
    }

    private final void incSendBytes(int value) {
        int temp = this.readBytesHalf + value;
        if (temp > 0) {
            this.readBytesHalf = temp;
            return;
        }
        this.readBytesHalf = 0;
        this.readBytes = this.readBytes + (long)this.readBytesHalf + (long)value;
    }

    public Member getRemoteMember() {
        return null;
    }

    protected void startup() {
    }

    protected void cleanup() {
        this.dataPacketQueue = null;
    }
}

