/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class OSSClientTest {
    @Test
    public void testGeneratePresignedUrl() throws IOException {
        OSSClient client = new OSSClient("oss.aliyuncs.com", "id", "key");
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest("bucket", "key");
        Calendar ex = Calendar.getInstance();
        ex.set(2015, 1, 1, 0, 0, 0);
        Date expiration = ex.getTime();
        request.setExpiration(expiration);
        request.setContentMD5("md5");
        request.setContentType("type");
        Assert.assertEquals((Object)request.getContentType(), (Object)"type");
        Assert.assertEquals((Object)request.getContentMD5(), (Object)"md5");
        URL url = client.generatePresignedUrl(request);
        Assert.assertEquals((Object)url.getPath(), (Object)"/key");
        Assert.assertEquals((Object)url.getAuthority(), (Object)"bucket.oss.aliyuncs.com");
        Assert.assertEquals((Object)url.getHost(), (Object)"bucket.oss.aliyuncs.com");
        Assert.assertEquals((long)url.getDefaultPort(), (long)80L);
        Assert.assertEquals((Object)url.getProtocol(), (Object)"http");
        Assert.assertEquals((Object)url.getQuery(), (Object)"Expires=1422720000&OSSAccessKeyId=id&Signature=XA8ThdVKdJQ4vlkoggdzCs5s1RY%3D");
        Assert.assertEquals((Object)url.getFile(), (Object)"/key?Expires=1422720000&OSSAccessKeyId=id&Signature=XA8ThdVKdJQ4vlkoggdzCs5s1RY%3D");
        request.setContentMD5("md5'");
        url = client.generatePresignedUrl(request);
        Assert.assertTrue((!url.getQuery().equals("Expires=1422720000&OSSAccessKeyId=id&Signature=XA8ThdVKdJQ4vlkoggdzCs5s1RY%3D") ? 1 : 0) != 0);
        request.setContentMD5("md5'");
        url = client.generatePresignedUrl(request);
        Assert.assertTrue((!url.getQuery().equals("Expires=1422720000&OSSAccessKeyId=id&Signature=XA8ThdVKdJQ4vlkoggdzCs5s1RY%3D") ? 1 : 0) != 0);
        request.setContentType("type'");
        request.setContentMD5("md5");
        url = client.generatePresignedUrl(request);
        Assert.assertTrue((!url.getQuery().equals("Expires=1422720000&OSSAccessKeyId=id&Signature=XA8ThdVKdJQ4vlkoggdzCs5s1RY%3D") ? 1 : 0) != 0);
    }
}

