/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyException;
import com.trs.tools.JSLocaleCollector;
import com.trs.tools.JSLocaleLoader;
import com.trs.tools.JSLocaleProperties;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class JSLocaleCollectorBridge {
    private static Logger logger = Logger.getLogger(JSLocaleCollectorBridge.class);
    private JSLocaleCollector collector;
    private JSLocaleLoader loader;
    private String m_sOutputFileWithLocale;
    private String m_sOutputFileNoLocale;
    private Map m_mapLocaleResult = new TreeMap(new Comparator(){

        public int compare(Object o1, Object o2) {
            String pair1 = (String)o1;
            String pair2 = (String)o2;
            return pair1.compareTo(pair2);
        }
    });
    private Map m_mapNoLocaleResult = new TreeMap(new Comparator(){

        public int compare(Object o1, Object o2) {
            String pair1 = (String)o1;
            String pair2 = (String)o2;
            return pair1.compareTo(pair2);
        }
    });

    public JSLocaleCollectorBridge(String sRootPath, String sOutputFileWithLocale, String sOutputFileNoLocale) throws CMyException {
        this.collector = new JSLocaleCollector(sRootPath, sOutputFileWithLocale);
        this.loader = new JSLocaleLoader();
        this.loader.loadLocales();
        this.m_sOutputFileWithLocale = sOutputFileWithLocale;
        this.m_sOutputFileNoLocale = sOutputFileNoLocale;
    }

    private String getENByCN(String sChinese) {
        String sLabel = this.loader.getLableByCN(sChinese);
        if (sLabel == null) {
            return null;
        }
        return this.loader.getENByLabel(sLabel);
    }

    private String getLabelByCN(String sChinese) {
        return this.loader.getLableByCN(sChinese);
    }

    public void analyze() throws CMyException {
        Map properties = this.collector.analyze();
        int nNum = 0;
        for (Map.Entry entry : properties.entrySet()) {
            String sChineseKey = (String)entry.getKey();
            String sEN = this.getENByCN(sChineseKey);
            if (sEN == null) {
                logger.error((Object)(++nNum + ":\u4e2d\u6587\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u82f1\u6587:[" + sChineseKey + "],label\u4e3a\uff1a[" + this.getLabelByCN(sChineseKey) + "]"));
                this.m_mapNoLocaleResult.put(sChineseKey, "");
                continue;
            }
            this.m_mapLocaleResult.put(sChineseKey, sEN);
        }
        JSLocaleProperties.store(this.m_sOutputFileWithLocale, this.m_mapLocaleResult);
        JSLocaleProperties.store(this.m_sOutputFileNoLocale, this.m_mapNoLocaleResult);
    }

    public static void main(String[] args) throws CMyException {
        if (args.length < 3) {
            StringBuffer sbInfo = new StringBuffer(200);
            sbInfo.append("\u6307\u5b9a\u7684\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u9700\u8981\u4e09\u4e2a\u53c2\u6570\n");
            sbInfo.append("\u7b2c\u4e00\u4e2a\u53c2\u6570\u6307\u5b9a\u9700\u8981\u5904\u7406\u7684\u76ee\u5f55\uff1a\n");
            sbInfo.append("\t\t\u5982\uff1a\n");
            sbInfo.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/WebApp/app");
            sbInfo.append("\n\u7b2c\u4e8c\u4e2a\u53c2\u6570\u6307\u5b9a\u751f\u6210\u7684\u8d44\u6e90\u6587\u4ef6\u5168\u8def\u5f84\uff1a\n");
            sbInfo.append("\t\t\u5982\uff1a\n");
            sbInfo.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/WebApp/WEB-INF/wcm6-locale/js_en_translated.properties");
            sbInfo.append("\n\u7b2c\u4e09\u4e2a\u53c2\u6570\u6307\u5b9a\u751f\u6210\u7684\u8d44\u6e90\u6587\u4ef6\u5168\u8def\u5f84\uff1a\n");
            sbInfo.append("\t\t\u5982\uff1a\n");
            sbInfo.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/WebApp/WEB-INF/wcm6-locale/js_en_4_translation.properties");
            logger.error((Object)sbInfo);
            return;
        }
        JSLocaleCollectorBridge instance = new JSLocaleCollectorBridge(args[0], args[1], args[2]);
        instance.analyze();
    }
}

