/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.CMyParameter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CMyXMLElement {
    private List m_ltChildren = new ArrayList();
    private Map m_hmProperties = new HashMap();
    private List m_ltProperties = new ArrayList();
    private String m_sName = "";
    private static Logger s_logger = Logger.getLogger(CMyXMLElement.class);

    public void clear() {
        this.m_ltChildren.clear();
        this.m_hmProperties.clear();
        this.m_ltProperties.clear();
    }

    public List getChildren() {
        return this.m_ltChildren;
    }

    public boolean addChild(CMyXMLElement _config) {
        if (_config == null) {
            return false;
        }
        this.m_ltChildren.add(this.m_ltChildren.size(), _config);
        return true;
    }

    public Iterator getPropertyNames() {
        if (this.m_hmProperties == null || this.m_hmProperties.size() <= 0) {
            return null;
        }
        Iterator itNames = this.m_hmProperties.keySet().iterator();
        return itNames;
    }

    public String getProperty(String _sPropertyName) {
        if (_sPropertyName == null) {
            return null;
        }
        String sName = _sPropertyName.trim();
        if (sName.length() == 0) {
            return null;
        }
        return (String)this.m_hmProperties.get(sName.toLowerCase());
    }

    public String getPropertyTrim(String _sName) {
        String sValue = this.getProperty(_sName);
        return sValue == null ? null : sValue.trim();
    }

    public String getPropertyTrim(String _sName, String _sDefault) {
        String sValue = this.getProperty(_sName);
        if (sValue != null && (sValue = sValue.trim()).length() > 0) {
            return sValue;
        }
        return _sDefault;
    }

    public String getRequiredPropertyTrim(String _sName) throws WCMException {
        String sValue = this.getPropertyTrim(_sName);
        if (sValue == null || sValue.length() == 0) {
            throw new WCMException(153, "Property '" + _sName + "' is required!");
        }
        return sValue;
    }

    public boolean setProperty(String _sPropertyName, String _sValue) {
        if (_sValue == null) {
            return false;
        }
        this.m_hmProperties.put(_sPropertyName.toLowerCase(), _sValue);
        this.addToPropertyList(_sPropertyName, _sValue);
        return true;
    }

    private void addToPropertyList(String _sPropertyName, String _sValue) {
        CMyParameter aParam = new CMyParameter(_sPropertyName, _sValue);
        this.m_ltProperties.add(aParam);
    }

    public String getName() {
        return this.m_sName;
    }

    public boolean setName(String _sName) {
        if (_sName == null || (_sName = _sName.trim()).length() == 0) {
            return false;
        }
        this.m_sName = _sName.toLowerCase();
        return true;
    }

    public boolean setProperties(HashMap _properties) {
        if (_properties == null || _properties.size() <= 0) {
            return false;
        }
        Iterator itKeys = _properties.keySet().iterator();
        String sKey = "";
        String sValue = "";
        while (itKeys.hasNext()) {
            sKey = (String)itKeys.next();
            sValue = (String)_properties.get(sKey);
            if (sValue == null) continue;
            this.setProperty(sKey, sValue);
        }
        return false;
    }

    public List getChildren(String _sChildName) {
        if (_sChildName == null || (_sChildName = _sChildName.trim()).length() <= 0) {
            return null;
        }
        AbstractList children = new LinkedList();
        children = new ArrayList();
        String sChildName = _sChildName.toLowerCase();
        int nLength = this.m_ltChildren.size();
        CMyXMLElement aChild = null;
        for (int i = 0; i < nLength; ++i) {
            aChild = (CMyXMLElement)this.m_ltChildren.get(i);
            if (!aChild.getName().equals(sChildName)) continue;
            children.add(aChild);
        }
        return children;
    }

    public CMyXMLElement getChild(String _sChildName) {
        if (_sChildName == null || (_sChildName = _sChildName.trim()).length() <= 0) {
            return null;
        }
        String sChildName = _sChildName;
        List children = this.getChildren(sChildName);
        return children == null || children.size() <= 0 ? null : children.get(0);
    }

    public Map getProperties() {
        return this.m_hmProperties;
    }

    public List getPropertiesList() {
        return this.m_ltProperties;
    }

    public int getPropertyAsInt(String _sName, int _nDefault) {
        String sValue = this.getProperty(_sName);
        if (sValue == null || (sValue = sValue.trim()).length() == 0) {
            return _nDefault;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (Exception ex) {
            s_logger.error((Object)(I18NMessage.get(CMyXMLElement.class, "CMyXMLElement.label1", "\u5c5e\u6027[") + _sName + I18NMessage.get(CMyXMLElement.class, "CMyXMLElement.label2", "]\u7684\u503c[") + sValue + I18NMessage.get(CMyXMLElement.class, "CMyXMLElement.label3", "]\u4e0d\u662f\u6574\u578b\u6570\uff01")), (Throwable)ex);
            return _nDefault;
        }
    }

    public boolean getPropertyAsBoolean(String _sName, boolean _bDefault) {
        String sValue = this.getProperty(_sName);
        if (sValue == null || (sValue = sValue.trim()).length() == 0) {
            return _bDefault;
        }
        return sValue.equalsIgnoreCase("true");
    }
}

