/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.ContentStyles;
import com.trs.components.common.publish.widget.IContentStyleMgr;
import com.trs.components.common.publish.widget.IStyleItemMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.StyleHelper;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.components.common.publish.widget.StyleRepeatNameHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;

public class ContentStyleMgr
implements IContentStyleMgr {
    private IStyleItemMgr m_oStyleItemMgr = (IStyleItemMgr)DreamFactory.createObjectById("IStyleItemMgr");

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public void delete(User _currUser, ContentStyle _contentStyle) throws WCMException {
        if (_contentStyle == null) {
            return;
        }
        this.m_oStyleItemMgr.delete(_currUser, _contentStyle);
        _contentStyle.delete(_currUser);
    }

    @Override
    public String makeCssContent(ContentStyle _contentStyle) throws WCMException {
        if (_contentStyle == null) {
            return "";
        }
        String sCustomStyle = _contentStyle.getCustomStyle();
        if (sCustomStyle != null && !sCustomStyle.trim().equals("")) {
            return StyleHelper.makeCustomCssContent(_contentStyle.getCssFlag(), sCustomStyle);
        }
        String sTemplateName = _contentStyle.getTemplate();
        if (sTemplateName == null || sTemplateName.equals("")) {
            throw new WCMException("\u83b7\u53d6\u5185\u5bb9\u53ef\u7528\u98ce\u683c\u6a21\u677f\u540d\u79f0\u5931\u8d25\uff01sTemplateName=[" + sTemplateName + "]");
        }
        String sCSSTemplateFile = StylePathHelper.getCssTemplateFilePath() + sTemplateName;
        String sCSSTemplateContent = "";
        try {
            sCSSTemplateContent = CMyFile.readFile(sCSSTemplateFile, "utf-8");
        }
        catch (CMyException e) {
            e.printStackTrace();
        }
        if (sCSSTemplateContent == null) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5931\u8d25\uff01" + sTemplateName);
        }
        if (sCSSTemplateContent.trim().equals("")) {
            throw new WCMException("\u83b7\u53d6\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\uff01" + sTemplateName);
        }
        StyleItems styleItems = this.m_oStyleItemMgr.queryStyleItems(_contentStyle, null);
        return StyleHelper.makeCSSContent(_contentStyle.getCssFlag(), sCSSTemplateContent, styleItems);
    }

    @Override
    public ContentStyles query(PageStyle pageStyle, WCMFilter _filter) throws WCMException {
        int nPageStyleId = pageStyle == null ? 0 : pageStyle.getId();
        WCMFilter filter = new WCMFilter("", "PageStyleId=?", "");
        filter.addSearchValues(nPageStyleId);
        if (_filter != null) {
            filter.mergeWith(_filter);
        }
        return ContentStyles.openWCMObjs(this.getLoginUser(), filter);
    }

    @Override
    public ContentStyle save(User _currUser, ContentStyle _contentStyle) throws WCMException {
        if (_contentStyle == null) {
            throw new WCMException("\u8981\u4fdd\u5b58\u7684\u5bf9\u8c61\u4e3a\u7a7a!ContentStyle=[" + _contentStyle + "]");
        }
        if (_contentStyle.isAddMode()) {
            _contentStyle.insert(_currUser);
        } else {
            _contentStyle.update(_currUser);
        }
        return _contentStyle;
    }

    @Override
    public ContentStyle copy(User _currUser, PageStyle _targetPageStyle, ContentStyle _sourceContentStyle) throws WCMException {
        if (_sourceContentStyle == null) {
            return null;
        }
        int nTargetPageStyleId = 0;
        if (_targetPageStyle != null) {
            nTargetPageStyleId = _targetPageStyle.getId();
        }
        ContentStyle copyContentStyle = (ContentStyle)_sourceContentStyle.cloneToNewObj();
        copyContentStyle.setPageStyleId(nTargetPageStyleId);
        copyContentStyle.setSrcContentStyleId(_sourceContentStyle.getId());
        if (_sourceContentStyle.getPageStyleId() == 0 || nTargetPageStyleId == 0) {
            copyContentStyle.setIsPrivate(0);
        } else {
            copyContentStyle.setIsPrivate(1);
        }
        if (nTargetPageStyleId == _sourceContentStyle.getPageStyleId()) {
            copyContentStyle.setCssFlag(this.makeCssFlag(_targetPageStyle));
        }
        this.save(_currUser, copyContentStyle);
        StyleItems styleItems = this.m_oStyleItemMgr.queryStyleItems(_sourceContentStyle, null);
        for (int i = 0; i < styleItems.size(); ++i) {
            StyleItem styleItem = (StyleItem)styleItems.getAt(i);
            if (styleItem == null) continue;
            StyleItem copyStyleItem = (StyleItem)styleItem.cloneToNewObj();
            this.m_oStyleItemMgr.save(_currUser, copyContentStyle, copyStyleItem);
        }
        return copyContentStyle;
    }

    @Override
    public ContentStyle copy(User _currUser, PageStyle _targetPageStyle, ContentStyle _sourceContentStyle, int _nCopyMode, Reports oCopyReports) throws WCMException {
        if (_sourceContentStyle == null) {
            return null;
        }
        int nTargetPageStyleId = 0;
        if (_targetPageStyle != null) {
            nTargetPageStyleId = _targetPageStyle.getId();
        }
        ContentStyle copyContentStyle = (ContentStyle)_sourceContentStyle.cloneToNewObj();
        String sInfo = _targetPageStyle == null ? "\u7cfb\u7edf\u5185\u5bb9\u98ce\u683c" : "\u9875\u9762\u98ce\u683c\u3010" + _targetPageStyle.getStyleDesc() + "\u3011";
        ContentStyle oSameCssFlagContentStyle = ContentStyles.findByCssFlagAndPageStyle(_currUser, copyContentStyle.getCssFlag(), nTargetPageStyleId);
        if (oSameCssFlagContentStyle != null) {
            String sCssFlag = oSameCssFlagContentStyle.getCssFlag();
            String sStyleName = oSameCssFlagContentStyle.getStyleName();
            String sNewCssFlag = StyleRepeatNameHelper.processCssFlag(sCssFlag, _nCopyMode, 3, nTargetPageStyleId);
            String sNewStyleName = StyleRepeatNameHelper.processStyleName(sStyleName, _nCopyMode, 3, nTargetPageStyleId);
            if (sNewCssFlag == null) {
                oCopyReports.addSucessedReport(CMyString.format("\u5ffd\u7565\u5c06\u5185\u5bb9\u98ce\u683c{0}\u590d\u5236\u5230{1}!", new String[]{sCssFlag, sInfo}));
                return null;
            }
            if (sNewCssFlag.equals(sCssFlag)) {
                this.delete(this.getLoginUser(), oSameCssFlagContentStyle);
                oCopyReports.addSucessedReport(CMyString.format("\u8986\u76d6\u4e86{0}\u4e0b\u540c\u540d\u7684\u5185\u5bb9\u98ce\u683c!", new String[]{sInfo}));
            } else {
                copyContentStyle.setCssFlag(sNewCssFlag);
                copyContentStyle.setStyleName(sNewStyleName);
                copyContentStyle.setStyleDesc(sNewStyleName);
                oCopyReports.addSucessedReport(CMyString.format("\u590d\u5236\u5185\u5bb9\u98ce\u683c\u5230{0}\u6210\u529f!", new String[]{sInfo}));
            }
        }
        copyContentStyle.setPageStyleId(nTargetPageStyleId);
        copyContentStyle.setSrcContentStyleId(_sourceContentStyle.getId());
        if (_sourceContentStyle.getPageStyleId() == 0 || nTargetPageStyleId == 0) {
            copyContentStyle.setIsPrivate(0);
        } else {
            copyContentStyle.setIsPrivate(1);
        }
        if (nTargetPageStyleId == _sourceContentStyle.getPageStyleId()) {
            copyContentStyle.setCssFlag(this.makeCssFlag(_targetPageStyle));
        }
        this.save(_currUser, copyContentStyle);
        StyleItems styleItems = this.m_oStyleItemMgr.queryStyleItems(_sourceContentStyle, null);
        for (int i = 0; i < styleItems.size(); ++i) {
            StyleItem styleItem = (StyleItem)styleItems.getAt(i);
            if (styleItem == null) continue;
            StyleItem copyStyleItem = (StyleItem)styleItem.cloneToNewObj();
            this.m_oStyleItemMgr.save(_currUser, copyContentStyle, copyStyleItem);
        }
        if (oSameCssFlagContentStyle == null) {
            oCopyReports.addSucessedReport(CMyString.format("\u590d\u5236\u5185\u5bb9\u98ce\u683c\u5230{0}\u6210\u529f!", new String[]{sInfo}));
        }
        return copyContentStyle;
    }

    private String makeCssFlag(PageStyle _pageStyle) throws WCMException {
        ContentStyles contentStyles = this.queryContenetStyles(_pageStyle);
        if (contentStyles.size() < 10) {
            return "f0" + contentStyles.size();
        }
        return "f" + contentStyles.size();
    }

    @Override
    public ContentStyles queryContenetStyles(PageStyle _pageStyle) throws WCMException {
        int nPageStyleId = _pageStyle == null ? 0 : _pageStyle.getId();
        WCMFilter filter = new WCMFilter("", "PageStyleId=?", "");
        filter.addSearchValues(nPageStyleId);
        return ContentStyles.openWCMObjs(this.getLoginUser(), filter);
    }

    @Override
    public boolean checkCssFlag(PageStyle _pageStyle, ContentStyle _currContentStyle, String _cssFlag) throws WCMException {
        int nPageStyleId = _pageStyle == null ? 0 : _pageStyle.getId();
        WCMFilter filter = new WCMFilter("", "PageStyleId=? and CssFlag='" + _cssFlag + "'", "");
        filter.addSearchValues(nPageStyleId);
        ContentStyles contentStyles = ContentStyles.openWCMObjs(this.getLoginUser(), filter);
        if (_currContentStyle != null) {
            contentStyles.remove(_currContentStyle, false);
        }
        return contentStyles == null || contentStyles.isEmpty();
    }

    @Override
    public boolean checkStyleName(PageStyle _pageStyle, ContentStyle _currContentStyle, String _styleName) throws WCMException {
        int nPageStyleId = _pageStyle == null ? 0 : _pageStyle.getId();
        WCMFilter filter = new WCMFilter("", "PageStyleId=? and StyleName='" + _styleName + "'", "");
        filter.addSearchValues(nPageStyleId);
        ContentStyles contentStyles = ContentStyles.openWCMObjs(this.getLoginUser(), filter);
        if (_currContentStyle != null) {
            contentStyles.remove(_currContentStyle, false);
        }
        return contentStyles == null || contentStyles.isEmpty();
    }

    @Override
    public ContentStyles findByCssFlagAndPageStyle(String _sCssFlag, PageStyle _oPageStyle) throws WCMException {
        int nPageStyleId = 0;
        if (_oPageStyle != null) {
            nPageStyleId = _oPageStyle.getId();
        }
        String sWhereForContentStyle = "CssFlag='" + _sCssFlag + "'";
        if (nPageStyleId > 0) {
            sWhereForContentStyle = sWhereForContentStyle + " and PageStyleId=" + nPageStyleId;
        }
        WCMFilter filterForContentStyle = new WCMFilter("", sWhereForContentStyle, "");
        ContentStyles _oContentStyles = ContentStyles.openWCMObjs(this.getLoginUser(), filterForContentStyle);
        return _oContentStyles;
    }

    public ContentStyles findByStyleNameAndPageStyle(String _sStyleName, PageStyle _oPageStyle) throws WCMException {
        int nPageStyleId = 0;
        if (_oPageStyle != null) {
            nPageStyleId = _oPageStyle.getId();
        }
        String sWhereForContentStyle = "StyleName='" + _sStyleName + "'";
        if (nPageStyleId > 0) {
            sWhereForContentStyle = sWhereForContentStyle + " and PageStyleId=" + nPageStyleId;
        }
        WCMFilter filterForContentStyle = new WCMFilter("", sWhereForContentStyle, "");
        ContentStyles _oContentStyles = ContentStyles.openWCMObjs(this.getLoginUser(), filterForContentStyle);
        return _oContentStyles;
    }
}

