/*
 * Decompiled with CFR 0.152.
 */
package com.trs.bigfile;

import com.trs.bigfile.BFPartDataHelper;
import com.trs.bigfile.BigFilePart;
import com.trs.bigfile.BigFileParts;
import com.trs.bigfile.PartData;
import com.trs.bigfile.RandPartDigest;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.BASE64DecoderStream;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyEncrypt;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileWrapper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;

public class FileUploadHelper {
    private static final Logger LOG = Logger.getLogger(FileUploadHelper.class);
    public static final int PART_SIZE = 524288;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static volatile FileUploadHelper instance;
    private static final Set ALLOW_UPLOAD_FILES;
    private static final int WRITE_RETRY_TIMES = 5;
    private static final int MAX_UPLOAD_TRY = 10;
    private static final int ONE_MEGBYTE = 0x100000;
    private final FileStore BF_DIR;

    private FileUploadHelper() {
        ConfigServer server = ConfigServer.getServer();
        String suffix = server.getInitProperty("FILE_UPLOAD_ALLOW_SUFFIX");
        if (suffix == null) {
            LOG.warn((Object)"No config: FILE_UPLOAD_ALLOW_SUFFIX");
            suffix = "";
        }
        suffix = suffix.toLowerCase();
        ALLOW_UPLOAD_FILES.addAll(Arrays.asList(suffix.split(",")));
        String dir = server.getInitProperty("BF");
        if (dir == null) {
            dir = "";
            LOG.fatal((Object)"Error, the bigfiles dir did not config properly.");
        }
        this.BF_DIR = new FileService(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileUploadHelper getInstance() {
        if (instance != null) return instance;
        Class<FileUploadHelper> clazz = FileUploadHelper.class;
        synchronized (FileUploadHelper.class) {
            if (instance != null) return instance;
            instance = new FileUploadHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean allowUploadFile(String filename) {
        if (filename == null) {
            return false;
        }
        String fileext = CMyFile.extractFileExt(filename);
        fileext = fileext.toLowerCase();
        return ALLOW_UPLOAD_FILES.contains(fileext);
    }

    public String[] determinUploadedPart(User user, String filename, String fileDigest, long fileSize, boolean bWithSQL) throws WCMException {
        if (bWithSQL) {
            return this.determinUploadedPart(user, filename, fileDigest, fileSize);
        }
        String sSavedFileName = this.getSavedFileName(user.getId(), filename);
        BFPartDataHelper partHelper = new BFPartDataHelper(CMyFile.extractMainFileName(sSavedFileName));
        CMyFile.makeDir(partHelper.BF_PATH, true);
        int unUploadPartIndex = this.getNextPartIndexUnUploded(sSavedFileName, fileDigest);
        int partCount = (int)Math.ceil((double)fileSize / 524288.0);
        if (unUploadPartIndex == 0) {
            FileService bfIndexFile = new FileService(partHelper.BF_PATH, CMyFile.extractMainFileName(sSavedFileName) + ".properties");
            OutputStream fos = null;
            Properties properties = new Properties();
            properties.setProperty("FileDigest", fileDigest);
            properties.setProperty("PartCount", String.valueOf(partCount));
            properties.setProperty("CrUser", user.getName());
            properties.setProperty("CrTime", CMyDateTime.now().toString());
            try {
                fos = bfIndexFile.getOutputStream();
                properties.store(fos, null);
            }
            catch (IOException ex) {
                throw new WCMException("\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef", ex);
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception exception) {}
            }
            CMyFile.makeDir(partHelper.BF_INDEX_PATH, false);
            unUploadPartIndex = 1;
        }
        return new String[]{String.valueOf(unUploadPartIndex), String.valueOf(partCount)};
    }

    public String[] determinUploadedPart(User user, String filename, String fileDigest, long fileSize) throws WCMException {
        DebugTimer timer = new DebugTimer();
        String savedFilename = this.getSavedFileName(user.getId(), filename);
        int unUploadPartIndex = this.getMinPartIndexUnUploaded(savedFilename, fileDigest);
        int partCount = (int)Math.ceil((double)fileSize / 524288.0);
        if (unUploadPartIndex == 0) {
            int len = partCount;
            for (int i = 0; i < len; ++i) {
                BigFilePart part = new BigFilePart();
                part.setPartIndex(i + 1);
                part.setFileDigest(fileDigest);
                part.setFilename(savedFilename);
                part.setPartCount(partCount);
                part.save(user);
            }
            unUploadPartIndex = 1;
        }
        return new String[]{String.valueOf(unUploadPartIndex), String.valueOf(partCount)};
    }

    private int getNextPartIndexUnUploded(String sSavedFileName, String fileDigest) throws WCMException {
        FileService savedFile = new FileService(this.BF_DIR, sSavedFileName);
        if (!savedFile.exists()) {
            return 0;
        }
        BFPartDataHelper partHelper = new BFPartDataHelper(CMyFile.extractMainFileName(sSavedFileName));
        FileStore[] files = new FileService(partHelper.BF_INDEX_PATH).listFiles();
        for (int i = 0; i < files.length; ++i) {
            FileStore file = files[i];
            if (file.exists()) {
                Properties properties = new Properties();
                try {
                    properties.load(file.getInputStream());
                }
                catch (IOException e) {
                    throw new WCMException("\u8bfb\u6587\u4ef6\u9519\u8bef", e);
                }
                boolean bUploaded = "1".equals(properties.getProperty("Uploaded", "0"));
                if (bUploaded) continue;
            }
            return i;
        }
        return files.length;
    }

    private int getMinPartIndexUnUploaded(String filename, String fileDigest) throws WCMException {
        FileService savedFile = new FileService(this.BF_DIR, filename);
        if (!savedFile.exists()) {
            return 0;
        }
        String sql = "select min(PARTINDEX) from XWCMBIGFILEPART where FILENAME=? and FILEDIGEST=? and UPLOADED=0";
        DBManager dbman = DBManager.getDBManager();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            int partIndex = 0;
            conn = dbman.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, filename);
            pstmt.setString(2, fileDigest);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                partIndex = rs.getInt(1);
            }
            int n = partIndex;
            return n;
        }
        catch (Exception e) {
            throw new WCMException(40, "Failed to get partindex.", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbman.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] saveData2File(User user, PartData partData) throws WCMException {
        String sSavedFilenName = this.getSavedFileName(user.getId(), partData.filename);
        BFPartDataHelper partHelper = new BFPartDataHelper(CMyFile.extractMainFileName(sSavedFilenName));
        if (!new FileService(partHelper.BF_PATH).exists()) {
            return new String[]{"0", "0"};
        }
        int nPartCount = partHelper.getPartCount(partData);
        byte[] data = BASE64DecoderStream.decode(partData.data);
        String digest = FileUploadHelper.digestDataWithMD5(data);
        String partDigest = partData.partDigest;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("digest: " + digest));
            LOG.debug((Object)("partDigest: " + partDigest));
        }
        int partIndex = partData.partIndex;
        boolean writed = false;
        if (digest.equals(partDigest)) {
            FileService savedFile = new FileService(this.BF_DIR, sSavedFilenName);
            long startPointer = (long)(partData.partIndex - 1) * 524288L;
            RandomAccessFile raf = null;
            for (int retryTimes = 5; !writed && retryTimes >= 0; --retryTimes) {
                try {
                    raf = new RandomAccessFile(new FileWrapper(savedFile), "rw");
                    raf.seek(startPointer);
                    raf.write(data);
                }
                catch (Exception ex) {
                    if (retryTimes == 0) {
                        LOG.error((Object)"Failed to write data to file.", (Throwable)ex);
                    }
                }
                finally {
                    if (raf != null) {
                        try {
                            raf.close();
                        }
                        catch (Exception ex) {}
                    }
                }
                try {
                    savedFile = new FileService(this.BF_DIR, sSavedFilenName);
                    raf = new RandomAccessFile(new FileWrapper(savedFile), "r");
                    raf.seek(startPointer);
                    byte[] writedData = new byte[data.length];
                    int len = raf.read(writedData);
                    if (len == -1) {
                        len = (int)(raf.getFilePointer() - startPointer);
                        digest = FileUploadHelper.digestDataWithMD5(writedData, 0, len);
                    } else {
                        digest = FileUploadHelper.digestDataWithMD5(writedData);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("check digest: " + digest));
                    }
                    writed = digest.equals(partDigest);
                }
                catch (Exception e) {
                    LOG.error((Object)"Failed to check.", (Throwable)e);
                }
                finally {
                    if (raf != null) {
                        try {
                            raf.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                this.sleepAWhile(200);
            }
        }
        if (writed) {
            boolean finished = partIndex >= nPartCount;
            partHelper.saveBFParted(partData);
            ++partIndex;
            if (finished) {
                String sSavedFileName = this.getSavedFileName(user.getId(), partData.filename);
                boolean fileOK = this.randomCheck(sSavedFileName, partData.filename, partData.fileDigest, nPartCount);
                if (!fileOK) {
                    LOG.warn((Object)"The file final check failed. Unmatched file.");
                    return new String[]{"0", "0"};
                }
                partHelper.deleteBigFilePart();
            }
        } else {
            int tryUploadCount = partHelper.getTryUploadCount(partData);
            if (tryUploadCount < 10) {
                partHelper.saveBFPartFail(partData, ++tryUploadCount);
            } else {
                throw new WCMException(50, "Failed to upload the file data.");
            }
        }
        return new String[]{String.valueOf(partIndex), String.valueOf(nPartCount)};
    }

    private boolean randomCheck(String _sSavedFileName, String originalName, String fileDigest, int partCount) throws WCMException {
        FileService file = new FileService(this.BF_DIR, _sSavedFileName);
        long filesize = file.length();
        int count = (int)Math.ceil((double)filesize / 524288.0);
        if (count != partCount) {
            return false;
        }
        RandPartDigest randParDigest = FileUploadHelper.getRandDigest(new FileWrapper(file), originalName, filesize, partCount);
        if (randParDigest == null) {
            return false;
        }
        count = randParDigest.getPartCount();
        int[] partIndexes = randParDigest.getPartIndexes();
        String[] partDigests = randParDigest.getPartDigests();
        for (int i = 0; i < count; ++i) {
            int partIndex = partIndexes[i];
            String partDigest = partDigests[i];
            BFPartDataHelper partHelper = new BFPartDataHelper(CMyFile.extractMainFileName(_sSavedFileName));
            Map<String, String> part = partHelper.getBFPartInfo(_sSavedFileName, partIndex);
            if (part != null && partDigest.equals(part.get("PartDigest"))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RandPartDigest getRandDigest(File file, String originalName, long filesize, int partCount) {
        RandPartDigest result = null;
        RandomAccessFile raf = null;
        try {
            int checkCount;
            int len;
            raf = new RandomAccessFile(file, "r");
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = originalName.getBytes("GBK");
            digest.update(buffer);
            buffer = String.valueOf(filesize).getBytes();
            digest.update(buffer);
            int buffSize = 10240;
            buffer = new byte[buffSize];
            if (filesize > 0x100000L) {
                for (len = 0x100000; len > buffSize; len -= buffSize) {
                    raf.read(buffer);
                    digest.update(buffer);
                }
                if (len > 0) {
                    raf.read(buffer, 0, len);
                    digest.update(buffer, 0, len);
                }
                raf.seek(filesize - 0x100000L);
                len = -1;
                while ((len = raf.read(buffer)) != -1) {
                    digest.update(buffer, 0, len);
                }
            } else {
                len = -1;
                while ((len = raf.read(buffer)) != -1) {
                    digest.update(buffer, 0, len);
                }
            }
            result = new RandPartDigest(checkCount);
            result.setFileDigest(FileUploadHelper.byteToHexString(digest.digest()));
            Random random = new Random(System.currentTimeMillis());
            for (checkCount = Math.min(partCount, 10); checkCount > 0; --checkCount) {
                int partIndex = random.nextInt(partCount);
                raf.seek((long)partIndex * 524288L);
                if (partIndex + 1 == partCount) {
                    int len2 = -1;
                    while ((len2 = raf.read(buffer)) != -1) {
                        digest.update(buffer, 0, len2);
                    }
                } else {
                    int expectedCount;
                    for (expectedCount = 524288; expectedCount > buffSize; expectedCount -= buffSize) {
                        raf.read(buffer);
                        digest.update(buffer);
                    }
                    if (expectedCount > 0) {
                        raf.read(buffer, 0, expectedCount);
                        digest.update(buffer, 0, expectedCount);
                    }
                }
                String partDigest = FileUploadHelper.byteToHexString(digest.digest());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(partIndex + 1 + ":" + partDigest));
                }
                result.setPartDigest(partIndex + 1, partDigest);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to calc rand part digest.", (Throwable)e);
            RandPartDigest randPartDigest = null;
            return randPartDigest;
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    private static String byteToHexString(byte[] data) {
        int len = data.length;
        StringBuffer result = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            byte oneByte = data[i];
            result.append(HEX_DIGITS[oneByte >>> 4 & 0xF]);
            result.append(HEX_DIGITS[oneByte & 0xF]);
        }
        return result.toString();
    }

    private static String digestDataWithMD5(byte[] data) {
        return FileUploadHelper.digestDataWithMD5(data, 0, data.length);
    }

    private static String digestDataWithMD5(byte[] data, int offset, int length) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(data, offset, length);
            return FileUploadHelper.byteToHexString(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Uh-oh~~~, No MD5 digest?");
            }
            return new CMyEncrypt().getMD5OfStr(new String(data, offset, length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPartData(String filename) {
        String sql = "delete from XWCMBIGFILEPART where FILENAME=?";
        DBManager dbman = DBManager.getDBManager();
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = dbman.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, filename);
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to clear file partdata.", (Throwable)e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbman.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void sleepAWhile(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private BigFilePart findPart(String savedFilename, int partIndex) throws WCMException {
        WCMFilter filter = new WCMFilter("", "FILENAME=? AND PARTINDEX=?", "", "BIGFILEPARTID,PARTDIGEST,TRYUPLOADCOUNT,PARTCOUNT");
        filter.addSearchValues(savedFilename);
        filter.addSearchValues(partIndex);
        filter.setMaxRowNumber(1);
        BigFileParts parts = new BigFileParts();
        parts.open(filter);
        if (parts.size() == 1) {
            return (BigFilePart)parts.getAt(0);
        }
        return null;
    }

    public String getSavedFileName(int userId, String filename) {
        String fileInfo = userId + "#" + filename;
        return "bf" + fileInfo.hashCode() + "." + CMyFile.extractFileExt(filename);
    }

    static {
        ALLOW_UPLOAD_FILES = new HashSet(64);
    }
}

