/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.mina;

import com.trs.dev4.jdk16.mina.IMessage;
import com.trs.dev4.jdk16.mina.impl.MessageClientSessionHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageClient
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(MessageClient.class);
    private MessageClientSessionHandler messageClientSessionHandler;
    private IoSession session;
    private NioSocketConnector connector = new NioSocketConnector();
    private String hostName;
    private int port;
    private static final long TIME_OUT = 300000L;
    private boolean running = true;
    private int tryTimes = 10;

    @Override
    public void start() {
        this.connect();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                MessageClient.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error(" Client sleep exception: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void connect() {
        this.connector.setConnectTimeoutMillis(300000L);
        this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
        this.connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        this.connector.setHandler((IoHandler)this.messageClientSessionHandler);
        int i = 0;
        while (i < this.tryTimes) {
            try {
                ConnectFuture future = this.connector.connect((SocketAddress)new InetSocketAddress(this.hostName, this.port));
                future.awaitUninterruptibly();
                this.session = future.getSession();
                break;
            }
            catch (RuntimeIoException e) {
                logger.error("Failed to connect,hostName: " + this.hostName + ",port: " + this.port + "-" + e.getMessage(), (Throwable)e);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    logger.error("Thread.sleep(5000) failed: " + e1.getMessage(), (Throwable)e1);
                }
                ++i;
            }
        }
    }

    public void send(IMessage message) {
        if (this.session != null && this.session.isConnected()) {
            this.session.write((Object)message);
        }
    }

    public void close() {
        if (this.session != null) {
            if (this.session.isConnected()) {
                this.session.close(true);
            }
            this.connector.dispose();
        }
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void shutdown() {
        this.running = false;
        this.close();
    }

    public void setTryTimes(int tryTimes) {
        this.tryTimes = tryTimes;
    }

    public MessageClientSessionHandler getMessageClientSessionHandler() {
        return this.messageClientSessionHandler;
    }

    public void setMessageClientSessionHandler(MessageClientSessionHandler messageClientSessionHandler) {
        this.messageClientSessionHandler = messageClientSessionHandler;
    }
}

